/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.SystemConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SystemConfigurationUtil
implements ConfigurationListener {
    public static final String PROP_SERVER_MODE = "com.sun.identity.common.serverMode";
    private static final String SVC_PLATFORM = "PLATFORM";
    private static final String SVC_NAMING = "NAMING";
    private static boolean ignoreNaming = false;
    private static ConfigurationInstance platformConfig;
    private static ConfigurationInstance namingConfig;
    private static String authenticationURL;
    private static List cookieDomains;
    private static List serverList;
    private static List siteList;
    private static Hashtable serverToIdTable;
    private static Hashtable idToServerTable;
    private static boolean platformNamingInitialized;

    private SystemConfigurationUtil() {
    }

    private static Debug getDebug() {
        return Debug.getInstance((String)"libSystemConfiguration");
    }

    public static String getAuthenticationURL() throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        return authenticationURL;
    }

    public static List getCookieDomains() throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        return cookieDomains;
    }

    public static List getServerList() throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        return serverList;
    }

    public static List getSiteList() throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        return siteList;
    }

    public static boolean isServerMode() {
        return Boolean.valueOf(System.getProperty(PROP_SERVER_MODE, SystemConfigurationUtil.getProperty(PROP_SERVER_MODE, "false")));
    }

    public static URL getServiceURL(String serviceName, String protocol, String hostname, int port, String uri) throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        if (protocol == null || protocol.length() == 0 || hostname == null || hostname.length() == 0) {
            throw new SystemConfigurationException("missingProtHost");
        }
        String name = "iplanet-am-naming-" + serviceName.toLowerCase() + "-url";
        Set values = null;
        try {
            values = (Set)namingConfig.getConfiguration(null, null).get(name);
        }
        catch (ConfigurationException cex) {
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.getServiceURL:", (Throwable)((Object)cex));
        }
        if (values == null || values.isEmpty()) {
            Object[] data = new Object[]{serviceName};
            throw new SystemConfigurationException("noServiceURL", data);
        }
        String url = (String)values.iterator().next();
        if (url != null) {
            if (url.indexOf("%") != -1 && !SystemConfigurationUtil.validate(protocol, hostname, port, uri)) {
                Object[] data = new Object[]{serviceName};
                throw new SystemConfigurationException("noServiceURL", data);
            }
            int idx = url.indexOf("%protocol");
            if (idx != -1) {
                url = url.substring(0, idx) + protocol + url.substring(idx + "%protocol".length(), url.length());
            }
            if ((idx = url.indexOf("%host")) != -1) {
                url = url.substring(0, idx) + hostname + url.substring(idx + "%host".length(), url.length());
            }
            if ((idx = url.indexOf("%port")) != -1) {
                url = url.substring(0, idx) + port + url.substring(idx + "%port".length(), url.length());
            }
            if (uri != null && (idx = url.indexOf("%uri")) != -1) {
                url = url.substring(0, idx) + uri + url.substring(idx + "%uri".length(), url.length());
            }
            try {
                return new URL(url);
            }
            catch (MalformedURLException muex) {
                Object[] data = new Object[]{serviceName};
                throw new SystemConfigurationException("noServiceURL", data);
            }
        }
        Object[] data = new Object[]{serviceName};
        throw new SystemConfigurationException("noServiceURL", data);
    }

    public static String getServerID(String protocol, String hostname, int port, String uri) throws SystemConfigurationException {
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        if (protocol == null || protocol.length() == 0 || hostname == null || hostname.length() == 0) {
            throw new SystemConfigurationException("missingProtHost");
        }
        String server = uri != null ? protocol + ":" + "//" + hostname + ":" + port + uri : protocol + ":" + "//" + hostname + ":" + port;
        String serverID = (String)serverToIdTable.get(server = server.toLowerCase());
        if (serverID == null) {
            Object[] data = new Object[]{server};
            throw new SystemConfigurationException("noServerID", data);
        }
        return serverID;
    }

    public static String getServerFromID(String id) throws SystemConfigurationException {
        String server;
        if (!platformNamingInitialized) {
            SystemConfigurationUtil.initPlatformNaming();
        }
        if ((server = (String)idToServerTable.get(id)) == null) {
            Object[] data = new Object[]{id};
            throw new SystemConfigurationException("noServerFromID", data);
        }
        return server;
    }

    public static void initializeProperties(Properties properties) {
        SystemPropertiesManager.initializeProperties((Properties)properties);
    }

    public static void initializeProperties(String propertyName, String propertyValue) {
        SystemPropertiesManager.initializeProperties((String)propertyName, (String)propertyValue);
    }

    public static String getProperty(String propertyName) {
        return SystemPropertiesManager.get((String)propertyName);
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String value = SystemPropertiesManager.get((String)propertyName);
        return value == null ? defaultValue : value;
    }

    private static void storeServerList(Set servers) {
        if (servers == null || servers.isEmpty()) {
            serverList = Collections.EMPTY_LIST;
            serverToIdTable = null;
            idToServerTable = null;
            return;
        }
        int serverSize = servers.size();
        serverList = new ArrayList(serverSize);
        serverToIdTable = new Hashtable(serverSize);
        idToServerTable = new Hashtable(serverSize);
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            String serverEntry = (String)iter.next();
            int index = serverEntry.indexOf("|");
            if (index != -1) {
                String server = serverEntry.substring(0, index).toLowerCase();
                String serverId = serverEntry.substring(index + 1, serverEntry.length());
                if ((index = serverId.indexOf("|")) != -1) {
                    serverId = serverId.substring(0, 2);
                }
                serverList.add(server);
                idToServerTable.put(serverId, server);
                serverToIdTable.put(server, serverId);
                continue;
            }
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.storeServerList: Platform Server List entry is invalid:" + serverEntry);
        }
    }

    private static void storeSiteList(Set sites) {
        if (sites == null || sites.isEmpty()) {
            siteList = Collections.EMPTY_LIST;
            return;
        }
        siteList = new ArrayList(sites.size());
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            String siteEntry = (String)iter.next();
            int index = siteEntry.indexOf("|");
            if (index != -1) {
                String site = siteEntry.substring(0, index).toLowerCase();
                if (SystemConfigurationUtil.getDebug().messageEnabled()) {
                    SystemConfigurationUtil.getDebug().message("SystemConfigUtil.storeSiteList: add site" + site);
                }
                siteList.add(site);
                continue;
            }
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.storeSiteList: Platform Server List entry is invalid:" + siteEntry);
        }
    }

    private static boolean validate(String protocol, String host, int port, String uri) {
        String server = uri != null ? protocol + "://" + host + ":" + port + uri : protocol + "://" + host + ":" + port;
        server = server.toLowerCase();
        return serverList.contains(server);
    }

    public void configChanged(ConfigurationActionEvent event) {
        if (SystemConfigurationUtil.getDebug().messageEnabled()) {
            SystemConfigurationUtil.getDebug().message("SystemConfigurationUtil.configChanged: type = " + event.getType() + ", configuration name = " + event.getConfigurationName() + ", component name = " + event.getComponentName() + ", realm = " + event.getRealm());
        }
        SystemConfigurationUtil.update();
    }

    private static synchronized void update() {
        try {
            Map avPairs = platformConfig.getConfiguration(null, null);
            if (avPairs == null || avPairs.isEmpty()) {
                authenticationURL = null;
                cookieDomains = Collections.EMPTY_LIST;
                serverList = Collections.EMPTY_LIST;
                serverToIdTable = null;
                idToServerTable = null;
            } else {
                Set values = (Set)avPairs.get("iplanet-am-platform-login-url");
                authenticationURL = values == null || values.isEmpty() ? null : (String)values.iterator().next();
                values = (Set)avPairs.get("iplanet-am-platform-cookie-domains");
                if (values == null || values.isEmpty()) {
                    cookieDomains = Collections.EMPTY_LIST;
                } else {
                    cookieDomains = new ArrayList();
                    cookieDomains.addAll(values);
                }
                if (SystemConfigurationUtil.getDebug().messageEnabled()) {
                    SystemConfigurationUtil.getDebug().message("SystemConfigUtil.update: servers=" + (Set)avPairs.get("iplanet-am-platform-server-list"));
                    SystemConfigurationUtil.getDebug().message("SystemConfigUtil.update: sites=" + (Set)avPairs.get("iplanet-am-platform-site-list"));
                }
                if ((values = (Set)avPairs.get("iplanet-am-platform-server-list")) == null || values.isEmpty()) {
                    values = (Set)avPairs.get("iplanet-am-platform-site-list");
                } else {
                    values.addAll((Set)avPairs.get("iplanet-am-platform-site-list"));
                }
                SystemConfigurationUtil.storeServerList(values);
                SystemConfigurationUtil.storeSiteList((Set)avPairs.get("iplanet-am-platform-site-list"));
            }
        }
        catch (ConfigurationException ex) {
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.update:", (Throwable)((Object)ex));
        }
    }

    private static synchronized void initPlatformNaming() {
        if (platformNamingInitialized) {
            return;
        }
        try {
            platformConfig = ConfigurationManager.getConfigurationInstance(SVC_PLATFORM);
            platformConfig.addListener(new SystemConfigurationUtil());
        }
        catch (ConfigurationException cex) {
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.static: unable to get platform configuration.", (Throwable)((Object)cex));
        }
        try {
            namingConfig = ConfigurationManager.getConfigurationInstance(SVC_NAMING);
        }
        catch (ConfigurationException cex) {
            SystemConfigurationUtil.getDebug().error("SystemConfigurationUtil.static: unable to get naming configuration.", (Throwable)((Object)cex));
        }
        SystemConfigurationUtil.update();
        platformNamingInitialized = true;
    }

    static {
        serverToIdTable = null;
        idToServerTable = null;
        platformNamingInitialized = false;
    }
}

