/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.key;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.EncInfo;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.KeyInfoType;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataElement;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataType;
import com.sun.identity.liberty.ws.meta.jaxb.KeyDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.xmlsig.KeyProvider;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyUtil {
    private static KeyProvider kp = null;
    protected static Hashtable encHash = new Hashtable();
    protected static Hashtable sigHash = new Hashtable();

    private KeyUtil() {
    }

    public static KeyProvider getKeyProviderInstance() {
        return kp;
    }

    public static String getSigningCertAlias(BaseConfigType baseConfig) {
        String alias;
        Map map = IDFFMetaUtils.getAttributes(baseConfig);
        List list = (List)map.get("signingCertAlias");
        if (list != null && !list.isEmpty() && (alias = (String)list.get(0)) != null && alias.length() != 0 && kp != null) {
            return alias;
        }
        return null;
    }

    public static PrivateKey getDecryptionKey(BaseConfigType baseConfig) {
        String alias;
        Map map = IDFFMetaUtils.getAttributes(baseConfig);
        List list = (List)map.get("encryptionCertAlias");
        PrivateKey decryptionKey = null;
        if (list != null && !list.isEmpty() && (alias = (String)list.get(0)) != null && alias.length() != 0 && kp != null) {
            decryptionKey = kp.getPrivateKey(alias);
        }
        return decryptionKey;
    }

    public static X509Certificate getVerificationCert(ProviderDescriptorType providerDescriptor, String entityID, boolean isIDP) {
        String index;
        X509Certificate cert;
        String role;
        String string = role = isIDP ? "idp" : "sp";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("KeyUtil.getVerificationCert: Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((cert = (X509Certificate)sigHash.get(index = entityID.trim() + "|" + role)) != null) {
            return cert;
        }
        if (providerDescriptor == null) {
            FSUtils.debug.error("KeyUtil.getVerificationCert: Null ProviderDescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(providerDescriptor, "signing");
        if (kd == null) {
            FSUtils.debug.error("KeyUtil.getVerificationCert: No signing KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        cert = KeyUtil.getCert(kd);
        if (cert == null) {
            FSUtils.debug.error("KeyUtil.getVerificationCert: No signing cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        sigHash.put(index, cert);
        return cert;
    }

    public static EncInfo getEncInfo(ProviderDescriptorType providerDescriptor, String entityID, boolean isIDP) {
        PublicKey pk;
        String index;
        EncInfo encInfo;
        String role;
        String string = role = isIDP ? "idp" : "sp";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("KeyUtil.getEncInfo: Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((encInfo = (EncInfo)encHash.get(index = entityID.trim() + "|" + role)) != null) {
            return encInfo;
        }
        if (providerDescriptor == null) {
            FSUtils.debug.error("KeyUtil.getEncInfo: Null ProviderDescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        KeyDescriptorType kd = KeyUtil.getKeyDescriptor(providerDescriptor, "encryption");
        if (kd == null) {
            FSUtils.debug.error("KeyUtil.getEncInfo: No encryption KeyDescriptor for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        X509Certificate cert = KeyUtil.getCert(kd);
        if (cert == null) {
            FSUtils.debug.error("KeyUtil.getEncInfo: No encryption cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        String algorithm = kd.getEncryptionMethod();
        int keySize = kd.getKeySize().intValue();
        if (algorithm == null || algorithm.length() == 0) {
            algorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            keySize = 128;
        }
        if ((pk = cert.getPublicKey()) != null) {
            encInfo = new EncInfo(pk, algorithm, keySize);
        }
        if (encInfo != null) {
            encHash.put(index, encInfo);
        }
        return encInfo;
    }

    public static KeyDescriptorType getKeyDescriptor(ProviderDescriptorType providerDescriptor, String usage) {
        if (providerDescriptor == null) {
            return null;
        }
        List list = providerDescriptor.getKeyDescriptor();
        Iterator iter = list.iterator();
        KeyDescriptorType kd = null;
        String use = null;
        KeyDescriptorType noUsageKD = null;
        while (iter.hasNext()) {
            kd = (KeyDescriptorType)iter.next();
            use = kd.getUse();
            if ((use == null || use.trim().length() == 0) && noUsageKD == null) {
                noUsageKD = kd;
                continue;
            }
            if (use.trim().toLowerCase().equals(usage)) break;
            kd = null;
        }
        if (kd != null) {
            return kd;
        }
        return noUsageKD;
    }

    public static X509Certificate getCert(ProviderDescriptorType providerDescriptor, String usage) {
        return KeyUtil.getCert(KeyUtil.getKeyDescriptor(providerDescriptor, usage));
    }

    public static X509Certificate getCert(KeyDescriptorType kd) {
        if (kd == null) {
            return null;
        }
        KeyInfoType ki = kd.getKeyInfo();
        if (ki == null) {
            FSUtils.debug.error("KeyUtil.getCert: No KeyInfo.");
            return null;
        }
        X509DataElement data = (X509DataElement)ki.getContent().get(0);
        byte[] bt = ((X509DataType.X509Certificate)data.getX509IssuerSerialOrX509SKIOrX509SubjectName().get(0)).getValue();
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            FSUtils.debug.error("KeyUtil.getCert: Unable to get CertificateFactory for X.509 type", (Throwable)ce);
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bt);
        X509Certificate retCert = null;
        try {
            while (bais.available() > 0) {
                retCert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException ce) {
            FSUtils.debug.error("KeyUtil.getCert: Unable to generate certificate from byte array input stream.", (Throwable)ce);
            return null;
        }
        return retCert;
    }

    static {
        try {
            kp = (KeyProvider)Class.forName(SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.keyprovider.class")).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            FSUtils.debug.error("KeyUtil static block: Couldn't find the class.", (Throwable)cnfe);
            kp = null;
        }
        catch (InstantiationException ie) {
            FSUtils.debug.error("KeyUtil static block: Couldn't instantiate the key provider instance.", (Throwable)ie);
            kp = null;
        }
        catch (IllegalAccessException iae) {
            FSUtils.debug.error("KeyUtil static block: Couldn't access the default constructor.", (Throwable)iae);
            kp = null;
        }
    }
}

