/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.login.FSPostLogin;
import com.sun.identity.federation.login.FSPostLoginException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSConsentHandler
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String lrurl = null;
        if (action != null && action.trim().equalsIgnoreCase("cancel")) {
            FSUtils.debug.message("FSConsentHandler:: user pressed cancel proceding to lrurl");
            lrurl = request.getParameter("RelayState");
        } else {
            try {
                FSPostLogin postLogin = new FSPostLogin();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSConsentHandler:: selected provider is " + request.getParameter("cotkey"));
                }
                lrurl = postLogin.doConsentToIntro(request);
            }
            catch (FSPostLoginException fsPostExp) {
                FSUtils.debug.error("FSConsentHandler::FSPostLogin Exception", (Throwable)((Object)fsPostExp));
            }
        }
        if (lrurl != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSConsentHandler:: Redirecting to  " + lrurl);
            }
            FSUtils.forwardRequest(request, response, lrurl);
        } else {
            FSUtils.debug.error("FSConsentHandler:: LRURL is null in request ");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

