/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.login.FSPreLoginException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.liberty.LibertyManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSPreLogin {
    private String realm = null;
    private static String postLoginURL = null;
    private static String loginURL = null;
    private static String amserverURI = null;
    private static String fedCookieName = SystemConfigurationUtil.getProperty("com.sun.identity.federation.fedCookieName");
    private boolean doLocalAuth = false;
    private String errorPage = null;
    private String homePage = null;
    private String commonLoginPage = null;
    private static IDFFMetaManager metaManager = null;

    private String removeMetaGotoOrg(HttpServletRequest httpRequest) {
        Enumeration paramEnum = httpRequest.getParameterNames();
        String returnString = null;
        while (paramEnum.hasMoreElements()) {
            String paramKey = (String)paramEnum.nextElement();
            if (paramKey.equalsIgnoreCase("metaAlias") || paramKey.equalsIgnoreCase("goto") || paramKey.equalsIgnoreCase("org")) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSPreLogin::removeMetaGotoOrg found metaAlias or gotoKey or org.");
                continue;
            }
            String paramValue = httpRequest.getParameter(paramKey);
            StringBuffer paramStringBuf = new StringBuffer().append(paramKey).append('=').append(paramValue);
            if (returnString == null || returnString.length() < 1) {
                returnString = paramStringBuf.toString();
                continue;
            }
            returnString = returnString + '&' + paramStringBuf.toString();
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogin::removeMetaGotoOrg returning with " + returnString);
        }
        return returnString;
    }

    private String getLoginURL(boolean showFederatePage, String metaAlias, HttpServletRequest request) {
        StringBuffer localLoginURLBuf = new StringBuffer(loginURL).append('?').append("arg").append('=').append("newsession");
        String returnURL = localLoginURLBuf + '&' + this.getQueryString(showFederatePage, metaAlias, request);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogin::getLoginURL returning with URL " + returnURL);
        }
        return returnURL;
    }

    private String getQueryString(boolean showFederatePage, String metaAlias, HttpServletRequest httpRequest) {
        FSUtils.debug.message("FSPreLogin::getQueryString called");
        String lrURL = httpRequest.getParameter("goto");
        String reqQueryString = this.removeMetaGotoOrg(httpRequest);
        if (lrURL == null || lrURL.length() <= 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::getQueryString.no goto in queryString.Assinging LRURL = " + this.homePage);
            }
            lrURL = this.homePage;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogin::getQueryString.RelayState =" + lrURL + " Required QueryString =" + reqQueryString);
        }
        String gotoURL = postLoginURL + '?' + "metaAlias" + '=' + metaAlias + '&' + "RelayState" + '=' + lrURL;
        if (showFederatePage) {
            gotoURL = gotoURL + '&' + "federate" + '=' + "false";
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogin::getQueryString.gotoURL =" + gotoURL);
        }
        gotoURL = URLEncDec.encode((String)gotoURL);
        StringBuffer returnURLBuf = new StringBuffer().append("org").append('=').append(this.realm);
        if (reqQueryString != null && reqQueryString.length() > 0) {
            returnURLBuf.append('&').append(reqQueryString);
        }
        returnURLBuf.append('&').append("goto").append('=').append(gotoURL);
        return returnURLBuf.toString();
    }

    private void setMetaInfo(String metaAlias, HttpServletRequest httpRequest) throws FSPreLoginException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogin::setMetaInfo called with metaAlias =" + metaAlias);
        }
        String authType = null;
        try {
            String hostedEntityID = null;
            String hostedProviderRole = "SP";
            if (metaManager == null) {
                FSUtils.debug.error("FSPreLogin::setMetaInfo meta manager is null. Cannot proceed so throwing error page");
                throw new FSPreLoginException("FSPreLogin:: could not get meta manager handle.");
            }
            hostedProviderRole = metaManager.getProviderRoleByMetaAlias(metaAlias);
            hostedEntityID = metaManager.getEntityIDByMetaAlias(metaAlias);
            this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            BaseConfigType hostedConfig = null;
            if (hostedProviderRole != null) {
                if (hostedProviderRole.equals("SP")) {
                    hostedConfig = metaManager.getSPDescriptorConfig(this.realm, hostedEntityID);
                } else if (hostedProviderRole.equals("IDP")) {
                    hostedConfig = metaManager.getIDPDescriptorConfig(this.realm, hostedEntityID);
                }
            }
            if (hostedConfig == null) {
                FSUtils.debug.error("FSPreLogin::setMetaInfo getDescriptorConfig retured null. Cannot proceed so throwing error page");
                throw new FSPreLoginException("FSPreLogin:: could not get sp config.");
            }
            Map attributes = IDFFMetaUtils.getAttributes(hostedConfig);
            this.homePage = IDFFMetaUtils.getFirstAttributeValue(attributes, "providerHomePageURL");
            authType = IDFFMetaUtils.getFirstAttributeValue(attributes, "authType");
            this.commonLoginPage = FSServiceUtils.getCommonLoginPageURL(httpRequest, hostedConfig);
            this.errorPage = FSServiceUtils.getErrorPageURL(httpRequest, hostedConfig, metaAlias);
            if (authType != null && authType.equalsIgnoreCase("local")) {
                this.doLocalAuth = true;
            } else {
                FSUtils.debug.message("FSPreLogin::setMetaInfo authType=" + authType + "Setting authType to default false.");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::setMetaInfo.realm = " + this.realm + " doLocalAuth = " + this.doLocalAuth);
            }
        }
        catch (IDFFMetaException allianExp) {
            FSUtils.debug.error("FSPreLogin::setMetaInfo. IDFFMetaException caught. ", (Throwable)((Object)allianExp));
            throw new FSPreLoginException("FSPreLogin::IDFFMetaException. ");
        }
        catch (Exception exp) {
            FSUtils.debug.error("FSPreLogin::setMetaInfo. General Exception caught. ", (Throwable)exp);
            throw new FSPreLoginException("Prelogin exception");
        }
    }

    private Map getCookieMap(Cookie[] cookieArray) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                cookieMap.put(cookieArray[i].getName(), cookieArray[i].getValue());
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSPreLogin::getCookieMap with key " + cookieArray[i].getName() + " and value " + cookieArray[i].getValue());
            }
        }
        return cookieMap;
    }

    private void setResponse(HttpServletResponse response, Map retMap) {
        FSUtils.debug.message("FSPreLogin::setResponse called.");
        Map headerMap = (Map)retMap.get("headerKey");
        Iterator hdrNames = headerMap.keySet().iterator();
        while (hdrNames.hasNext()) {
            String name = hdrNames.next().toString();
            String value = (String)headerMap.get(name);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::setResponse with header with name " + name + " with value " + value);
            }
            response.addHeader(name, value);
        }
        if (!headerMap.containsKey("Cache-Control")) {
            response.addHeader("Cache-Control", "no-cache");
        }
        if (!headerMap.containsKey("Pragma")) {
            response.addHeader("Pragma", "no-cache");
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response) {
        try {
            FSUtils.forwardRequest(request, response, this.errorPage);
        }
        catch (Exception exp) {
            FSUtils.debug.error("FSPreLogin:: sendError Error during sending error page");
        }
    }

    private boolean validateISCookie(HttpServletRequest request) {
        boolean isValidToken = false;
        FSUtils.debug.message("FSPreLogin::validateISCookie.Called ");
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoToken = sessionProvider.getSession(request);
            isValidToken = sessionProvider.isValid(ssoToken);
        }
        catch (SessionException ssoe) {
            FSUtils.debug.message("FSPreLogin::validateISCookie():", (Throwable)((Object)ssoe));
        }
        catch (Exception ex) {
            FSUtils.debug.message("FSPreLogin::validateISCookie():", (Throwable)ex);
        }
        return isValidToken;
    }

    private Map setHeaderMap(HttpServletRequest httpRequest) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hn = headerNames.nextElement().toString();
            String hv = httpRequest.getHeader(hn);
            headerMap.put(hn, hv);
            if (!FSUtils.debug.messageEnabled()) continue;
            FSUtils.debug.message("FSLoginHelper.setHeaderMap() : name :: " + hn + " :: value :: " + hv);
        }
        return headerMap;
    }

    private Map createSSOMap(String authLevel, String metaAlias, boolean isFedCookiePresent, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws FSPreLoginException {
        try {
            String actionOnNoFedCookie;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::createSSOMap called with authLevel =" + authLevel + " metaAlias =" + metaAlias);
            }
            if (!isFedCookiePresent && (actionOnNoFedCookie = httpRequest.getParameter("actionOnNoFedCookie")) != null && actionOnNoFedCookie.equals("locallogin")) {
                FSUtils.forwardRequest(httpRequest, httpResponse, this.getLoginURL(false, metaAlias, httpRequest));
                return null;
            }
            Map headerMap = this.setHeaderMap(httpRequest);
            FSLoginHelper loginHelper = new FSLoginHelper(httpRequest);
            String targetURL = httpRequest.getParameter("goto");
            if (targetURL == null || targetURL.length() <= 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::createSSOMap.no goto in queryString.Assinging targetURL = " + this.homePage);
                }
                targetURL = this.homePage;
            }
            Map retMap = loginHelper.createAuthnRequest(headerMap, targetURL, authLevel, metaAlias, null, isFedCookiePresent);
            String requestID = null;
            String responseData = (String)retMap.get("responseData");
            if (responseData != null && responseData.length() != 0) {
                return retMap;
            }
            requestID = (String)retMap.get("RequestID");
            String URL2 = (String)retMap.get("urlKey");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::createSSOMap requestID" + requestID + " URL " + URL2);
            }
            if (requestID != null && URL2 == null) {
                String queryString = this.getQueryString(true, metaAlias, httpRequest);
                String returnURL = this.commonLoginPage + '?' + queryString + '&' + "RequestID" + '=' + URLEncDec.encode((String)requestID) + '&' + "metaAlias" + '=' + httpRequest.getParameter("metaAlias");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::createSSOMap framedlogin url " + returnURL);
                }
                retMap.put("urlKey", returnURL);
            }
            return retMap;
        }
        catch (FSLoginHelperException exp) {
            FSUtils.debug.error("FSPreLogin::setMetaInfo. FSLoginHelperException Exception caught. ", (Throwable)((Object)exp));
            throw new FSPreLoginException("FSPreLogin::FSLoginHelperException");
        }
    }

    public void doPreLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            String responseData;
            String authLevelParam;
            FSUtils.debug.message("FSPreLogin::Entered doPreLogin");
            Cookie[] cookieArray = CookieUtils.getCookieArrayFromReq((HttpServletRequest)request);
            boolean isTokenValid = false;
            boolean isFedCookie = true;
            amserverURI = FSServiceUtils.getBaseURL(request);
            postLoginURL = amserverURI + "/postLogin";
            loginURL = amserverURI + "/UI/Login";
            String gotoOnFedCookieNoURL = request.getParameter("gotoOnFedCookieNo");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::gotoOnFedCookieNoURL=" + gotoOnFedCookieNoURL);
            }
            String returnURL = null;
            Map retMap = new HashMap();
            String metaAlias = request.getParameter("metaAlias");
            Map cookieMap = this.getCookieMap(cookieArray);
            this.setMetaInfo(metaAlias, request);
            if (LibertyManager.isLECPProfile(request)) {
                String headerName = LibertyManager.getLECPHeaderName();
                String headerValue = request.getHeader(headerName);
                response.setHeader(headerName, headerValue);
            }
            if (this.doLocalAuth) {
                FSUtils.debug.message("FSPreLogin::doPreLogin. do local auth is true ");
                returnURL = this.getLoginURL(false, metaAlias, request);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin. returning with url " + returnURL);
                }
                response.sendRedirect(returnURL);
                return;
            }
            if (cookieMap.containsKey(request)) {
                isTokenValid = true;
                FSUtils.debug.message("FSPreLogin::doPreLogin. Access Manager Token is valid");
            }
            boolean isFedCookiePresent = false;
            if (cookieMap.containsKey(fedCookieName)) {
                isFedCookiePresent = true;
                FSUtils.debug.message("FSPreLogin::doPreLogin. fedCookie is present");
                if (((String)cookieMap.get(fedCookieName)).equalsIgnoreCase("no")) {
                    isFedCookie = false;
                    FSUtils.debug.message("FSPreLogin::doPreLogin. fedCookie is no");
                }
            }
            if ((authLevelParam = request.getParameter("authlevel")) != null) {
                HttpSession httpSession = request.getSession();
                httpSession.setAttribute("authlevel", (Object)authLevelParam);
            }
            if (!isFedCookie) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken invalid andfedcookie no");
                }
                if (gotoOnFedCookieNoURL != null) {
                    response.sendRedirect(gotoOnFedCookieNoURL);
                } else {
                    returnURL = this.getLoginURL(false, metaAlias, request);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPreLogin::doPreLogin. returning with url " + returnURL);
                    }
                    FSUtils.forwardRequest(request, response, returnURL);
                }
                return;
            }
            if (isTokenValid) {
                if (authLevelParam != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken valid and fedcookie yes and dolocalauth false and authLevel present");
                    }
                    if ((retMap = this.createSSOMap(authLevelParam, metaAlias, isFedCookiePresent, request, response)) != null) {
                        this.setResponse(response, retMap);
                        responseData = (String)retMap.get("responseData");
                        if (responseData != null && responseData.length() != 0) {
                            response.getOutputStream().write(responseData.getBytes());
                            response.flushBuffer();
                        } else {
                            returnURL = (String)retMap.get("urlKey");
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + returnURL);
                            }
                            FSUtils.forwardRequest(request, response, returnURL);
                        }
                    }
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken valid andfedcookie yes and dolocalauth false and authLevel not present");
                }
                returnURL = this.getLoginURL(true, metaAlias, request);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + returnURL);
                }
                FSUtils.forwardRequest(request, response, returnURL);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogin::doPreLogin.In case where ISToken invalid andfedcookie yes");
            }
            if ((retMap = this.createSSOMap(authLevelParam, metaAlias, isFedCookiePresent, request, response)) != null) {
                this.setResponse(response, retMap);
                responseData = (String)retMap.get("responseData");
                if (responseData != null && responseData.length() != 0) {
                    response.getOutputStream().write(responseData.getBytes());
                    response.flushBuffer();
                } else {
                    returnURL = (String)retMap.get("urlKey");
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPreLogin::doPreLogin.returning with url " + returnURL);
                    }
                    FSUtils.forwardRequest(request, response, returnURL);
                }
            }
            return;
        }
        catch (FSPreLoginException preLoginExp) {
            FSUtils.debug.error("FSPreLogin::Exception in doPrelogin. ", (Throwable)((Object)preLoginExp));
            this.sendError(request, response);
        }
        catch (Exception exp) {
            FSUtils.debug.error("FSPreLogin::Exception in doPrelogin. ", (Throwable)exp);
            this.sendError(request, response);
        }
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

