/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSLogoutNotification
extends AbstractRequest {
    private String providerId;
    private NameIdentifier nameIdentifier;
    protected String sessionIndex;
    protected String xmlString;
    protected String signatureString;
    protected String id;
    private String relayState;
    protected Date notOnOrAfter;

    public FSLogoutNotification() {
        this.xmlString = null;
        this.signatureString = null;
        this.id = null;
        this.relayState = null;
        this.notOnOrAfter = null;
        this.setIssueInstant(new Date());
    }

    public FSLogoutNotification(Element root) throws FSMsgException {
        block30: {
            this.xmlString = null;
            this.signatureString = null;
            this.id = null;
            this.relayState = null;
            this.notOnOrAfter = null;
            String tag = null;
            if (root == null) {
                FSUtils.debug.message("FSLogoutNotification(Element): null input.");
                throw new FSMsgException("nullInput", null);
            }
            tag = root.getLocalName();
            if (tag == null || !tag.equals("LogoutRequest")) {
                FSUtils.debug.message("FSLogoutNotification(Element): wrong input");
                throw new FSMsgException("wrongInput", null);
            }
            String instantString = root.getAttribute("IssueInstant");
            if (instantString == null || instantString.length() == 0) {
                FSUtils.debug.message("LogoutRequest(Element): missing IssueInstant");
                Object[] args = new String[]{"IssueInstant"};
                throw new FSMsgException("missingAttribute", args);
            }
            try {
                this.issueInstant = DateUtils.stringToDate((String)instantString);
            }
            catch (Exception e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LogoutRequest(Element): could not parse IssueInstant:" + e.getMessage());
                }
                throw new FSMsgException("wrongInput", null);
            }
            String notAfter = root.getAttribute("NotOnOrAfter");
            if (notAfter != null && notAfter.length() != 0) {
                try {
                    this.notOnOrAfter = DateUtils.stringToDate((String)notAfter);
                }
                catch (Exception ex) {
                    if (!FSUtils.debug.messageEnabled()) break block30;
                    FSUtils.debug.message("LogoutRequest(Element): unable toparse not on or after", (Throwable)ex);
                }
            }
        }
        int length = 0;
        this.id = root.getAttribute("id");
        this.requestID = root.getAttribute("RequestID");
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList contentnl = root.getChildNodes();
        length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(XMLUtils.getElementValue((Element)((Element)child)));
                continue;
            }
            if (nodeName.equals("Signature")) continue;
            if (nodeName.equals("ProviderID")) {
                if (this.providerId != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutNotification (Element): should contain only one ProviderID.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (nodeName.equals("RelayState")) {
                if (this.relayState != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutNotification (Element): should contain only one relayState.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.relayState = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (nodeName.equals("NameIdentifier")) {
                try {
                    this.nameIdentifier = new NameIdentifier((Element)child);
                    continue;
                }
                catch (SAMLException ex) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutNotification (Element): SAMLException while nconstructing ameidentifier");
                    }
                    throw new FSMsgException("nameIdentifierCreateError", null, (Throwable)((Object)ex));
                }
            }
            if (nodeName.equals("SessionIndex")) {
                if (this.sessionIndex != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutNotification(Element): should contain only one SessionIndex.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.sessionIndex = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): invalid node" + nodeName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1((Element)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print((Node)root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    public FSLogoutNotification(String requestId, String providerID, NameIdentifier nameId, String relayState) throws FSMsgException {
        this.xmlString = null;
        this.signatureString = null;
        this.id = null;
        this.relayState = null;
        this.notOnOrAfter = null;
        this.setIssueInstant(new Date());
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.relayState = relayState;
        this.providerId = providerID;
        this.nameIdentifier = nameId;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSLogoutNotification.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">").append("\n");
        }
        String prefix = "";
        String uri = "";
        String uriSAML = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String instantString = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        if (this.notOnOrAfter == null) {
            this.notOnOrAfter = new Date(this.issueInstant.getTime() + 60000L);
        }
        String notAfter = DateUtils.toUTCDateFormat((Date)this.notOnOrAfter);
        if (this.requestID != null) {
            xml.append("<").append(prefix).append("LogoutRequest").append(uri).append(uriSAML);
            if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
                xml.append(" ").append("id").append('=').append("\"").append(this.id).append("\"").append(" ");
            }
            xml.append(" ").append("RequestID").append('=').append("\"").append(this.requestID).append("\"").append(" ").append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"");
            if (this.minorVersion == 2) {
                xml.append(" ").append("NotOnOrAfter").append('=').append("\"").append(notAfter).append("\"");
            }
            xml.append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator i = this.respondWiths.iterator();
                while (i.hasNext()) {
                    xml.append("<").append(prefix).append("RespondWith").append(">").append((String)i.next()).append("</").append(prefix).append("RespondWith").append(">");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    xml.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print((Node)this.signature);
                    xml.append(this.signatureString);
                }
            }
            xml.append("<").append(prefix).append("ProviderID").append(uri).append(">").append(this.providerId).append("</").append(prefix).append("ProviderID").append(">");
            if (this.nameIdentifier != null) {
                xml.append(this.nameIdentifier.toString());
            }
            if (this.sessionIndex != null && this.sessionIndex.length() != 0) {
                xml.append("<").append(prefix).append("SessionIndex").append(uri).append(">").append(this.sessionIndex).append("</").append(prefix).append("SessionIndex").append(">");
            }
            if (this.relayState != null && this.relayState.length() != 0) {
                xml.append("<").append(prefix).append("RelayState").append(uri).append(">").append(this.relayState).append("</").append(prefix).append("RelayState").append(">");
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.toString: requestID is null ");
            }
            throw new FSMsgException("nullRequestID", null);
        }
        xml.append("</").append(prefix).append("LogoutRequest").append(">");
        return xml.toString();
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public static FSLogoutNotification parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)FSUtils.debug);
        if (doc == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSLogoutNotification(root);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerID) {
        this.providerId = providerID;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setNameIdentifier(NameIdentifier nameId) {
        this.nameIdentifier = nameId;
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        urlEncodedAuthnReq.append("RequestID").append('=').append(URLEncDec.encode((String)this.requestID)).append('&').append("MajorVersion").append('=').append(this.majorVersion).append('&').append("MinorVersion").append('=').append(this.minorVersion).append('&');
        if (this.issueInstant != null) {
            urlEncodedAuthnReq.append("IssueInstant").append('=').append(URLEncDec.encode((String)DateUtils.toUTCDateFormat((Date)this.issueInstant))).append('&');
            if (this.minorVersion == 2) {
                this.notOnOrAfter = new Date(this.issueInstant.getTime() + 60000L);
                urlEncodedAuthnReq.append("NotOnOrAfter").append('=').append(URLEncDec.encode((String)DateUtils.toUTCDateFormat((Date)this.notOnOrAfter))).append('&');
            }
        } else {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: issueInstant missing");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        if (this.providerId != null && this.providerId.length() != 0) {
            urlEncodedAuthnReq.append("ProviderID").append('=').append(URLEncDec.encode((String)this.providerId)).append('&');
        }
        if (this.sessionIndex != null && this.sessionIndex.length() != 0) {
            urlEncodedAuthnReq.append("SessionIndex").append('=').append(URLEncDec.encode((String)this.sessionIndex)).append('&');
        }
        if (this.relayState != null && this.relayState.length() != 0) {
            urlEncodedAuthnReq.append("RelayState").append('=').append(URLEncDec.encode((String)this.relayState)).append('&');
        }
        if (this.nameIdentifier != null) {
            if (this.nameIdentifier.getName() != null && this.nameIdentifier.getName().length() != 0) {
                urlEncodedAuthnReq.append("Name").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getName())).append('&').append("NameIdentifier").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getName())).append('&');
            }
            if (this.nameIdentifier.getNameQualifier() != null && this.nameIdentifier.getNameQualifier().length() != 0) {
                urlEncodedAuthnReq.append("NameQualifier").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getNameQualifier())).append('&');
            }
            if (this.nameIdentifier.getFormat() != null && this.nameIdentifier.getFormat().length() != 0) {
                urlEncodedAuthnReq.append("NameFormat").append('=').append(URLEncDec.encode((String)this.nameIdentifier.getFormat())).append('&');
            }
        }
        return urlEncodedAuthnReq.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode((byte[])this.toXMLString().getBytes());
    }

    public static FSLogoutNotification parseURLEncodedRequest(HttpServletRequest request) throws FSMsgException {
        try {
            String relayState;
            String providerId;
            FSLogoutNotification retLogoutNotification = new FSLogoutNotification();
            String requestID = request.getParameter("RequestID");
            if (requestID == null) {
                Object[] args = new String[]{"RequestID"};
                throw new FSMsgException("missingAttribute", args);
            }
            retLogoutNotification.requestID = requestID;
            try {
                retLogoutNotification.majorVersion = Integer.parseInt(request.getParameter("MajorVersion"));
                FSUtils.debug.message("Majorversion : " + retLogoutNotification.majorVersion);
                retLogoutNotification.minorVersion = Integer.parseInt(request.getParameter("MinorVersion"));
                FSUtils.debug.message("Minorversion : " + retLogoutNotification.minorVersion);
            }
            catch (NumberFormatException ex) {
                FSUtils.debug.message("FSLogoutNotification. parseURLEncodedRequest:Major/Minor version problem");
                throw new FSMsgException("invalidNumber", null);
            }
            String instantString = request.getParameter("IssueInstant");
            if (instantString == null || instantString.length() == 0) {
                Object[] args = new String[]{"IssueInstant"};
                throw new FSMsgException("missingAttribute", args);
            }
            try {
                retLogoutNotification.issueInstant = DateUtils.stringToDate((String)instantString);
            }
            catch (ParseException e) {
                throw new FSMsgException("parseError", null);
            }
            String notAfter = request.getParameter("NotOnOrAfter");
            if (notAfter != null && notAfter.length() != 0) {
                try {
                    retLogoutNotification.notOnOrAfter = DateUtils.stringToDate((String)notAfter);
                }
                catch (ParseException pe) {
                    FSUtils.debug.message("FSLogoutNotification.parseURLEncodedRequest: parsing exception", (Throwable)pe);
                }
            }
            if ((providerId = request.getParameter("ProviderID")) == null) {
                throw new FSMsgException("missingElement", null);
            }
            retLogoutNotification.providerId = providerId;
            String sessionIndex = request.getParameter("SessionIndex");
            if (sessionIndex != null) {
                retLogoutNotification.sessionIndex = sessionIndex;
            }
            if ((relayState = request.getParameter("RelayState")) != null) {
                retLogoutNotification.relayState = relayState;
            }
            String nameFormat = request.getParameter("NameFormat");
            String nameQualifier = request.getParameter("NameQualifier");
            String name = request.getParameter("Name");
            if (name == null) {
                name = request.getParameter("NameIdentifier");
            }
            if (name == null) {
                throw new FSMsgException("missingElement", null);
            }
            retLogoutNotification.nameIdentifier = new NameIdentifier(name, nameQualifier, nameFormat);
            FSUtils.debug.message("Returning Logout Object");
            return retLogoutNotification;
        }
        catch (Exception e) {
            throw new FSMsgException("parseError", null);
        }
    }

    private void parseMajorVersion(String majorVer) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): invalid MajorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLogoutNotification(Element): MajorVersion of the LogoutRequest is too high.");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): MajorVersion of the LogoutRequest is too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): invalid MinorVersion", (Throwable)e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSLogoutNotification(Element): MinorVersion of the LogoutRequest is too high.");
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSLogoutNotification(Element): MinorVersion of the LogoutRequest is too low.");
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("libIDFF", "unsupportedOperation", null);
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSLogoutNotification.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print((Node)elem);
        return super.setSignature(elem);
    }
}

