/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDPEntry {
    public static final int LIB_TYPE_IDP = 0;
    public static final int LIB_TYPE_BROKER = 1;
    private String providerID = null;
    private String providerName = null;
    private String location = null;

    public IDPEntry() {
    }

    public IDPEntry(String providerID, String providerName, String location) {
        this.providerID = providerID;
        this.providerName = providerName;
        this.location = location;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("IDPEntry").append(uri).append(">\n");
        if (this.providerID != null) {
            xml.append("<").append(prefix).append("ProviderID").append(">").append(this.providerID).append("</").append(prefix).append("ProviderID").append(">\n");
        }
        if (this.providerName != null) {
            xml.append("<").append(prefix).append("ProviderName").append(">").append(this.providerName).append("</").append(prefix).append("ProviderName").append(">\n");
        }
        if (this.location != null) {
            xml.append("<").append(prefix).append("Loc").append(">").append(this.location).append("</").append(prefix).append("Loc").append(">\n");
        }
        xml.append("</").append(prefix).append("IDPEntry").append(">\n");
        return xml.toString();
    }

    public IDPEntry(Element root) throws FSMsgException {
        if (root == null) {
            SAMLUtils.debug.message("IDPEntry.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("IDPEntry")) {
            FSUtils.debug.message("IDPEntry.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("ProviderID")) {
                if (this.providerID != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("IDPEntry(Element): shouldcontain only one ProviderID");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerID = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (nodeName.equals("ProviderName")) {
                if (this.providerName != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("IDPEntry(Element): shouldcontain only one ProviderName");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerName = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (!nodeName.equals("Loc")) continue;
            if (this.location != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("IDPEntry(Element): shouldcontain only one Loc");
                }
                throw new FSMsgException("wrongInput", null);
            }
            this.location = XMLUtils.getElementValue((Element)((Element)child));
        }
    }
}

