/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSRealmIDPProxy;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRealmIDPProxyImpl
implements FSRealmIDPProxy {
    public String getPreferredIDP(FSAuthnRequest authnRequest, String realm, String hostEntityID, HttpServletRequest request, HttpServletResponse response) throws FSRedirectException {
        FSUtils.debug.message("FSIDPProxyImpl.getPreferredIDP:Init");
        try {
            Map attributes = IDFFMetaUtils.getAttributes(FSUtils.getIDFFMetaManager().getSPDescriptorConfig(realm, authnRequest.getProviderId()));
            String useIntroductionForProxying = IDFFMetaUtils.getFirstAttributeValue(attributes, "useIntroductionForIDPProxy");
            if (useIntroductionForProxying == null || !useIntroductionForProxying.equals("true")) {
                List proxyIDPs = (List)attributes.get("idpProxyList");
                if (proxyIDPs == null || proxyIDPs.isEmpty()) {
                    FSUtils.debug.error("FSIDPProxyImpl.getPrefferedIDP:Preferred IDPs are null.");
                    return null;
                }
                return (String)proxyIDPs.iterator().next();
            }
            StringBuffer redirectURL = new StringBuffer(100);
            String baseURL = FSServiceUtils.getBaseURL(request);
            redirectURL.append(baseURL).append("/idpfinder").append("?").append("RequestID=").append(authnRequest.getRequestID()).append("&").append("Realm=").append(realm).append("&").append("ProviderID=").append(hostEntityID);
            FSUtils.forwardRequest(request, response, redirectURL.toString());
            throw new FSRedirectException(FSUtils.bundle.getString("Redirection_Happened"));
        }
        catch (IDFFMetaException ex) {
            FSUtils.debug.error("FSIDPProxyImpl.getPreferredIDP: meta Exception in retrieving the preferred IDP", (Throwable)((Object)ex));
            return null;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSIDPProxyImpl.getPreferredIDP: Exception in retrieving the preferred IDP", (Throwable)e);
            return null;
        }
    }
}

