/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRedirectException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSAuthnDecisionHandler;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSProxyHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSIDPFinderService
extends HttpServlet {
    private static Map requestCotSetMap = Collections.synchronizedMap(new HashMap());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request == null || response == null) {
            FSUtils.debug.error("FSIDPFinderService.doGet:: Null Input");
            return;
        }
        FSUtils.debug.message("FSIDPFinderService.doGet::Init");
        String entityID = request.getParameter("ProviderID");
        String requestID = request.getParameter("RequestID");
        String realm = request.getParameter("Realm");
        if (entityID == null || requestID == null || realm == null) {
            FSUtils.debug.error("FSIDPFinderService.doGet:: Request is missingeither ProviderID or the RequestID");
            throw new ServletException("invalidRequest");
        }
        String idpID = null;
        try {
            idpID = this.getCommonDomainIDP(request, response, realm, entityID, requestID);
        }
        catch (FSRedirectException fe) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.doGet:Redirection has happened");
            }
            return;
        }
        String hostMetaAlias = null;
        IDPDescriptorConfigElement hostConfig = null;
        IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
        try {
            if (metaManager != null && (hostConfig = metaManager.getIDPDescriptorConfig(realm, entityID)) != null) {
                hostMetaAlias = hostConfig.getMetaAlias();
            }
        }
        catch (IDFFMetaException ie) {
            FSUtils.debug.error("FSIDPFinderService.doGet:: Failure in getting proxying hosted meta:", (Throwable)((Object)ie));
            return;
        }
        FSSessionManager sessionManager = FSSessionManager.getInstance(hostMetaAlias);
        FSAuthnRequest authnReq = sessionManager.getAuthnRequest(requestID);
        if (idpID == null || idpID.equals(entityID)) {
            String loginURL = this.getLoginURL(authnReq, realm, entityID, request);
            if (loginURL == null) {
                FSUtils.debug.error("FSIDPFinderService.doGet : login url is null");
                return;
            }
            response.setHeader("Location", loginURL);
            response.sendRedirect(loginURL);
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.doGet:IDP to be proxied:" + idpID);
            }
            try {
                FSProxyHandler handler = new FSProxyHandler(request, response);
                handler.setHostedEntityId(entityID);
                IDPDescriptorType hostDesc = null;
                SPDescriptorType origSPDesc = null;
                if (metaManager != null) {
                    hostDesc = metaManager.getIDPDescriptor(realm, entityID);
                    origSPDesc = metaManager.getSPDescriptor(realm, authnReq.getProviderId());
                }
                handler.setSPDescriptor(origSPDesc);
                handler.setHostedDescriptor(hostDesc);
                handler.setHostedDescriptorConfig(hostConfig);
                handler.setMetaAlias(hostMetaAlias);
                handler.setRealm(realm);
                handler.sendProxyAuthnRequest(authnReq, idpID);
            }
            catch (IDFFMetaException ie) {
                FSUtils.debug.error("FSIDPFinderService.doGet:: Failure in getting proxying hosted meta:", (Throwable)((Object)ie));
            }
            catch (FSException fe) {
                FSUtils.debug.error("FSIDPFinderService.doGet:: Failure in sending the proxy authentication request.", (Throwable)((Object)fe));
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getCommonDomainIDP(HttpServletRequest request, HttpServletResponse response, String realm, String entityID, String requestID) throws FSRedirectException, IOException {
        String idpID = FSUtils.findPreferredIDP(realm, request);
        if (idpID != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP:Preferred IDP found from the common domain." + idpID);
            }
            if (requestCotSetMap.containsKey(requestID)) {
                requestCotSetMap.remove(requestID);
            }
            return idpID;
        }
        HashSet tmpCotSet = (HashSet)requestCotSetMap.get(requestID);
        if (tmpCotSet == null) {
            try {
                IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                List cotList = null;
                if (metaManager != null) {
                    SPDescriptorConfigElement spConfig = metaManager.getSPDescriptorConfig(realm, entityID);
                    cotList = IDFFMetaUtils.getAttributeValueFromConfig(spConfig, "cotlist");
                }
                if (cotList != null) {
                    tmpCotSet = new HashSet();
                    tmpCotSet.addAll(cotList);
                }
            }
            catch (IDFFMetaException ie) {
                FSUtils.debug.error("FSIDPFinderService.getCommonDomainIDP:cannot get meta:", (Throwable)((Object)ie));
                return null;
            }
        }
        if (tmpCotSet == null || tmpCotSet.isEmpty()) {
            FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP::No more Cots.");
            if (requestCotSetMap.containsKey(requestID)) {
                requestCotSetMap.remove(requestID);
            }
            return null;
        }
        Iterator iter = tmpCotSet.iterator();
        while (iter.hasNext()) {
            String cotName = (String)iter.next();
            iter.remove();
            requestCotSetMap.put(requestID, tmpCotSet);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP: Trying Cot: " + cotName);
            }
            String readerServiceURL = null;
            try {
                CircleOfTrustManager cotManager = new CircleOfTrustManager();
                CircleOfTrustDescriptor cotDesc = cotManager.getCircleOfTrust(realm, cotName);
                if (cotDesc != null && cotDesc.getCircleOfTrustStatus().equalsIgnoreCase("active")) {
                    readerServiceURL = cotDesc.getIDFFReaderServiceURL();
                }
            }
            catch (COTException fe) {
                FSUtils.debug.error("FSIDPFinderService.getCommonDomainIDP:Unable to retrieve reader service url.", (Throwable)((Object)fe));
            }
            if (readerServiceURL == null) continue;
            String baseURL = FSServiceUtils.getBaseURL(request);
            StringBuffer returnURL = new StringBuffer(300);
            returnURL.append(baseURL).append("/idpfinder").append("?").append("RequestID").append("=").append(URLEncDec.encode((String)requestID)).append("&").append("Realm=").append(URLEncDec.encode((String)realm)).append("&").append("ProviderID=").append(URLEncDec.encode((String)entityID));
            StringBuffer redirectURL = new StringBuffer(300);
            redirectURL.append(readerServiceURL).append("?").append("RelayState").append("=").append(URLEncDec.encode((String)returnURL.toString()));
            String url = redirectURL.toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFinderService.getCommonDomainIDP:Redirection URL:" + url);
            }
            response.setHeader("Location", url);
            response.sendRedirect(url);
            throw new FSRedirectException(FSUtils.bundle.getString("Redirection_Happened"));
        }
        return null;
    }

    private String getLoginURL(FSAuthnRequest authnRequest, String realm, String hostProviderID, HttpServletRequest httpRequest) {
        if (authnRequest == null) {
            FSUtils.debug.error("FSIDPFinderServer.getLoginURL: null authnrequest");
            return null;
        }
        if (hostProviderID == null) {
            FSUtils.debug.error("FSIDPFinderServer.getLoginURL: null hostProviderID");
            return null;
        }
        IDPDescriptorType idpDescriptor = null;
        IDPDescriptorConfigElement idpConfig = null;
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            idpDescriptor = metaManager.getIDPDescriptor(realm, hostProviderID);
            idpConfig = metaManager.getIDPDescriptorConfig(realm, hostProviderID);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSIDPFinderServer.getLoginURL : exception while retrieving meta config", (Throwable)e);
            return null;
        }
        String authType = authnRequest.getAuthContextCompType();
        FSAuthnDecisionHandler authnDecisionHandler = new FSAuthnDecisionHandler(realm, hostProviderID, httpRequest);
        List defAuthnCtxList = IDFFMetaUtils.getAttributeValueFromConfig(idpConfig, "defaultAuthnContext");
        FSAuthContextResult authnResult = authnDecisionHandler.getURLForAuthnContext(defAuthnCtxList, authType);
        return this.formatLoginURL(authnResult.getLoginURL(), authnResult.getAuthContextRef(), realm, hostProviderID, idpDescriptor, idpConfig, authnRequest, httpRequest);
    }

    private String formatLoginURL(String loginURL, String authnContext, String realm, String hostProviderID, IDPDescriptorType idpDescriptor, BaseConfigType idpConfig, FSAuthnRequest authnRequest, HttpServletRequest httpRequest) {
        FSUtils.debug.message("FSIDPFinderService.formatLoginURL: Called");
        try {
            int len;
            if (loginURL == null) {
                FSUtils.debug.error("FSIDPFinderService.formatLoginURL: ");
                return null;
            }
            String metaAlias = idpConfig.getMetaAlias();
            String ssoUrl = idpDescriptor.getSingleSignOnServiceURL();
            StringBuffer returnUrl = new StringBuffer(ssoUrl);
            if (ssoUrl.indexOf(63) == -1) {
                returnUrl.append("?");
            } else {
                returnUrl.append("&");
            }
            returnUrl.append("Authn").append("=").append("true").append("&").append("AuthnContext").append("=").append(URLEncDec.encode((String)authnContext)).append("&").append("realm").append("=").append(URLEncDec.encode((String)realm)).append("&").append("_liberty_idp").append("=").append(URLEncDec.encode((String)hostProviderID)).append("&").append("metaAlias").append("=").append(URLEncDec.encode((String)metaAlias)).append("&").append("RequestID").append("=").append(URLEncDec.encode((String)authnRequest.getRequestID()));
            String postLoginUrl = FSServiceUtils.getBaseURL(httpRequest) + "/postLogin";
            StringBuffer gotoUrl = new StringBuffer(postLoginUrl);
            if (postLoginUrl.indexOf(63) == -1) {
                gotoUrl.append("?");
            } else {
                gotoUrl.append("&");
            }
            gotoUrl.append("RelayState").append("=").append(URLEncDec.encode((String)returnUrl.toString())).append("&").append("sso").append("=").append("true").append("&").append("metaAlias").append("=").append(metaAlias);
            StringBuffer redirectUrl = new StringBuffer(100);
            redirectUrl.append(loginURL);
            if (loginURL.indexOf(63) == -1) {
                redirectUrl.append("?");
            } else {
                redirectUrl.append("&");
            }
            redirectUrl.append("goto").append("=").append(URLEncDec.encode((String)gotoUrl.toString()));
            if (realm != null && realm.length() != 0) {
                redirectUrl.append("&").append("org").append("=").append(URLEncDec.encode((String)realm));
            }
            if (redirectUrl.charAt(len = redirectUrl.length() - 1) == '&') {
                redirectUrl = redirectUrl.deleteCharAt(len);
            }
            return redirectUrl.toString();
        }
        catch (Exception e) {
            FSUtils.debug.error("FSIDPFinderService.formatLoginURL: Exception: ", (Throwable)e);
            return null;
        }
    }
}

