/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;

public class FSSSOWMLPostProfileHandler
extends FSSSOAndFedHandler {
    protected FSSSOWMLPostProfileHandler() {
    }

    public FSSSOWMLPostProfileHandler(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest, SPDescriptorType spDescriptor, BaseConfigType spConfig, String spEntityId, String relayState) {
        super(request, response, authnRequest, spDescriptor, spConfig, spEntityId, relayState);
    }

    protected void sendAuthnResponse(FSAuthnResponse authnResponse) {
        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Called");
        try {
            authnResponse.setProviderId(this.hostedEntityId);
            Document doc = XMLUtils.toDOMDocument((String)authnResponse.toXMLString(true, true), (Debug)FSUtils.debug);
            if (FSServiceUtils.isSigningOn()) {
                List assList;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: start signing assertions");
                }
                if ((assList = authnResponse.getAssertion()) != null) {
                    Iterator iter = assList.iterator();
                    while (iter.hasNext()) {
                        String certAlias;
                        FSAssertion assertion = (FSAssertion)iter.next();
                        String id = assertion.getID();
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: id attr is" + id);
                        }
                        if ((certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias")) == null) {
                            FSUtils.debug.error("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                            return;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Site's certAlias is " + certAlias);
                        }
                        XMLSignatureManager manager = XMLSignatureManager.getInstance();
                        int minorVersion = assertion.getMinorVersion();
                        if (minorVersion == 0) {
                            manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "id", id, false);
                        } else if (minorVersion == 2 || minorVersion == 2) {
                            manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), "AssertionID", assertion.getAssertionID(), false);
                        } else {
                            FSUtils.debug.message("invalid minor version.");
                        }
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: SignatureManager finished signing ");
                    }
                }
            }
            String respStr = FSServiceUtils.printDocument(doc);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Signed AuthnResponse: " + respStr);
            }
            String b64Resp = Base64.encode((byte[])respStr.getBytes());
            this.response.setContentType("text/vnd.wap.wml");
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = this.response.getWriter();
            out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            out.println("<wml>");
            out.println("<card id=\"response\" title=\"IDP Response\">");
            out.println("<onevent type=\"onenterforward\">");
            out.println("<go method=\"post\" href=\"" + FSServiceUtils.getAssertionConsumerServiceURL(this.spDescriptor, this.authnRequest.getAssertionConsumerServiceID()) + "\">");
            out.println("<postfield name=\"LARES\" value=\"" + b64Resp + "\"/>");
            out.println("</go>");
            out.println("</onevent>");
            out.println("<onevent type=\"onenterbackward\">");
            out.println("<prev/>");
            out.println("</onevent>");
            out.println("</card>");
            out.println("</wml>");
            out.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOWMLPostProfileHandler:sendAuthnResponse: AuthnResponse sent successfully to: " + FSServiceUtils.getAssertionConsumerServiceURL(this.spDescriptor, this.authnRequest.getAssertionConsumerServiceID()));
            }
        }
        catch (Exception ex) {
            FSUtils.debug.message("FSSSOWMLPostProfileHandler:sendAuthnResponse: Failed to send AuthnResponse");
        }
    }

    protected boolean doSingleSignOn(Object ssoToken, String inResponseTo, NameIdentifier opaqueHandle, NameIdentifier idpOpaqueHandle) {
        FSAuthnResponse authnResponse = this.createAuthnResponse(ssoToken, inResponseTo, opaqueHandle, idpOpaqueHandle);
        this.sendAuthnResponse(authnResponse);
        return true;
    }
}

