/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSSingleLogoutServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("FSSingleLogoutServlet Initializing...");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatcher;
        FSUtils.debug.message("FSSingleLogoutServlet doGetPost...");
        String providerAlias = request.getParameter("metaAlias");
        if (providerAlias == null || providerAlias.length() < 1) {
            providerAlias = FSServiceUtils.getMetaAlias(request);
        }
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        request.setAttribute("logoutSource", (Object)"local");
        StringBuffer processLogout = new StringBuffer();
        processLogout.append("/ProcessLogout").append("/").append("metaAlias").append(providerAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("About to get RequestDispatcher for " + processLogout.toString());
        }
        if ((dispatcher = this.getServletConfig().getServletContext().getRequestDispatcher(processLogout.toString())) == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("RequestDispatcher is null.\nUnable to find " + processLogout);
            }
            FSUtils.debug.message("calling sendErrorPage ");
            FSLogoutUtil.sendErrorPage(request, response, providerAlias);
            return;
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

