/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationInitiationServlet
extends HttpServlet {
    private static IDFFMetaManager metaManager = null;
    private String termDoneURL = null;
    private String commonErrorPage = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("Entered FSTerminationInitiationServlet Init");
        metaManager = FSUtils.getIDFFMetaManager();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String providerAlias = request.getParameter("metaAlias");
        if (providerAlias == null || providerAlias.length() < 1) {
            FSUtils.debug.error("Unable to retrieve alias, Hosted Provider. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String hostedRole = null;
        String hostedEntityId = null;
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        try {
            hostedRole = metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedRole != null && hostedRole.equalsIgnoreCase("SP")) {
                hostedProviderDesc = metaManager.getSPDescriptor(realm, hostedEntityId);
                hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedRole != null && hostedRole.equalsIgnoreCase("IDP")) {
                hostedProviderDesc = metaManager.getIDPDescriptor(realm, hostedEntityId);
                hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request", (Throwable)((Object)eam));
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = request;
        this.setTerminationURL(hostedConfig, providerAlias);
        this.doTerminationInitiation(request, response, hostedProviderDesc, hostedConfig, realm, hostedEntityId, hostedRole, providerAlias);
    }

    protected void setTerminationURL(BaseConfigType hostedConfig, String metaAlias) {
        this.termDoneURL = FSServiceUtils.getTerminationDonePageURL(this.request, hostedConfig, metaAlias);
        this.commonErrorPage = FSServiceUtils.getErrorPageURL(this.request, hostedConfig, metaAlias);
    }

    private Object getValidToken(HttpServletRequest request) {
        FSUtils.debug.message("Entered FSTerminationInitiationServlet::getValidToken");
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object ssoToken = sessionProvider.getSession(request);
            if (ssoToken == null || !sessionProvider.isValid(ssoToken)) {
                FSUtils.debug.error("session token is not valid, redirecting for authentication");
                return null;
            }
            return ssoToken;
        }
        catch (SessionException e) {
            FSUtils.debug.error("SessionException caught: ", (Throwable)((Object)e));
            return null;
        }
    }

    private void doTerminationInitiation(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String realm, String hostedEntityId, String hostedRole, String providerAlias) {
        block14: {
            FSUtils.debug.message("Entered FSTerminationInitiationServlet::doTerminationInitiation");
            try {
                Object ssoToken = this.getValidToken(request);
                if (ssoToken != null) {
                    String remoteEntityId = request.getParameter("_liberty_id");
                    if (remoteEntityId == null || remoteEntityId.length() < 1) {
                        FSUtils.debug.error("Provider Id not found, display error page");
                        FSServiceUtils.showErrorPage(response, this.commonErrorPage, "termination-no-provider", "contact-admin");
                        return;
                    }
                    FSServiceManager instSManager = FSServiceManager.getInstance();
                    if (instSManager != null) {
                        FSFedTerminationHandler handlerObj;
                        FSUtils.debug.message("FSServiceManager Instance not null");
                        String remoteProviderRole = "SP";
                        FSAccountFedInfo fedinfo = null;
                        if (hostedRole.equalsIgnoreCase("SP")) {
                            remoteProviderRole = "IDP";
                            FSSessionManager sessManager = FSSessionManager.getInstance(providerAlias);
                            FSSession ssoSession = sessManager.getSession(ssoToken);
                            if (ssoSession != null && !ssoSession.getOneTime()) {
                                fedinfo = ssoSession.getAccountFedInfo();
                            }
                        }
                        if ((handlerObj = instSManager.getFedTerminationHandler(remoteEntityId, remoteProviderRole, SessionManager.getProvider().getPrincipalName(ssoToken), realm, hostedEntityId, providerAlias)) != null) {
                            handlerObj.setHostedDescriptor(hostedProviderDesc);
                            handlerObj.setHostedDescriptorConfig(hostedConfig);
                            handlerObj.setHostedProviderRole(hostedRole);
                            handlerObj.setMetaAlias(providerAlias);
                            handlerObj.setRealm(realm);
                            handlerObj.setHostedEntityId(hostedEntityId);
                            if (fedinfo != null) {
                                handlerObj.setAccountInfo(fedinfo);
                            }
                            boolean bStatus = handlerObj.handleFederationTermination(request, response, ssoToken);
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("handleFederationTermination status is : " + bStatus);
                            }
                            return;
                        }
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Unable to get termination handler. User account Not valid");
                        }
                    } else {
                        FSUtils.debug.message("FSServiceManager Instance null");
                    }
                    FSServiceUtils.returnLocallyAfterOperation(response, this.termDoneURL, false, "termSuccess", "termFailure");
                    return;
                }
                FSServiceUtils.redirectForAuthentication(request, response, providerAlias);
                return;
            }
            catch (IOException e) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("IOException in doTerminationInitiation", (Throwable)e);
                }
            }
            catch (SessionException ex) {
                if (!FSUtils.debug.messageEnabled()) break block14;
                FSUtils.debug.message("SessionException in doTerminationInitiation", (Throwable)((Object)ex));
            }
        }
        FSServiceUtils.returnLocallyAfterOperation(response, this.termDoneURL, false, "termSuccess", "termFailure");
    }
}

