/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationRequestServlet
extends HttpServlet {
    private static IDFFMetaManager metaManager = null;
    private String commonErrorPage = null;
    private HttpServletRequest request = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        FSUtils.debug.message("Entered FSTerminationRequestServlet Init");
        metaManager = FSUtils.getIDFFMetaManager();
    }

    protected void setTerminationURL(BaseConfigType hostedConfig, String metaAlias) {
        this.commonErrorPage = FSServiceUtils.getErrorPageURL(this.request, hostedConfig, metaAlias);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String providerAlias = FSServiceUtils.getMetaAlias(request);
        if (providerAlias == null || providerAlias.length() < 1) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            }
            response.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (metaManager == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        ProviderDescriptorType hostedProviderDesc = null;
        BaseConfigType hostedConfig = null;
        String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
        String hostedEntityId = null;
        String hostedProviderRole = null;
        try {
            hostedProviderRole = metaManager.getProviderRoleByMetaAlias(providerAlias);
            hostedEntityId = metaManager.getEntityIDByMetaAlias(providerAlias);
            if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("IDP")) {
                hostedProviderDesc = metaManager.getIDPDescriptor(realm, hostedEntityId);
                hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
            } else if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("SP")) {
                hostedProviderDesc = metaManager.getSPDescriptor(realm, hostedEntityId);
                hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityId);
            }
            if (hostedProviderDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            response.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = request;
        this.setTerminationURL(hostedConfig, providerAlias);
        FSFederationTerminationNotification fedTermObj = new FSFederationTerminationNotification();
        try {
            fedTermObj = FSFederationTerminationNotification.parseURLEncodedRequest(request);
        }
        catch (FSMsgException e) {
            FSServiceUtils.showErrorPage(response, this.commonErrorPage, "termination-request-improper", "termination-failed-locally");
            return;
        }
        catch (SAMLException e) {
            FSServiceUtils.showErrorPage(response, this.commonErrorPage, "termination-request-improper", "termination-failed-locally");
            return;
        }
        if (fedTermObj == null) {
            FSServiceUtils.showErrorPage(response, this.commonErrorPage, "termination-request-improper", "termination-failed-locally");
        } else {
            this.doRequestProcessing(request, response, hostedProviderDesc, hostedConfig, hostedProviderRole, realm, hostedEntityId, providerAlias, fedTermObj);
        }
    }

    private void doRequestProcessing(HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String hostedProviderRole, String realm, String hostedEntityId, String providerAlias, FSFederationTerminationNotification reqTermination) {
        FSUtils.debug.message("Entered FSTerminationRequestServlet::doRequestProcessing");
        String remoteEntityId = reqTermination.getProviderId();
        String retURL = null;
        ProviderDescriptorType remoteDesc = null;
        boolean isIDP = false;
        try {
            if (hostedProviderRole.equalsIgnoreCase("SP")) {
                remoteDesc = metaManager.getIDPDescriptor(realm, remoteEntityId);
                isIDP = true;
            } else {
                remoteDesc = metaManager.getSPDescriptor(realm, remoteEntityId);
            }
            if (remoteDesc == null) {
                throw new IDFFMetaException((String)null);
            }
            retURL = remoteDesc.getFederationTerminationServiceReturnURL();
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("FSTerminationRequestServlet.doRequest Processing: Can not retrieve remote provider data." + remoteEntityId);
            String[] data = new String[]{remoteEntityId, realm};
            LogUtil.error(Level.INFO, "INVALID_PROVIDER", data);
            FSServiceUtils.returnToSource(response, retURL, this.commonErrorPage, "termination-invalid-federation", "metadata-error-check");
            return;
        }
        boolean bVerify = true;
        if (FSServiceUtils.isSigningOn()) {
            try {
                if (remoteDesc == null) {
                    FSUtils.debug.error("Remote provider metadata not found.");
                    String[] data = new String[]{remoteEntityId, realm};
                    LogUtil.error(Level.INFO, "INVALID_PROVIDER", data);
                    FSServiceUtils.returnToSource(response, retURL, this.commonErrorPage, "termination-invalid-federation", "metadata-error-check");
                    return;
                }
                FSUtils.debug.message("Calling verifyTerminationSignature");
                bVerify = this.verifyTerminationSignature(request, remoteDesc, remoteEntityId, isIDP);
            }
            catch (FSException e) {
                FSUtils.debug.error("FSTerminationRequestServlet::doRequestProcessing Signature on termination request is invalidCannot proceed federation termination");
                String[] data = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                FSServiceUtils.returnToSource(response, retURL, this.commonErrorPage, "termination-invalid-federation", "metadata-error-check");
                return;
            }
            catch (SAMLException e) {
                FSUtils.debug.error("FSFedTerminationHandler::doRequestProcessing Signature on termination request is invalidCannot proceed federation termination");
                String[] data = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
                LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
                FSServiceUtils.returnToSource(response, retURL, this.commonErrorPage, "termination-invalid-federation", "metadata-error-check");
                return;
            }
        }
        if (bVerify) {
            if (metaManager.isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                FSServiceManager instService = FSServiceManager.getInstance();
                if (instService != null) {
                    FSFedTerminationHandler termHandler = instService.getFedTerminationHandler(reqTermination, hostedConfig, realm, hostedEntityId, hostedProviderRole, providerAlias, remoteEntityId);
                    if (termHandler != null) {
                        termHandler.setHostedDescriptor(hostedProviderDesc);
                        termHandler.setHostedDescriptorConfig(hostedConfig);
                        termHandler.setRealm(realm);
                        termHandler.setHostedEntityId(hostedEntityId);
                        termHandler.setHostedProviderRole(hostedProviderRole);
                        termHandler.setMetaAlias(providerAlias);
                        termHandler.setRemoteEntityId(remoteEntityId);
                        termHandler.setRemoteDescriptor(remoteDesc);
                        termHandler.processTerminationRequest(request, response, reqTermination);
                        return;
                    }
                    FSUtils.debug.error("Unable to get termination handler. User account Not valid");
                } else {
                    FSUtils.debug.error("FSServiceManager instance is null Cannot process termination request");
                }
            } else {
                FSUtils.debug.error("Remote provider not in trusted list");
            }
        } else {
            FSUtils.debug.error("FSTerminationRequestServlet::doRequestProcesing Signature on termination request is invalidCannot proceed federation termination");
            String[] data = new String[]{FSUtils.bundle.getString("termination-invalid-signature")};
            LogUtil.error(Level.INFO, "INVALID_SIGNATURE", data);
        }
        FSServiceUtils.returnToSource(response, retURL, this.commonErrorPage, "termination-invalid-federation", "metadata-error-check");
    }

    private boolean verifyTerminationSignature(HttpServletRequest request, ProviderDescriptorType remoteDescriptor, String remoteEntityId, boolean isIDP) throws SAMLException, FSException {
        FSUtils.debug.message("Entered FSTerminationRequestServlet::verifyTerminationSignature");
        X509Certificate cert = KeyUtil.getVerificationCert(remoteDescriptor, remoteEntityId, isIDP);
        if (cert == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationRequestServlet.verifyTerminationSignature:couldn't obtain this site's cert .");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
        }
        boolean isValidSign = FSSignatureUtil.verifyRequestSignature(request, cert);
        if (!isValidSign) {
            FSUtils.debug.error("Termination request is not properly signed");
            return false;
        }
        FSUtils.debug.message("Termination request is properly signed");
        return true;
    }
}

