/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceInstance {
    private String serviceType = null;
    private String providerID = null;
    private List descriptions = null;

    public ServiceInstance() {
    }

    public ServiceInstance(String serviceType, String providerID, List descriptions) {
        this.serviceType = serviceType;
        this.providerID = providerID;
        this.descriptions = descriptions;
    }

    public ServiceInstance(Element elem) throws DiscoveryException {
        String nameSpaceURI;
        if (elem == null) {
            DiscoUtils.debug.message("ServiceInstance(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = elem.getLocalName();
        if (nodeName == null || !nodeName.equals("ServiceInstance") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("ServiceInstance(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("ServiceInstance(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("ServiceType")) {
                if (this.serviceType != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ServiceInstance(Element): Included more than one ServiceType element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.serviceType = XMLUtils.getElementValue((Element)((Element)child));
                if (this.serviceType != null && this.serviceType.length() != 0) continue;
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("ServiceInstance(Element): missing ServiceType element value.");
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
            }
            if (nodeName.equals("ProviderID")) {
                if (this.providerID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ServiceInstance(Element): Included more than one ProviderID.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.providerID = XMLUtils.getElementValue((Element)((Element)child));
                if (this.providerID != null && this.providerID.length() != 0) continue;
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("ServiceInstance(Element): missing ProviderID element value.");
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
            }
            if (nodeName.equals("Description")) {
                if (this.descriptions == null) {
                    this.descriptions = new ArrayList();
                }
                this.descriptions.add(new Description((Element)child));
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.serviceType == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing ServiceInstance element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingServiceInstance"));
        }
        if (this.providerID == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing ProviderID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingProviderID"));
        }
        if (this.descriptions == null || this.descriptions.size() < 1) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing Description element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingDescription"));
        }
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String value) {
        this.providerID = value;
    }

    public List getDescription() {
        return this.descriptions;
    }

    public void setDescription(List desc) {
        this.descriptions = desc;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String value) {
        this.serviceType = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<ServiceInstance xmlns=\"").append("urn:liberty:disco:2003-08").append("\"><ServiceType>").append(this.serviceType).append("</ServiceType><ProviderID>").append(this.providerID).append("</ProviderID>");
        if (this.descriptions != null) {
            Iterator iter = this.descriptions.iterator();
            while (iter.hasNext()) {
                sb.append(((Description)iter.next()).toString());
            }
        }
        sb.append("</ServiceInstance>");
        return sb.toString();
    }
}

