/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoSDKUtils;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb11.GenerateBearerTokenElement;
import com.sun.identity.liberty.ws.disco.plugins.NameIdentifierMapper;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.liberty.ws.util.ProviderUtil;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DiscoUtils
extends DiscoSDKUtils {
    private static String ALL = "all";
    private static int AUTHN = 0;
    private static int AUTHO = 1;
    private static int SESSION = 2;
    private static int BEARER = 3;
    private static int LOGOUT = 4;
    private static int SIZE = 5;
    private static BitSet EMPTY_BITSET = new BitSet(SIZE);

    private DiscoUtils() {
    }

    public static Map checkPolicyAndHandleDirectives(String userDN, Message message, Collection results, Authorizer authorizer, SessionContext invoSession, String wscID, Object token) {
        debug.message("DiscoService.checkPolicyAndHandleDirectives");
        LinkedList<ResourceOffering> offerings = new LinkedList<ResourceOffering>();
        LinkedList credentials = new LinkedList();
        HashMap<String, Object> env = null;
        Iterator k = results.iterator();
        while (k.hasNext()) {
            InsertEntryType entry = (InsertEntryType)k.next();
            if (authorizer != null) {
                if (env == null) {
                    env = new HashMap<String, Object>();
                    env.put("userID", userDN);
                    env.put("authType", message.getAuthenticationMechanism());
                    env.put("message", message);
                }
                if (!authorizer.isAuthorized(message.getToken(), "LOOKUP", entry.getResourceOffering(), env)) {
                    debug.error("DiscoveryService.checkPolicyAndHandleDirectives: WSC is not authorized to do lookup");
                    continue;
                }
            }
            ResourceOffering current = null;
            try {
                current = new ResourceOffering(Utils.convertJAXBToElement(entry.getResourceOffering(), false));
            }
            catch (Exception ex) {
                debug.error("DiscoveryService.checkPolicyAndHandleDirectives:exception when constructing ResourceOffering:", (Throwable)ex);
                continue;
            }
            List directives = entry.getAny();
            if (directives == null || directives.isEmpty()) {
                debug.message("DiscoService: no directives.");
                offerings.add(current);
                continue;
            }
            debug.message("DiscoService: has directives.");
            DiscoUtils.handleDirectives(current, directives, userDN, message, invoSession, wscID, token, offerings, credentials);
        }
        HashMap returnMap = new HashMap();
        returnMap.put("offerings", offerings);
        returnMap.put("credentials", credentials);
        return returnMap;
    }

    private static void handleDirectives(ResourceOffering current, List directives, String userDN, Message message, SessionContext invoSession, String wscID, Object token, List offerings, List credentials) {
        HashMap descIDDirectiveMap = new HashMap();
        BitSet all = new BitSet(SIZE);
        if (invoSession != null && DiscoServiceManager.needSessionContextStatement()) {
            all.set(SESSION);
        }
        Iterator iter0 = directives.iterator();
        while (iter0.hasNext()) {
            Object directive = iter0.next();
            List descIDRefs = ((DirectiveType)directive).getDescriptionIDRefs();
            if (directive instanceof EncryptResourceIDElement) {
                debug.message("DiscoService: has encrypt D");
                current = DiscoUtils.doEncryption(current);
                continue;
            }
            if (directive instanceof AuthenticateRequesterElement) {
                DiscoUtils.setMap(descIDRefs, AUTHN, descIDDirectiveMap, all);
                continue;
            }
            if (directive instanceof AuthorizeRequesterElement) {
                DiscoUtils.setMap(descIDRefs, AUTHO, descIDDirectiveMap, all);
                continue;
            }
            if (directive instanceof AuthenticateSessionContextElement) {
                DiscoUtils.setMap(descIDRefs, SESSION, descIDDirectiveMap, all);
                continue;
            }
            if (directive instanceof GenerateBearerTokenElement) {
                DiscoUtils.setMap(descIDRefs, BEARER, descIDDirectiveMap, all);
                continue;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("DiscoUtils.handleDirective: directive not supported.");
        }
        HashMap<BitSet, String> directiveCredIDMap = new HashMap<BitSet, String>();
        HashMap<String, String> descIDCredIDMap = new HashMap<String, String>();
        Iterator iter2 = descIDDirectiveMap.keySet().iterator();
        while (iter2.hasNext()) {
            String descID = (String)iter2.next();
            BitSet dirs = (BitSet)descIDDirectiveMap.get(descID);
            dirs.or(all);
            if (directiveCredIDMap.containsKey(dirs)) {
                descIDCredIDMap.put(descID, (String)directiveCredIDMap.get(dirs));
                continue;
            }
            String ref = DiscoUtils.generateCredential(dirs, current, message, userDN, credentials, invoSession, wscID, token);
            if (ref == null) continue;
            directiveCredIDMap.put(dirs, ref);
            descIDCredIDMap.put(descID, ref);
        }
        Iterator descIter = current.getServiceInstance().getDescription().iterator();
        ArrayList<String> credIDs = null;
        while (descIter.hasNext()) {
            credIDs = new ArrayList<String>();
            Description desc = (Description)descIter.next();
            String id = desc.getId();
            if (id != null && id.length() != 0 && descIDCredIDMap.containsKey(id)) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.handleDirective: containsKey:" + id);
                }
                credIDs.add((String)descIDCredIDMap.get(id));
            } else {
                debug.message("DiscoUtils.handleDirective:  not containsKey");
                String allCred = (String)descIDCredIDMap.get("all");
                if (allCred == null) {
                    if (directiveCredIDMap.containsKey(all)) {
                        allCred = (String)directiveCredIDMap.get(all);
                        descIDCredIDMap.put("all", allCred);
                        credIDs.add(allCred);
                    } else if (!all.equals(EMPTY_BITSET) && (allCred = DiscoUtils.generateCredential(all, current, message, userDN, credentials, invoSession, wscID, token)) != null) {
                        descIDCredIDMap.put("all", allCred);
                        credIDs.add(allCred);
                    }
                } else {
                    credIDs.add(allCred);
                }
            }
            if (credIDs.isEmpty()) continue;
            desc.setCredentialRef(credIDs);
        }
        offerings.add(current);
    }

    private static ResourceOffering doEncryption(ResourceOffering current) {
        ResourceID ri = current.getResourceID();
        if (ri == null) {
            return current;
        }
        try {
            EncryptedResourceID eri = EncryptedResourceID.getEncryptedResourceID(ri, current.getServiceInstance().getProviderID());
            current.setResourceID(null);
            current.setEncryptedResourceID(eri);
        }
        catch (Exception e) {
            debug.error("DiscoUtils.doEncryption: exception:", (Throwable)e);
        }
        return current;
    }

    private static void setMap(List descIDRefs, int type, Map descIDDirectiveMap, BitSet all) {
        if (descIDRefs == null || descIDRefs.size() == 0) {
            all.set(type);
        } else {
            Iterator iter1 = descIDRefs.iterator();
            while (iter1.hasNext()) {
                String descID = ((DescriptionType)iter1.next()).getId();
                BitSet cur = (BitSet)descIDDirectiveMap.get(descID);
                if (cur == null) {
                    cur = new BitSet(SIZE);
                }
                cur.set(type);
                descIDDirectiveMap.put(descID, cur);
            }
        }
    }

    private static SessionContext getSessionContext(SecurityAssertion assertion) {
        if (assertion == null) {
            return null;
        }
        Iterator iter = assertion.getStatement().iterator();
        SessionContext context = null;
        while (iter.hasNext()) {
            Statement st = (Statement)iter.next();
            int type = st.getStatementType();
            if (!(type == 4 ? (context = ((ResourceAccessStatement)st).getSessionContext()) != null : type == 5 && (context = ((SessionContextStatement)st).getSessionContext()) != null)) continue;
            return context;
        }
        return null;
    }

    private static String generateCredential(BitSet dirs, ResourceOffering current, Message message, String userDN, List credentials, SessionContext invoSession, String wscID, Object token) {
        AssertionBase assertion = null;
        try {
            Object resourceID;
            SessionContext invocatorSession;
            ProviderHeader ph;
            SecurityTokenManager secuMgr = new SecurityTokenManager(token);
            NameIdentifier senderIdentity = null;
            String providerID = wscID;
            if ((providerID == null || providerID.length() == 0) && (ph = message.getProviderHeader()) != null) {
                providerID = ph.getProviderID();
            }
            if ((invocatorSession = invoSession) == null) {
                invocatorSession = DiscoUtils.getSessionContext(message.getAssertion());
            }
            String tproviderID = current.getServiceInstance().getProviderID();
            if (invocatorSession != null) {
                try {
                    ProviderManager pm = ProviderUtil.getProviderManager();
                    SessionSubject sub = invocatorSession.getSessionSubject();
                    NameIdentifier ni = sub.getNameIdentifier();
                    if (ni.getFormat() != null && ni.getFormat().equals("urn:liberty:iff:nameid:encrypted")) {
                        ni = EncryptedNameIdentifier.getDecryptedNameIdentifier(ni, pm.getDecryptionKey(DiscoServiceManager.getDiscoProviderID()));
                    }
                    NameIdentifier newNi = null;
                    NameIdentifierMapper niMapper = DiscoServiceManager.getNameIdentifierMapper();
                    if (niMapper != null) {
                        String discoEntityID = DiscoServiceManager.getDiscoProviderID();
                        newNi = niMapper.getNameIdentifier(tproviderID, discoEntityID, ni, userDN);
                    }
                    if (newNi != null && !newNi.equals(ni)) {
                        sub.setNameIdentifier(newNi);
                        IDPProvidedNameIdentifier idpNi = sub.getIDPProvidedNameIdentifier();
                        if (idpNi != null) {
                            IDPProvidedNameIdentifier newIdpNi = new IDPProvidedNameIdentifier(newNi.getName(), newNi.getNameQualifier(), newNi.getFormat());
                            sub.setIDPProvidedNameIdentifier(newIdpNi);
                        }
                    } else if (pm.isNameIDEncryptionEnabled(tproviderID)) {
                        sub.setNameIdentifier(EncryptedNameIdentifier.getEncryptedNameIdentifier(ni, tproviderID, pm.getEncryptionKey(tproviderID), pm.getEncryptionKeyAlgorithm(tproviderID), pm.getEncryptionKeyStrength(tproviderID)));
                    } else {
                        sub.setNameIdentifier(ni);
                    }
                    invocatorSession.setSessionSubject(sub);
                }
                catch (Exception ex) {
                    debug.error("DiscoUtils.handleDirective: En/Decryption Exception:", (Throwable)ex);
                    return null;
                }
            }
            if ((resourceID = current.getEncryptedResourceID()) == null) {
                resourceID = current.getResourceID();
                resourceID = resourceID == null ? "urn:liberty:isf:implied-resource" : ((ResourceID)resourceID).getResourceID();
            }
            if (dirs.get(BEARER)) {
                if (dirs.get(AUTHN) || dirs.get(AUTHO) || dirs.get(SESSION)) {
                    senderIdentity = providerID != null && providerID.length() != 0 ? new NameIdentifier(providerID, null, "urn:liberty:iff:nameid:entityID") : new NameIdentifier(userDN);
                    assertion = resourceID instanceof String ? secuMgr.getSAMLBearerToken(senderIdentity, invocatorSession, (String)resourceID, dirs.get(AUTHN), dirs.get(AUTHO), tproviderID) : secuMgr.getSAMLBearerToken(senderIdentity, invocatorSession, (EncryptedResourceID)resourceID, dirs.get(AUTHN), dirs.get(AUTHO), tproviderID);
                }
            } else {
                senderIdentity = providerID != null && providerID.length() != 0 ? new NameIdentifier(providerID, null, "urn:liberty:iff:nameid:entityID") : new NameIdentifier(userDN);
                if (providerID != null) {
                    secuMgr.setCertAlias(ProviderUtil.getProviderManager().getSigningKeyAlias(providerID));
                } else {
                    X509Certificate wscCert = message.getPeerCertificate();
                    if (wscCert == null && (wscCert = message.getMessageCertificate()) == null) {
                        if (debug.messageEnabled()) {
                            debug.message("DiscoUtils.generateCredential:client cert is null. Cannot generate credential.");
                        }
                        return null;
                    }
                    secuMgr.setCertificate(wscCert);
                }
                assertion = resourceID instanceof String ? secuMgr.getSAMLAuthorizationToken(senderIdentity, invocatorSession, (String)resourceID, dirs.get(AUTHN), dirs.get(AUTHO), tproviderID) : secuMgr.getSAMLAuthorizationToken(senderIdentity, invocatorSession, (EncryptedResourceID)resourceID, dirs.get(AUTHN), dirs.get(AUTHO), tproviderID);
            }
        }
        catch (Exception ex) {
            debug.error("DiscoUtils.generateCredential:cannot generate credential: ", (Throwable)ex);
        }
        if (assertion == null) {
            debug.error("DiscoUtils.generateCredential: cannot generate credential.");
            return null;
        }
        credentials.add(assertion);
        return assertion.getAssertionID();
    }
}

