/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenProvider;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;

public final class SecurityTokenManager {
    private static String TOKEN_PROVIDER = "com.sun.identity.liberty.ws.security.TokenProviderImpl";
    private static String providerClass = SystemPropertiesManager.get((String)TOKEN_PROVIDER);
    static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libLibertySecurity");
    static Debug debug = Debug.getInstance((String)"libLibertySecurity");
    private SecurityTokenProvider provider = null;

    private SecurityTokenManager() {
    }

    public SecurityTokenManager(Object credential) throws SecurityTokenException {
        if (providerClass == null || providerClass.trim().length() == 0) {
            debug.error("Con: Security Token Provider class is not defined");
            throw new SecurityTokenException(bundle.getString("noProvider"));
        }
        try {
            this.provider = (SecurityTokenProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception e) {
            debug.message("Con: Unable to get instance of Token Provider", (Throwable)e);
            throw new SecurityTokenException(bundle.getString("noProviderInstance"));
        }
        XMLSignatureManager manager = null;
        try {
            manager = XMLSignatureManager.getInstance();
        }
        catch (Exception e) {
            debug.message("Con: Unable to get instance of XMLSigManager", (Throwable)e);
        }
        this.provider.initialize(credential, manager);
    }

    public SecurityTokenManager(Object credential, XMLSignatureManager signatureManager) throws SecurityTokenException {
        if (providerClass == null || providerClass.trim().length() == 0) {
            debug.error("Con2: Security Token Provider class is not defined");
            throw new SecurityTokenException(bundle.getString("noProvider"));
        }
        try {
            this.provider = (SecurityTokenProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception e) {
            debug.message("Con2: Unable to get instance of Token Provider", (Throwable)e);
            throw new SecurityTokenException(bundle.getString("noProviderInstance"));
        }
        this.provider.initialize(credential, signatureManager);
    }

    public void setCertAlias(String certAlias) throws SecurityTokenException {
        this.provider.setCertAlias(certAlias);
    }

    public void setCertificate(X509Certificate cert) throws SecurityTokenException {
        this.provider.setCertificate(cert);
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        return this.provider.getX509CertificateToken();
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier senderIdentity) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLAuthenticationToken(senderIdentity);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, String resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLAuthorizationToken(senderIdentity, invocatorSession, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, EncryptedResourceID encResourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.provider.getSAMLAuthorizationToken(senderIdentity, invocatorSession, encResourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier senderIdentity, SessionContext invocatorSession, String resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException, SAMLException {
        return this.provider.getSAMLBearerToken(senderIdentity, invocatorSession, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
    }

    public SecurityAssertion getSAMLBearerToken(NameIdentifier senderIdentity, SessionContext invocatorSession, EncryptedResourceID encResourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException {
        return this.provider.getSAMLBearerToken(senderIdentity, invocatorSession, encResourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
    }
}

