/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.liberty.ws.soapbinding.ConsentHeader;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.soapbinding.ProcessingContextHeader;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingService;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.UsageDirectiveHeader;
import com.sun.identity.liberty.ws.soapbinding.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.liberty.ws.util.ProviderUtil;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.NotIdentifiableEvent;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    static final String NAMESPACE_PREFIX_MAPPING_LIST_PROP = "com.sun.identity.liberty.ws.jaxb.namespacePrefixMappingList";
    static final String JAXB_PACKAGE_LIST_PROP = "com.sun.identity.liberty.ws.jaxb.packageList";
    static final String DEFAULT_JAXB_PACKAGES = "com.sun.identity.liberty.ws.common.jaxb.soap:com.sun.identity.liberty.ws.common.jaxb.assertion:com.sun.identity.liberty.ws.common.jaxb.protocol:com.sun.identity.liberty.ws.common.jaxb.ac:com.sun.identity.liberty.ws.disco.jaxb:com.sun.identity.liberty.ws.disco.jaxb11:com.sun.identity.liberty.ws.disco.plugins.jaxb:com.sun.identity.liberty.ws.interaction.jaxb:com.sun.identity.liberty.ws.meta.jaxb:com.sun.identity.liberty.ws.paos.jaxb:com.sun.identity.liberty.ws.common.jaxb.ps:com.sun.identity.liberty.ws.common.jaxb.security:com.sun.identity.liberty.ws.soapbinding.jaxb:com.sun.identity.liberty.ws.soapbinding.jaxb11:com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.secext:com.sun.identity.liberty.ws.common.jaxb.utility:com.sun.identity.liberty.ws.common.jaxb.xmlenc:com.sun.identity.liberty.ws.common.jaxb.xmlsig";
    static com.sun.identity.liberty.ws.common.jaxb.soap.ObjectFactory soapOF;
    static ObjectFactory soapBOF;
    static com.sun.identity.liberty.ws.common.jaxb.secext.ObjectFactory secOF;
    static final QName FAULT_CODE_SERVER;
    static String faultStringServerError;
    static Debug debug;
    public static ResourceBundle bundle;
    static MessageFactory messageFactory;
    static HashMap nsPrefix;
    static String jaxbPackages;
    static JAXBContext jc;
    static final String STALE_TIME_LIMIT_PROP = "com.sun.identity.liberty.ws.soap.staleTimeLimit";
    static int stale_time_limit;
    static final String SUPPORTED_ACTORS_PROP = "com.sun.identity.liberty.ws.soap.supportedActors";
    static final String LIBERTY_WSF_VERSION = "com.sun.identity.liberty.wsf.version";
    static Set supportedActors;
    static final String MESSAGE_ID_CACHE_CLEANUP_INTERVAL_PROP = "com.sun.identity.liberty.ws.soap.messageIDCacheCleanupInterval";
    static int message_ID_cleanup_interval;
    private static Map messageIDMap;

    public static Map getNamespacePrefixMapping() {
        return nsPrefix;
    }

    public static String getJAXBPackages() {
        return jaxbPackages;
    }

    public static SOAPMessage DocumentToSOAPMessage(Document doc) throws SOAPBindingException {
        SOAPMessage msg = null;
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            String xmlstr = XMLUtils.print((Node)doc);
            if (debug.messageEnabled()) {
                debug.message("Utils.DocumentToSOAPMessage: xmlstr = " + xmlstr);
            }
            msg = messageFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(xmlstr.getBytes("UTF-8")));
        }
        catch (Exception e) {
            debug.error("Utils.DocumentToSOAPMessage", (Throwable)e);
            throw new SOAPBindingException(e.getMessage());
        }
        return msg;
    }

    public static List convertJAXBToElement(List jaxbObjs) throws JAXBException {
        ArrayList<Element> result = new ArrayList<Element>();
        if (jaxbObjs != null && !jaxbObjs.isEmpty()) {
            Iterator iter = jaxbObjs.iterator();
            while (iter.hasNext()) {
                result.add(Utils.convertJAXBToElement(iter.next()));
            }
        }
        return result;
    }

    public static Element convertJAXBToElement(Object jaxbObj) throws JAXBException {
        Marshaller m = jc.createMarshaller();
        try {
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        }
        catch (PropertyException ex) {
            debug.error("Utils.convertJAXBToElement", (Throwable)ex);
        }
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception ex) {
            debug.error("Utils.convertJAXBToElement:", (Throwable)ex);
        }
        m.marshal(jaxbObj, (Node)doc);
        return doc.getDocumentElement();
    }

    public static Element convertJAXBToElement(Object jaxbObj, boolean checkIdref) throws JAXBException {
        Marshaller m = jc.createMarshaller();
        try {
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        }
        catch (PropertyException ex) {
            debug.error("Utils.convertJAXBToElement", (Throwable)ex);
        }
        if (!checkIdref) {
            m.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    if (event instanceof NotIdentifiableEvent) {
                        return true;
                    }
                    return super.handleEvent(event);
                }
            });
        }
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception ex) {
            debug.error("Utils.convertJAXBToElement:", (Throwable)ex);
        }
        m.marshal(jaxbObj, (Node)doc);
        return doc.getDocumentElement();
    }

    public static List convertElementToJAXB(List elements) throws JAXBException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (elements != null && !elements.isEmpty()) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                result.add(Utils.convertElementToJAXB((Element)iter.next()));
            }
        }
        return result;
    }

    public static Object convertElementToJAXB(Element element) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        return u.unmarshal((Node)element);
    }

    public static Boolean StringToBoolean(String str) throws Exception {
        if (str == null) {
            return null;
        }
        if (str.equals("true") || str.equals("1")) {
            return Boolean.TRUE;
        }
        if (str.equals("false") || str.equals("0")) {
            return Boolean.FALSE;
        }
        throw new Exception();
    }

    public static String BooleanToString(Boolean bool) {
        if (bool == null) {
            return "";
        }
        return bool != false ? "1" : "0";
    }

    public static QName convertStringToQName(String str, Element element) {
        String localPart;
        if (str == null) {
            return null;
        }
        String prefix = "";
        int index = str.indexOf(":");
        if (index == -1) {
            localPart = str;
        } else {
            prefix = str.substring(0, index);
            localPart = str.substring(index + 1);
        }
        PrefixResolverDefault prd = new PrefixResolverDefault(element.getOwnerDocument());
        String ns = prd.getNamespaceForPrefix(prefix, element);
        return new QName(ns, localPart);
    }

    public static void enforceProcessingRules(Message message, String requestMessageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        CorrelationHeader corrH = message.getCorrelationHeader();
        String messageID = corrH.getMessageID();
        Utils.checkCorrelationHeader(corrH, requestMessageID, isServer);
        Utils.checkProviderHeader(message.getProviderHeader(), messageID, isServer);
        Utils.checkProcessingContextHeader(message.getProcessingContextHeader(), messageID, isServer);
        Utils.checkConsentHeader(message.getConsentHeader(), messageID, isServer);
        List usagHs = message.getUsageDirectiveHeaders();
        if (usagHs != null && !usagHs.isEmpty()) {
            Iterator iter = usagHs.iterator();
            while (iter.hasNext()) {
                UsageDirectiveHeader usagH = (UsageDirectiveHeader)iter.next();
                Utils.checkUsageDirectiveHeader(usagH, messageID, isServer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCorrelationHeader(CorrelationHeader corrH, String requestMessageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (corrH == null) {
            if (isServer) {
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, new SOAPFaultDetail(SOAPFaultDetail.ID_STAR_MSG_NOT_UNSTD, null, null));
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("CorrelationHeaderNull"));
        }
        String messageID = corrH.getMessageID();
        try {
            Utils.checkActorAndMustUnderstand(corrH.getActor(), corrH.getMustUnderstand(), messageID, isServer);
        }
        catch (SOAPFaultException sfe) {
            sfe.getSOAPFaultMessage().getSOAPFault().getDetail().setCorrelationHeader(corrH);
            throw sfe;
        }
        Date timestamp = corrH.getTimestamp();
        Date now = new Date();
        if (now.getTime() - timestamp.getTime() > (long)stale_time_limit) {
            if (isServer) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.STALE_MSG, messageID, null);
                sfd.setCorrelationHeader(corrH);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("staleMsg"));
        }
        Long prevMsgIDTime = (Long)messageIDMap.get(messageID);
        long currentTime = System.currentTimeMillis();
        if (prevMsgIDTime != null && currentTime - prevMsgIDTime < (long)stale_time_limit) {
            if (isServer) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.DUPLICATE_MSG, messageID, null);
                sfd.setCorrelationHeader(corrH);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("dupMsg"));
        }
        Map sfd = messageIDMap;
        synchronized (sfd) {
            if (debug.messageEnabled()) {
                debug.message("Utils.checkCorrelationHeader: adding messageID: " + messageID);
            }
            messageIDMap.put(messageID, new Long(currentTime));
        }
        String refToMessageID = corrH.getRefToMessageID();
        if (refToMessageID != null && requestMessageID != null && !refToMessageID.equals(requestMessageID)) {
            if (isServer) {
                SOAPFaultDetail sfd2 = new SOAPFaultDetail(SOAPFaultDetail.INVALID_REF_TO_MSG_ID, messageID, null);
                sfd2.setCorrelationHeader(corrH);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd2);
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("invalidRef"));
        }
    }

    static void checkProviderHeader(ProviderHeader provH, String messageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (provH == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(provH.getActor(), provH.getMustUnderstand(), messageID, isServer);
        }
        catch (SOAPFaultException sfe) {
            sfe.getSOAPFaultMessage().getSOAPFault().getDetail().setProviderHeader(provH);
            throw sfe;
        }
        if (isServer && SOAPBindingService.enforceOnlyKnownProviders()) {
            String providerID = provH.getProviderID();
            ProviderManager providerManager = ProviderUtil.getProviderManager();
            if (!providerManager.containsProvider(providerID)) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.PROVIDER_ID_NOT_VALID, messageID, null);
                sfd.setProviderHeader(provH);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
            String affID = provH.getAffiliationID();
            if (affID != null && !providerManager.isAffiliationMember(providerID, affID)) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.AFFILIATION_ID_NOT_VALID, messageID, null);
                sfd.setProviderHeader(provH);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
        }
    }

    static void checkProcessingContextHeader(ProcessingContextHeader procH, String messageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (procH == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(procH.getActor(), procH.getMustUnderstand(), messageID, isServer);
        }
        catch (SOAPFaultException sfe) {
            sfe.getSOAPFaultMessage().getSOAPFault().getDetail().setProcessingContextHeader(procH);
            throw sfe;
        }
        if (isServer) {
            SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.PROC_CTX_URI_NOT_UNSTD, messageID, null);
            sfd.setProcessingContextHeader(procH);
            SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
            throw new SOAPFaultException(new Message(sf));
        }
        throw new SOAPBindingException(bundle.getString("ProcessingContextUnsupported"));
    }

    static void checkConsentHeader(ConsentHeader consH, String messageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (consH == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(consH.getActor(), consH.getMustUnderstand(), messageID, isServer);
        }
        catch (SOAPFaultException sfe) {
            sfe.getSOAPFaultMessage().getSOAPFault().getDetail().setConsentHeader(consH);
            throw sfe;
        }
    }

    static void checkUsageDirectiveHeader(UsageDirectiveHeader usagH, String messageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (usagH == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(usagH.getActor(), usagH.getMustUnderstand(), messageID, isServer);
        }
        catch (SOAPFaultException sfe) {
            ArrayList<UsageDirectiveHeader> usagHs = new ArrayList<UsageDirectiveHeader>();
            usagHs.add(usagH);
            sfe.getSOAPFaultMessage().getSOAPFault().getDetail().setUsageDirectiveHeaders(usagHs);
            throw sfe;
        }
    }

    static void checkActorAndMustUnderstand(String actor, Boolean mustUnderstand, String messageID, boolean isServer) throws SOAPBindingException, SOAPFaultException {
        if (actor != null && !supportedActors.contains(actor)) {
            if (isServer) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.BOGUS_ACTOR, messageID, null);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("bogusActor"));
        }
        if (mustUnderstand != null && !mustUnderstand.booleanValue()) {
            if (isServer) {
                SOAPFaultDetail sfd = new SOAPFaultDetail(SOAPFaultDetail.BOGUS_MUST_UNSTND, messageID, null);
                SOAPFault sf = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sfd);
                throw new SOAPFaultException(new Message(sf));
            }
            throw new SOAPBindingException(bundle.getString("bogusMustUnderstand"));
        }
    }

    public static String getString(String key, Object[] params) {
        return MessageFormat.format(bundle.getString(key), params);
    }

    public static String getDefaultWSFVersion() {
        return SystemPropertiesManager.get((String)LIBERTY_WSF_VERSION, (String)"1.1");
    }

    static {
        block18: {
            String tmpstr;
            block17: {
                String tmpJaxbPkgs;
                soapOF = new com.sun.identity.liberty.ws.common.jaxb.soap.ObjectFactory();
                soapBOF = new ObjectFactory();
                secOF = new com.sun.identity.liberty.ws.common.jaxb.secext.ObjectFactory();
                FAULT_CODE_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
                faultStringServerError = null;
                debug = null;
                bundle = null;
                messageFactory = null;
                nsPrefix = new HashMap();
                jaxbPackages = null;
                jc = null;
                stale_time_limit = 300000;
                supportedActors = new HashSet();
                message_ID_cleanup_interval = 60000;
                messageIDMap = null;
                bundle = Locale.getInstallResourceBundle((String)"libSOAPBinding");
                faultStringServerError = bundle.getString("ServerError");
                debug = Debug.getInstance((String)"libSOAPBinding");
                try {
                    messageFactory = MessageFactory.newInstance();
                }
                catch (Exception ex) {
                    debug.error("Utils.static: Unable to create SOAP Message Factory", (Throwable)ex);
                }
                String tmpNSPre = SystemPropertiesManager.get((String)NAMESPACE_PREFIX_MAPPING_LIST_PROP);
                if (tmpNSPre != null && tmpNSPre.length() > 0) {
                    StringTokenizer stz = new StringTokenizer(tmpNSPre, "|");
                    while (stz.hasMoreTokens()) {
                        String token = stz.nextToken().trim();
                        int index = token.indexOf(61);
                        if (index != -1 && index != 0 && index != token.length() - 1) {
                            String prefix = token.substring(0, index);
                            String ns = token.substring(index + 1);
                            if (debug.messageEnabled()) {
                                debug.message("Utils.static: add ns = " + ns + ", prefix = " + prefix);
                            }
                            nsPrefix.put(ns, prefix);
                            continue;
                        }
                        if (!debug.warningEnabled()) continue;
                        debug.warning("Utils.static: Invalid syntax for Namespace Prefix Mapping List: " + token);
                    }
                }
                jaxbPackages = (tmpJaxbPkgs = SystemPropertiesManager.get((String)JAXB_PACKAGE_LIST_PROP)) != null && tmpJaxbPkgs.length() > 0 ? "com.sun.identity.liberty.ws.common.jaxb.soap:com.sun.identity.liberty.ws.common.jaxb.assertion:com.sun.identity.liberty.ws.common.jaxb.protocol:com.sun.identity.liberty.ws.common.jaxb.ac:com.sun.identity.liberty.ws.disco.jaxb:com.sun.identity.liberty.ws.disco.jaxb11:com.sun.identity.liberty.ws.disco.plugins.jaxb:com.sun.identity.liberty.ws.interaction.jaxb:com.sun.identity.liberty.ws.meta.jaxb:com.sun.identity.liberty.ws.paos.jaxb:com.sun.identity.liberty.ws.common.jaxb.ps:com.sun.identity.liberty.ws.common.jaxb.security:com.sun.identity.liberty.ws.soapbinding.jaxb:com.sun.identity.liberty.ws.soapbinding.jaxb11:com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.secext:com.sun.identity.liberty.ws.common.jaxb.utility:com.sun.identity.liberty.ws.common.jaxb.xmlenc:com.sun.identity.liberty.ws.common.jaxb.xmlsig:" + tmpJaxbPkgs : DEFAULT_JAXB_PACKAGES;
                if (debug.messageEnabled()) {
                    debug.message("Utils.static: jaxbPackages = " + jaxbPackages);
                }
                try {
                    jc = JAXBContext.newInstance((String)jaxbPackages);
                }
                catch (JAXBException jaxbe) {
                    debug.error("Utils.static:", (Throwable)jaxbe);
                }
                tmpstr = SystemPropertiesManager.get((String)STALE_TIME_LIMIT_PROP);
                if (tmpstr != null) {
                    try {
                        stale_time_limit = Integer.parseInt(tmpstr);
                    }
                    catch (Exception ex) {
                        if (!debug.warningEnabled()) break block17;
                        debug.warning("Utils.static: Unable to get stale time limit. Default value will be used");
                    }
                }
            }
            if ((tmpstr = SystemPropertiesManager.get((String)SUPPORTED_ACTORS_PROP)) != null) {
                StringTokenizer stz = new StringTokenizer(tmpstr, "|");
                while (stz.hasMoreTokens()) {
                    String token = stz.nextToken();
                    if (token.length() <= 0) continue;
                    supportedActors.add(token);
                }
            }
            if ((tmpstr = SystemPropertiesManager.get((String)MESSAGE_ID_CACHE_CLEANUP_INTERVAL_PROP)) != null) {
                try {
                    message_ID_cleanup_interval = Integer.parseInt(tmpstr);
                }
                catch (Exception ex) {
                    if (!debug.warningEnabled()) break block18;
                    debug.warning("Utils.CleanUpThread.static: Unable to get stale time limit. Default value will be used");
                }
            }
        }
        messageIDMap = new PeriodicCleanUpMap((long)message_ID_cleanup_interval, (long)stale_time_limit);
        SystemTimerPool.getTimerPool().schedule((TaskRunnable)messageIDMap, new Date((System.currentTimeMillis() + (long)message_ID_cleanup_interval) / 1000L * 1000L));
    }
}

