/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.log;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.log.LogException;
import com.sun.identity.plugin.log.Logger;
import com.sun.identity.shared.debug.Debug;

public final class LogManager {
    public static final String LOG_PROVIDER_NAME = "com.sun.identity.plugin.log.class";
    public static final Debug debug = Debug.getInstance((String)"fmLogManager");

    public static Logger getLogger(String componentName) throws LogException {
        Logger logProvider = null;
        String pluginName = SystemConfigurationUtil.getProperty(LOG_PROVIDER_NAME, "com.sun.identity.plugin.log.impl.LogProvider");
        try {
            if (pluginName != null && pluginName.length() > 0) {
                Class<?> logProviderClass = Class.forName(pluginName.trim());
                logProvider = (Logger)logProviderClass.newInstance();
                logProvider.init(componentName);
            }
        }
        catch (Exception e) {
            debug.error("Error creating class instance : ", (Throwable)e);
            throw new LogException(e);
        }
        return logProvider;
    }
}

