/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.session;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.ResourceBundle;

public final class SessionManager {
    private static final String PROP_SESSION_IMPL_CLASS = "com.sun.identity.plugin.session.class";
    private static SessionProvider sp = null;
    private static Debug debug = Debug.getInstance((String)"libSessionProvider");
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libSessionProvider");

    public static SessionProvider getProvider() throws SessionException {
        if (sp == null) {
            throw new SessionException(bundle.getString("nullSessionProvider"));
        }
        return sp;
    }

    static {
        String sessionClass = SystemConfigurationUtil.getProperty(PROP_SESSION_IMPL_CLASS);
        if (sessionClass == null || sessionClass.length() == 0) {
            debug.error("SessionManager static block: the property com.sun.identity.plugin.session.class is not set.");
        } else {
            try {
                sp = (SessionProvider)Class.forName(sessionClass).newInstance();
            }
            catch (IllegalAccessException iae) {
                debug.error("SessionManager static block: Failed creating SessionProvider instance: " + sessionClass, (Throwable)iae);
            }
            catch (InstantiationException ie) {
                debug.error("SessionManager static block: Failed creating SessionProvider instance: " + sessionClass, (Throwable)ie);
            }
            catch (ClassNotFoundException cnfe) {
                debug.error("SessionManager static block: Unable to find class " + sessionClass, (Throwable)cnfe);
            }
        }
    }
}

