/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sae.api;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Utils {
    public static final String POST = "POST";
    public static final String GET = "GET";

    public static void redirect(HttpServletResponse hres, String redirectUrl, Map pmap, String action) throws Exception {
        if (action.equals(GET)) {
            StringBuffer buf = null;
            if (pmap != null) {
                String query = Utils.queryStringFromMap(pmap);
                buf = new StringBuffer();
                buf.append(redirectUrl);
                if (!redirectUrl.contains("?")) {
                    buf.append("?");
                }
                buf.append(query);
            }
            String finalRedirectUrl = redirectUrl;
            if (buf != null) {
                finalRedirectUrl = buf.toString();
            }
            hres.sendRedirect(finalRedirectUrl);
            return;
        }
        String html = Utils.formFromMap(redirectUrl, pmap, true);
        hres.getWriter().write(html);
    }

    public static String queryStringFromRequest(HttpServletRequest request) {
        Enumeration en = request.getParameterNames();
        StringBuffer buf = new StringBuffer();
        boolean priorparam = false;
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String val = request.getParameter(name);
            if (priorparam) {
                buf.append("&");
            }
            buf.append(name + "=" + val);
            priorparam = true;
        }
        return buf.toString();
    }

    public static String queryStringFromMap(Map pmap) {
        Iterator iter = pmap.keySet().iterator();
        StringBuffer buf = new StringBuffer();
        boolean priorparam = false;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String val = (String)pmap.get(name);
            if (priorparam) {
                buf.append("&");
            }
            buf.append(name + "=" + URLEncoder.encode(val));
            priorparam = true;
        }
        return buf.toString();
    }

    public static String formFromMap(String redirectUrl, Map pmap, boolean addAutoSubmit) {
        StringBuffer buf = new StringBuffer();
        if (addAutoSubmit) {
            buf.append("<HTML><HEAD><TITLE>SAE POST</TITLE></HEAD>");
            buf.append("<BODY Onload=\"document.forms[0].submit()\">");
        }
        buf.append("<FORM id=\"saeform\" METHOD=\"POST\" ACTION=\"" + redirectUrl + "\">");
        Iterator iter = pmap.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String val = (String)pmap.get(name);
            buf.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + name + "\" " + "VALUE=\"" + val + "\">");
        }
        buf.append("</FORM>");
        if (addAutoSubmit) {
            buf.append("</BODY></HTML>");
        }
        return buf.toString();
    }
}

