/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AdviceBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatementBase;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AssertionBase {
    protected static SAMLConstants sc;
    protected Set _statements = Collections.synchronizedSet(new HashSet());
    protected int _majorVersion = 1;
    protected int _minorVersion = SAMLConstants.ASSERTION_MINOR_VERSION;
    protected AssertionIDReference _assertionID = null;
    protected String _issuer = null;
    protected Date _issueInstant;
    protected Conditions _conditions;
    protected AdviceBase _advice;
    protected String xmlString = null;
    protected String signatureString = null;
    protected Element signature = null;
    protected boolean signed = false;
    protected boolean valid = true;
    protected boolean validationDone = true;
    protected static final String ASSERTION_ID_ATTRIBUTE = "AssertionID";

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return false;
    }

    public void signXML() throws SAMLException {
        throw new UnsupportedOperationException();
    }

    public void signXML(String certAlias) throws SAMLException {
        throw new UnsupportedOperationException();
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element elem) {
        if (this.signed) {
            return false;
        }
        if (elem == null) {
            return false;
        }
        this.signature = elem;
        this.signed = true;
        this.signatureString = XMLUtils.print((Node)elem);
        return true;
    }

    protected abstract AdviceBase createAdvice(Element var1) throws SAMLException;

    protected abstract AuthorizationDecisionStatementBase createAuthorizationDecisionStatement(Element var1) throws SAMLException;

    protected abstract AuthenticationStatement createAuthenticationStatement(Element var1) throws SAMLException;

    protected abstract AttributeStatement createAttributeStatement(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(String var1) throws SAMLException;

    protected abstract Conditions createConditions(Element var1) throws SAMLException;

    protected AssertionBase() {
    }

    public AssertionBase(Element assertionElement) throws SAMLException {
        Element elt = assertionElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!eltName.equals("Assertion")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + eltName);
        }
        String read = elt.getAttribute("Issuer");
        if (read == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":Issuer");
        }
        this._issuer = read;
        List signs = XMLUtils.getElementsByTagNameNS1((Element)assertionElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            this.xmlString = XMLUtils.print((Node)assertionElement);
            this.signed = true;
            this.validationDone = false;
        } else if (signsSize != 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
        read = elt.getAttribute("MajorVersion");
        if (read == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int ver = 0;
        try {
            ver = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MajorVersion", (Throwable)ne);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (ver != 1) {
            if (ver < 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (ver > 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
            this._minorVersion = Integer.parseInt(read);
        }
        if ((read = elt.getAttribute("MinorVersion")) == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        ver = 0;
        try {
            ver = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MinorVersion", (Throwable)ne);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (ver < 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too low");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow"));
        }
        if (ver > 1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too high");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
        }
        this._minorVersion = ver;
        read = elt.getAttribute(ASSERTION_ID_ATTRIBUTE);
        if (read == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + ASSERTION_ID_ATTRIBUTE);
        }
        this._assertionID = this.createAssertionIDReference(read);
        read = elt.getAttribute("IssueInstant");
        if (read == null || read.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = DateUtils.stringToDate((String)read);
        }
        catch (ParseException pe) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: could not parse IssueInstant", (Throwable)pe);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput") + " " + pe.getMessage());
        }
        boolean statementFound = false;
        NodeList nl = assertionElement.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("Conditions")) {
                this._conditions = this.createConditions((Element)child);
                continue;
            }
            if (childName.equals("Advice")) {
                this._advice = this.createAdvice((Element)child);
                continue;
            }
            if (childName.equals("AuthenticationStatement")) {
                this._statements.add(this.createAuthenticationStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("AuthorizationDecisionStatement")) {
                this._statements.add(this.createAuthorizationDecisionStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("AttributeStatement")) {
                this._statements.add(this.createAttributeStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: invalid element in Assertion");
            }
            throw new SAMLRequesterException("invalidElement");
        }
        if (!statementFound) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public boolean isTimeValid() {
        if (this._conditions == null) {
            return true;
        }
        return this._conditions.checkDateValidity(System.currentTimeMillis());
    }

    public AssertionBase(String assertionID, String issuer, Date issueInstant, Set statements) throws SAMLException {
        if (issuer == null || issuer.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (statements.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(statements);
        this._assertionID = this.createAssertionIDReference(assertionID);
        if (issuer != null) {
            this._issuer = issuer;
        }
        this._issueInstant = issueInstant != null ? issueInstant : new Date();
    }

    public AssertionBase(String assertionID, String issuer, Date issueInstant, Conditions conditions, Set statements) throws SAMLException {
        if (issuer == null || issuer.length() == 0 || conditions == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (statements.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(statements);
        this._assertionID = this.createAssertionIDReference(assertionID);
        if (issuer != null) {
            this._issuer = issuer;
        }
        this._issueInstant = issueInstant != null ? issueInstant : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
    }

    public AssertionBase(String assertionID, String issuer, Date issueInstant, Conditions conditions, AdviceBase advice, Set statements) throws SAMLException {
        if (issuer == null || issuer.length() == 0 || conditions == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (statements.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(statements);
        this._assertionID = this.createAssertionIDReference(assertionID);
        if (issuer != null) {
            this._issuer = issuer;
        }
        this._issueInstant = issueInstant != null ? issueInstant : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
        if (advice != null) {
            this._advice = advice;
        }
    }

    public boolean addStatement(Statement statement) {
        if (this.signed) {
            return false;
        }
        if (statement == null) {
            return false;
        }
        this._statements.add(statement);
        return true;
    }

    protected boolean setIssueInstant(Date issueInstant) {
        if (this.signed) {
            return false;
        }
        if (issueInstant == null) {
            return false;
        }
        this._issueInstant = issueInstant;
        return true;
    }

    protected boolean setAssertionID(String assertionID) {
        if (this.signed) {
            return false;
        }
        if (assertionID == null) {
            return false;
        }
        try {
            this._assertionID = this.createAssertionIDReference(assertionID);
        }
        catch (Exception e) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: Exception in setting assertion id: " + e.getMessage());
            }
            return false;
        }
        return true;
    }

    protected boolean setIssuer(String issuer) {
        if (this.signed) {
            return false;
        }
        if (issuer == null || issuer.length() == 0) {
            return false;
        }
        this._issuer = issuer;
        return true;
    }

    public boolean setAdvice(AdviceBase advice) {
        if (this.signed) {
            return false;
        }
        if (advice == null) {
            return false;
        }
        this._advice = advice;
        return true;
    }

    public boolean setConditions(Conditions conditions) {
        if (this.signed) {
            return false;
        }
        if (conditions == null) {
            return false;
        }
        this._conditions = conditions;
        return true;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this._minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this._majorVersion = majorVersion;
    }

    public Date getIssueInstant() {
        return this._issueInstant;
    }

    public String getIssuer() {
        return this._issuer;
    }

    public String getAssertionID() {
        return this._assertionID.getAssertionIDReference();
    }

    public Conditions getConditions() {
        return this._conditions;
    }

    public Set getStatement() {
        return this._statements;
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (includeNS) {
            appendNS = "saml:";
        }
        String dateStr = null;
        if (this._issueInstant != null) {
            dateStr = DateUtils.toUTCDateFormat((Date)this._issueInstant);
        }
        xml.append("<").append(appendNS).append("Assertion").append(" ").append(NS).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(dateStr).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            xml.append(this._conditions.toString(includeNS, false));
        }
        if (this._advice != null) {
            xml.append(this._advice.toString(includeNS, false));
        }
        Iterator i = this.getStatement().iterator();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            xml.append(st.toString(includeNS, false));
        }
        if (this.signed && this.signatureString != null) {
            xml.append(this.signatureString);
        }
        String o = SAMLUtilsCommon.makeEndElementTagXML("Assertion", includeNS);
        xml.append(o);
        return xml.toString();
    }
}

