/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLSiteID;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.plugins.DefaultAttributeMapper;
import com.sun.identity.saml.plugins.NameIdentifierMapper;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.plugins.PartnerSiteAttributeMapper;
import com.sun.identity.saml.plugins.SiteAttributeMapper;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SAMLServiceManager
implements ConfigurationListener {
    private static ConfigurationInstance ci = null;
    private static Map map = null;
    private static SAMLServiceManager instance = null;
    private static Object ssoToken = null;
    public static boolean localFlag = false;
    private static String serverProtocol = null;
    private static String serverHost = null;
    private static String serverPort = null;
    private static String serverURI;
    private static String serverURL;
    private static boolean removeAssertion;
    private static String DEFAULT_PARTNER_ACCOUNT_MAPPER;

    private SAMLServiceManager() {
    }

    private static void init() {
        SAMLUtilsCommon.debug.message("SAMLServiceManager.init: Constructing a new instance of SAMLServiceManager");
        instance = new SAMLServiceManager();
        try {
            ci = ConfigurationManager.getConfigurationInstance("SAML1");
            ci.addListener(new SAMLServiceManager());
            SAMLServiceManager.setValues();
            String rmAssertion = SystemConfigurationUtil.getProperty("com.sun.identity.saml.removeassertion");
            if (rmAssertion != null && rmAssertion.length() != 0) {
                removeAssertion = Boolean.valueOf(rmAssertion);
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("SAMLServiceManager.init()", (Throwable)e);
        }
    }

    public static boolean getRemoveAssertion() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return removeAssertion;
    }

    public static String getServerProtocol() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverProtocol;
    }

    public static String getServerHost() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverHost;
    }

    public static String getServerPort() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverPort;
    }

    public static String getServerURI() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverURI;
    }

    public static String getServerURL() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverURL;
    }

    private static synchronized void setValues() {
        if (ci == null) {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.put("iplanet-am-saml-artifact-timeout", new Integer(120));
            newMap.put("iplanet-am-saml-assertion-timeout", new Integer(60));
            newMap.put("iplanet-am-saml-artifact-name", "SAMLart");
            newMap.put("iplanet-am-saml-target-specifier", "TARGET");
            newMap.put("iplanet-am-saml-assertion-max-number", new Integer(0));
            newMap.put("iplanet-am-saml-cleanup-interval", new Integer(180));
            newMap.put("iplanet-am-saml-signrequest", Boolean.valueOf("false"));
            newMap.put("iplanet-am-saml-signresponse", Boolean.valueOf("false"));
            newMap.put("iplanet-am-saml-signassertion", Boolean.valueOf("false"));
            map = newMap;
        } else {
            try {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                Map attrs = ci.getConfiguration(null, null);
                Set values = (Set)attrs.get("iplanet-am-saml-notbefore-timeskew");
                int value = 300;
                if (values != null && values.size() == 1) {
                    try {
                        value = Integer.parseInt((String)values.iterator().next());
                    }
                    catch (NumberFormatException nfe) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid not before time skew period value: " + value + ", using default.", (Throwable)nfe);
                        value = 300;
                    }
                    if (value <= 0) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid not before time skew period value=" + value + ", using default.");
                        value = 300;
                    }
                }
                Integer newValue = new Integer(value);
                newMap.put("iplanet-am-saml-notbefore-timeskew", newValue);
                values = (Set)attrs.get("iplanet-am-saml-artifact-timeout");
                value = 120;
                if (values != null && values.size() == 1) {
                    try {
                        value = Integer.parseInt((String)values.iterator().next());
                    }
                    catch (NumberFormatException nfe) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid artifact timeout value: " + value + ", using default.", (Throwable)nfe);
                        value = 120;
                    }
                    if (value <= 0) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid artifact timeout value=" + value + ", using default.");
                        value = 120;
                    }
                }
                newValue = new Integer(value);
                newMap.put("iplanet-am-saml-artifact-timeout", newValue);
                values = (Set)attrs.get("iplanet-am-saml-assertion-timeout");
                value = 60;
                if (values != null && values.size() == 1) {
                    try {
                        value = Integer.parseInt((String)values.iterator().next());
                    }
                    catch (NumberFormatException nfe) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid assertion timeout value: " + value + ", using default.", (Throwable)nfe);
                        value = 60;
                    }
                    if (value <= 0) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid assertion timeout value=" + value + ", using default.");
                        value = 60;
                    }
                }
                newValue = new Integer(value);
                newMap.put("iplanet-am-saml-assertion-timeout", newValue);
                values = (Set)attrs.get("iplanet-am-saml-assertion-max-number");
                value = 0;
                if (values != null && values.size() == 1) {
                    try {
                        value = Integer.parseInt((String)values.iterator().next());
                    }
                    catch (NumberFormatException nfe) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid assertion max number value: " + value + ", using default.", (Throwable)nfe);
                        value = 0;
                    }
                    if (value < 0) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid assertion max number value=" + value + ", using default.");
                        value = 0;
                    }
                }
                newValue = new Integer(value);
                newMap.put("iplanet-am-saml-assertion-max-number", newValue);
                values = (Set)attrs.get("iplanet-am-saml-cleanup-interval");
                value = 180;
                if (values != null && values.size() == 1) {
                    try {
                        value = Integer.parseInt((String)values.iterator().next());
                    }
                    catch (NumberFormatException nfe) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid cleanup interval value: " + value + ", using default.", (Throwable)nfe);
                        value = 180;
                    }
                    if (value <= 0) {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager:invalid cleanup interval value=" + value + ", using default.");
                        value = 180;
                    }
                }
                newValue = new Integer(value);
                newMap.put("iplanet-am-saml-cleanup-interval", newValue);
                String artifactName = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-saml-artifact-name", (String)"SAMLart");
                newMap.put("iplanet-am-saml-artifact-name", artifactName);
                Set targets = (Set)attrs.get("iplanet-am-saml-post-to-target-urls");
                if (targets == null || targets.size() == 0) {
                    SAMLUtilsCommon.debug.message("SAMLServiceManager: No POST to targets found");
                } else {
                    Set<String> targetsNoProtocol = Collections.synchronizedSet(new HashSet());
                    Iterator it = targets.iterator();
                    String targetString = null;
                    while (it.hasNext()) {
                        try {
                            targetString = (String)it.next();
                            URL url = new URL(targetString);
                            String targetNoProtocol = url.getHost().toLowerCase() + ":" + String.valueOf(url.getPort()) + "/" + url.getPath();
                            targetsNoProtocol.add(targetNoProtocol);
                        }
                        catch (MalformedURLException me) {
                            SAMLUtilsCommon.debug.error("SAMLServiceManager: Malformed Url in the POST to target list, skipping entry:" + targetString);
                        }
                    }
                    if (targetsNoProtocol.size() > 0) {
                        newMap.put("iplanet-am-saml-post-to-target-urls", targetsNoProtocol);
                    } else {
                        SAMLUtilsCommon.debug.error("SAMLServiceManager: All POST to target URLs malformed");
                    }
                }
                serverProtocol = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol");
                serverHost = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
                serverPort = SystemConfigurationUtil.getProperty("com.iplanet.am.server.port");
                serverURI = SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor");
                String legacyId = serverProtocol + "://" + serverHost + ":" + serverPort;
                String sb = serverURL = legacyId + serverURI;
                HashMap<String, String> siteidMap = new HashMap<String, String>();
                HashMap<String, String> issuerNameMap = new HashMap<String, String>();
                HashMap<String, String> instanceMap = new HashMap<String, String>();
                Set siteIDNameList = (Set)attrs.get("iplanet-am-saml-siteid-issuername-list");
                if (siteIDNameList.size() == 0) {
                    SAMLUtilsCommon.debug.error("SAMLServiceManager: No Site ID or Issuer Name in the SAML service config.");
                } else {
                    String entry = null;
                    StringTokenizer tok1 = null;
                    String instanceID = null;
                    String siteID = null;
                    String issuerName = null;
                    String element = null;
                    String key = null;
                    Iterator iter = siteIDNameList.iterator();
                    while (iter.hasNext()) {
                        boolean thisSite;
                        entry = (String)iter.next();
                        instanceID = null;
                        siteID = null;
                        issuerName = null;
                        tok1 = new StringTokenizer(entry, "|");
                        while (tok1.hasMoreElements()) {
                            element = tok1.nextToken();
                            int pos = -1;
                            pos = element.indexOf("=");
                            if (pos == -1) {
                                SAMLUtilsCommon.debug.error("SAMLSManager: wrong format: " + element);
                                break;
                            }
                            int nextpos = pos + 1;
                            if (nextpos >= element.length()) {
                                SAMLUtilsCommon.debug.error("SAMLSManager: wrong format: " + element);
                                break;
                            }
                            key = element.substring(0, pos);
                            if (key.equalsIgnoreCase("INSTANCEID")) {
                                instanceID = element.substring(nextpos);
                                continue;
                            }
                            if (key.equalsIgnoreCase("SITEID")) {
                                siteID = element.substring(nextpos);
                                continue;
                            }
                            if (key.equalsIgnoreCase("ISSUERNAME")) {
                                issuerName = element.substring(nextpos);
                                continue;
                            }
                            SAMLUtilsCommon.debug.error("SAMLSManager: wrong format: " + element);
                        }
                        if (instanceID == null) {
                            SAMLUtilsCommon.debug.error("SAMLServiceManager: missing instanceID:" + entry);
                            break;
                        }
                        boolean bl = thisSite = instanceID.equalsIgnoreCase(sb) || instanceID.equalsIgnoreCase(legacyId);
                        if (siteID != null && (siteID = SAMLUtilsCommon.getDecodedSourceIDString(siteID)) != null) {
                            siteidMap.put(instanceID, siteID);
                            instanceMap.put(siteID, instanceID);
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("SAMLSMangr: add instanceID: " + instanceID + ", serverURL=" + sb + ", legacy serverURL=" + legacyId + ", isthissite=" + thisSite);
                            }
                            if (thisSite) {
                                newMap.put("mysiteid", siteID);
                            }
                        }
                        if (issuerName == null) continue;
                        issuerNameMap.put(instanceID, issuerName);
                        if (!thisSite) continue;
                        newMap.put("mysitename", issuerName);
                    }
                }
                if (!siteidMap.containsKey(sb) && !siteidMap.containsKey(legacyId)) {
                    String siteID = SAMLSiteID.generateSourceID(sb);
                    if (SAMLUtilsCommon.debug.warningEnabled()) {
                        SAMLUtilsCommon.debug.warning("SAMLSManager: site " + sb + " not configured, create new " + siteID);
                    }
                    if (siteID != null) {
                        if ((siteID = SAMLUtilsCommon.getDecodedSourceIDString(siteID)) != null) {
                            siteidMap.put(sb, siteID);
                            instanceMap.put(siteID, sb);
                            newMap.put("mysiteid", siteID);
                        } else {
                            SAMLUtilsCommon.debug.error("Missing Site ID.");
                        }
                    }
                }
                if (!issuerNameMap.containsKey(sb) && !issuerNameMap.containsKey(legacyId)) {
                    if (SAMLUtilsCommon.debug.warningEnabled()) {
                        SAMLUtilsCommon.debug.warning("SAMLSManager:issuer for " + sb + " not configured, set to " + sb);
                    }
                    issuerNameMap.put(sb, sb);
                    newMap.put("mysitename", sb);
                }
                newMap.put("iplanet-am-saml-siteid-list", siteidMap);
                newMap.put("iplanet-am-saml-instance-list", instanceMap);
                newMap.put("iplanet-am-saml-issuername-list", issuerNameMap);
                Boolean signRequest = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-saml-signrequest", (String)"false"));
                newMap.put("iplanet-am-saml-signrequest", signRequest);
                Boolean signResponse = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-saml-signresponse", (String)"false"));
                newMap.put("iplanet-am-saml-signresponse", signResponse);
                Boolean signAssertion = Boolean.valueOf(CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-saml-signassertion", (String)"false"));
                newMap.put("iplanet-am-saml-signassertion", signAssertion);
                String targetName = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-saml-target-specifier", (String)"TARGET");
                newMap.put("iplanet-am-saml-target-specifier", targetName);
                Set soapRevList = Collections.synchronizedSet(new HashSet());
                soapRevList = (Set)attrs.get("iplanet-am-saml-partner-urls");
                if (soapRevList.size() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SAMLServiceManager: No entry in partner url config!");
                    }
                } else {
                    Set<SiteEntry> _Sites = Collections.synchronizedSet(new HashSet());
                    Map<String, SOAPEntry> _Soaps = Collections.synchronizedMap(new HashMap());
                    Object[] soapObjects = soapRevList.toArray();
                    int size = soapObjects.length;
                    String e = null;
                    String element = null;
                    for (int i = 0; i < size; ++i) {
                        String _siteID = null;
                        String _samlUrl = null;
                        String postUrl = null;
                        String host = null;
                        int port = -1;
                        String _destID = null;
                        String _soapRevUrl = null;
                        String _authType = null;
                        String _user = null;
                        String basic_auth_user = null;
                        String basic_auth_passwd = null;
                        String _certAlias = null;
                        String preferVersion = null;
                        PartnerAccountMapper _partnerAccountMapper = null;
                        SiteAttributeMapper _siteAttributeMapper = null;
                        PartnerSiteAttributeMapper _partnerSiteAttributeMapper = null;
                        NameIdentifierMapper niMapper = null;
                        AttributeMapper attrMapper = null;
                        ActionMapper actionMapper = null;
                        String _issuer = null;
                        HashSet<String> hostSet = null;
                        HashSet<String> origHostSet = null;
                        e = (String)soapObjects[i];
                        if (e.toUpperCase().indexOf("SOURCEID") == -1) {
                            SAMLUtilsCommon.debug.error("Ignore this trusted site since SourceID is absent:" + e);
                            continue;
                        }
                        StringTokenizer tok1 = new StringTokenizer(e, "|");
                        while (tok1.hasMoreElements()) {
                            Object temp;
                            element = tok1.nextToken();
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("SAMLSManager: PartnerUrl List:" + element);
                            }
                            int pos = -1;
                            pos = element.indexOf("=");
                            if (pos == -1) {
                                SAMLUtilsCommon.debug.error("SAMLSManager: illegal format of PartnerUrl:" + element);
                                break;
                            }
                            int nextpos = pos + 1;
                            if (nextpos >= element.length()) break;
                            String key = element.substring(0, pos);
                            if (key.equalsIgnoreCase("SOURCEID")) {
                                _destID = SAMLUtilsCommon.getDecodedSourceIDString(element.substring(nextpos));
                                continue;
                            }
                            if (key.equalsIgnoreCase("TARGET")) {
                                _siteID = element.substring(nextpos);
                                continue;
                            }
                            if (key.equalsIgnoreCase("SAMLURL")) {
                                _samlUrl = element.substring(nextpos).trim();
                                continue;
                            }
                            if (key.equalsIgnoreCase("POSTURL")) {
                                postUrl = element.substring(nextpos).trim();
                                continue;
                            }
                            if (key.equalsIgnoreCase("SOAPURL")) {
                                _soapRevUrl = element.substring(nextpos).trim();
                                continue;
                            }
                            if (key.equalsIgnoreCase("AUTHTYPE")) {
                                _authType = element.substring(nextpos);
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("authtype =" + _authType);
                                continue;
                            }
                            if (key.equalsIgnoreCase("USER")) {
                                _user = element.substring(nextpos);
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("user = " + _user);
                                continue;
                            }
                            if (key.equalsIgnoreCase("AUTHUSER")) {
                                basic_auth_user = element.substring(nextpos);
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("basic auth user=" + basic_auth_user);
                                continue;
                            }
                            if (key.equalsIgnoreCase("AUTHPASSWORD")) {
                                basic_auth_passwd = SAMLUtilsCommon.decodePassword(element.substring(nextpos));
                                continue;
                            }
                            if (key.equalsIgnoreCase("ACCOUNTMAPPER")) {
                                try {
                                    temp = Class.forName(element.substring(nextpos)).newInstance();
                                    if (temp instanceof PartnerAccountMapper) {
                                        _partnerAccountMapper = (PartnerAccountMapper)temp;
                                        continue;
                                    }
                                    SAMLUtilsCommon.debug.error("SAMLServiceManager:Invalid account mapper");
                                }
                                catch (InstantiationException ie) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ie);
                                }
                                catch (IllegalAccessException ae) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ae);
                                }
                                catch (ClassNotFoundException ce) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ce);
                                    _partnerAccountMapper = null;
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("PARTNERACCOUNTMAPPER")) {
                                try {
                                    _partnerAccountMapper = (PartnerAccountMapper)Class.forName(element.substring(nextpos)).newInstance();
                                }
                                catch (InstantiationException ie) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ie);
                                }
                                catch (IllegalAccessException ae) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ae);
                                }
                                catch (ClassNotFoundException ce) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ce);
                                    _partnerAccountMapper = null;
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("CERTALIAS")) {
                                _certAlias = element.substring(nextpos);
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("certAlias = " + _certAlias);
                                continue;
                            }
                            if (key.equalsIgnoreCase("siteattributemapper")) {
                                try {
                                    temp = Class.forName(element.substring(nextpos)).newInstance();
                                    if (temp instanceof SiteAttributeMapper) {
                                        _siteAttributeMapper = (SiteAttributeMapper)temp;
                                        continue;
                                    }
                                    if (temp instanceof PartnerSiteAttributeMapper) {
                                        _partnerSiteAttributeMapper = (PartnerSiteAttributeMapper)temp;
                                        continue;
                                    }
                                    SAMLUtilsCommon.debug.error("SAMLServiceManager:Invalid site attribute mapper");
                                }
                                catch (InstantiationException ie) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ie);
                                }
                                catch (IllegalAccessException ae) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ae);
                                }
                                catch (ClassNotFoundException ce) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ce);
                                    _siteAttributeMapper = null;
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("partnersiteattributemapper")) {
                                try {
                                    _partnerSiteAttributeMapper = (PartnerSiteAttributeMapper)Class.forName(element.substring(nextpos)).newInstance();
                                }
                                catch (InstantiationException ie) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ie);
                                }
                                catch (IllegalAccessException ae) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ae);
                                }
                                catch (ClassNotFoundException ce) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ce);
                                    _partnerSiteAttributeMapper = null;
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("nameidentifiermapper")) {
                                try {
                                    niMapper = (NameIdentifierMapper)Class.forName(element.substring(nextpos)).newInstance();
                                }
                                catch (Exception ex) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:", (Throwable)ex);
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("ATTRIBUTEMAPPER")) {
                                try {
                                    attrMapper = (AttributeMapper)Class.forName(element.substring(nextpos)).newInstance();
                                }
                                catch (Exception ex) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ex);
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("ACTIONMAPPER")) {
                                try {
                                    actionMapper = (ActionMapper)Class.forName(element.substring(nextpos)).newInstance();
                                }
                                catch (Exception ex) {
                                    SAMLUtilsCommon.debug.error("SAMLSManager:" + ex);
                                }
                                continue;
                            }
                            if (key.equalsIgnoreCase("ISSUER")) {
                                _issuer = element.substring(nextpos).trim();
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("issuer = " + _issuer);
                                continue;
                            }
                            if (key.equalsIgnoreCase("hostlist")) {
                                origHostSet = new HashSet<String>();
                                hostSet = new HashSet<String>();
                                StringTokenizer st = new StringTokenizer(element.substring(nextpos), ",");
                                InetAddress[] addr = null;
                                while (st.hasMoreTokens()) {
                                    String token;
                                    block121: {
                                        token = st.nextToken().trim();
                                        try {
                                            addr = InetAddress.getAllByName(token);
                                            int length = addr.length;
                                            for (int m = 0; m < length; ++m) {
                                                hostSet.add(addr[m].getHostAddress());
                                            }
                                        }
                                        catch (Exception ne) {
                                            if (!SAMLUtilsCommon.debug.warningEnabled()) break block121;
                                            SAMLUtilsCommon.debug.warning("SAML Service Manager: possible wrong hostname in the host list.");
                                        }
                                    }
                                    hostSet.add(token);
                                    origHostSet.add(token);
                                }
                                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                                SAMLUtilsCommon.debug.message("hostSet = " + hostSet);
                                continue;
                            }
                            if (!key.equalsIgnoreCase("VERSION")) continue;
                            preferVersion = element.substring(nextpos);
                        }
                        if (_authType == null) {
                            _authType = "NOAUTH";
                        }
                        if (_partnerAccountMapper == null) {
                            try {
                                _partnerAccountMapper = (PartnerAccountMapper)Class.forName(DEFAULT_PARTNER_ACCOUNT_MAPPER).newInstance();
                            }
                            catch (Exception ex0) {
                                // empty catch block
                            }
                        }
                        if (attrMapper == null) {
                            attrMapper = new DefaultAttributeMapper();
                        }
                        if (preferVersion == null || preferVersion.length() == 0) {
                            try {
                                preferVersion = SystemConfigurationUtil.getProperty("com.sun.identity.saml.protocol.version").trim();
                            }
                            catch (Exception pe) {
                                preferVersion = "1.0";
                            }
                        }
                        if (_destID == null || _destID.length() == 0) {
                            SAMLUtilsCommon.debug.error("Ignore this trusted site since SourceID is misconfigured: " + e);
                            continue;
                        }
                        if (_siteID == null || _siteID.length() == 0 || (_samlUrl == null || _samlUrl.length() == 0) && (postUrl == null || postUrl.length() == 0)) {
                            SAMLUtilsCommon.debug.warning("Target or both SAMLUrl and POSTUrl are misconfigured:" + e);
                        }
                        if (_siteID != null && _siteID.length() != 0) {
                            StringTokenizer tok2 = new StringTokenizer(_siteID, ",");
                            while (tok2.hasMoreElements()) {
                                StringTokenizer pt;
                                String el = tok2.nextToken();
                                if (SAMLUtilsCommon.debug.messageEnabled()) {
                                    SAMLUtilsCommon.debug.message("SAMLServiceManager:target= " + el);
                                }
                                if ((pt = new StringTokenizer(el, ":")).countTokens() == 2) {
                                    host = pt.nextToken().trim();
                                    port = Integer.parseInt(pt.nextToken().trim());
                                    continue;
                                }
                                host = el;
                                port = -1;
                            }
                            SiteEntry server = new SiteEntry(host, port, _destID, _samlUrl, postUrl, preferVersion);
                            _Sites.add(server);
                        }
                        SOAPEntry server = new SOAPEntry(_destID, _soapRevUrl, _authType, _user, basic_auth_user, basic_auth_passwd, _certAlias, _partnerAccountMapper, _siteAttributeMapper, _partnerSiteAttributeMapper, niMapper, attrMapper, actionMapper, _issuer, origHostSet, preferVersion);
                        _Soaps.put(_destID, server);
                        if (_issuer == null) continue;
                        _Soaps.put(_issuer, server);
                    }
                    newMap.put("iplanet-am-saml-trusted-server-list", _Sites);
                    newMap.put("iplanet-am-saml-partner-urls", _Soaps);
                }
                map = newMap;
            }
            catch (Exception e) {
                SAMLUtilsCommon.debug.error("SAMLServiceManager.setValues: Exception:", (Throwable)e);
            }
        }
    }

    public static synchronized Object getAttribute(String attributeName) {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return map.get(attributeName);
    }

    public static String getAuthMethodURI(String authModuleName) {
        if (authModuleName == null) {
            return null;
        }
        if (authModuleName.equalsIgnoreCase("Cert")) {
            return "urn:ietf:rfc:2246";
        }
        if (authModuleName.equalsIgnoreCase("Kerberos")) {
            return "urn:ietf:rfc:1510";
        }
        if (SAMLConstants.passwordAuthMethods.contains(authModuleName.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:password";
        }
        if (SAMLConstants.tokenAuthMethods.contains(authModuleName.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("urn:com:sun:identity:").append(authModuleName);
        return sb.toString();
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAMLServiceManager:configChanged");
        }
        SAMLServiceManager.setValues();
    }

    static {
        serverURL = null;
        removeAssertion = false;
        DEFAULT_PARTNER_ACCOUNT_MAPPER = "com.sun.identity.saml.plugins.DefaultPartnerAccountMapper";
    }

    public static class SOAPEntry {
        private String destID = null;
        private String soapRevUrl = null;
        private String authenType = null;
        private String userid = null;
        private String basicAuthUserID = null;
        private String basicAuthPasswd = null;
        private String certalias = null;
        private PartnerAccountMapper partnerAcctMapper = null;
        private SiteAttributeMapper _siteAttributeMapper = null;
        private PartnerSiteAttributeMapper _partnerSiteAttributeMapper = null;
        private NameIdentifierMapper nameIdentifierMapper = null;
        private AttributeMapper attributeMapper = null;
        private ActionMapper actionMapper = null;
        private String _issuer = null;
        private Set origHostSet = null;
        private String prefVersion = null;

        public SOAPEntry(String sourceid, String soapUrl, String authType, String user, String bAuthUserID, String bAuthPasswd, String certAlias, PartnerAccountMapper partnerAccountMapper, SiteAttributeMapper siteAttributeMapper, PartnerSiteAttributeMapper partnerSiteAttributeMapper, NameIdentifierMapper nameIdentifierMapper, AttributeMapper attrMapper, ActionMapper actionMapper, String issuer, Set origHostSet, String version) {
            this.destID = sourceid;
            this.soapRevUrl = soapUrl;
            this.authenType = authType;
            this.userid = user;
            this.basicAuthUserID = bAuthUserID;
            this.basicAuthPasswd = bAuthPasswd;
            this.certalias = certAlias;
            this.partnerAcctMapper = partnerAccountMapper;
            this._siteAttributeMapper = siteAttributeMapper;
            this._partnerSiteAttributeMapper = partnerSiteAttributeMapper;
            this.nameIdentifierMapper = nameIdentifierMapper;
            this.attributeMapper = attrMapper;
            this.actionMapper = actionMapper;
            this._issuer = issuer;
            this.origHostSet = origHostSet;
            this.prefVersion = version;
        }

        public String getSourceID() {
            return this.destID;
        }

        public String getSOAPUrl() {
            return this.soapRevUrl;
        }

        public String getAuthType() {
            return this.authenType;
        }

        public String getUser() {
            return this.userid;
        }

        public String getBasicAuthUserID() {
            return this.basicAuthUserID;
        }

        public String getBasicAuthPassword() {
            return this.basicAuthPasswd;
        }

        public String getCertAlias() {
            return this.certalias;
        }

        public String getVersion() {
            return this.prefVersion;
        }

        public PartnerAccountMapper getPartnerAccountMapper() {
            return this.partnerAcctMapper;
        }

        public SiteAttributeMapper getSiteAttributeMapper() {
            SAMLUtilsCommon.debug.message("getSiteAttributeMapper() called");
            if (this._siteAttributeMapper == null) {
                SAMLUtilsCommon.debug.message("siteMapper is null");
            }
            return this._siteAttributeMapper;
        }

        public PartnerSiteAttributeMapper getPartnerSiteAttributeMapper() {
            SAMLUtilsCommon.debug.message("getPartnerSiteAttrMapper() called");
            if (localFlag && this._partnerSiteAttributeMapper == null) {
                SAMLUtilsCommon.debug.message("partnerSiteMapper is null");
            }
            return this._partnerSiteAttributeMapper;
        }

        public NameIdentifierMapper getNameIdentifierMapper() {
            return this.nameIdentifierMapper;
        }

        public AttributeMapper getAttributeMapper() {
            return this.attributeMapper;
        }

        public ActionMapper getActionMapper() {
            return this.actionMapper;
        }

        public String getIssuer() {
            return this._issuer;
        }

        public Set getHostSet() {
            if (this.origHostSet != null) {
                HashSet<String> newSet = new HashSet<String>();
                Iterator iter = this.origHostSet.iterator();
                while (iter.hasNext()) {
                    String name;
                    block5: {
                        InetAddress[] addrs = null;
                        name = (String)iter.next();
                        try {
                            addrs = InetAddress.getAllByName(name);
                            int length = addrs.length;
                            for (int m = 0; m < length; ++m) {
                                newSet.add(addrs[m].getHostAddress());
                            }
                        }
                        catch (Exception ne) {
                            if (!SAMLUtilsCommon.debug.warningEnabled()) break block5;
                            SAMLUtilsCommon.debug.warning("SAMLServiceManager: getHostSet: possible wrong hostname in the host list.");
                        }
                    }
                    newSet.add(name);
                }
                return newSet;
            }
            return this.origHostSet;
        }
    }

    public static class SiteEntry {
        private String hostname = null;
        private int portnumber = -1;
        private String sid = null;
        private String saml = null;
        private String post = null;
        private String prefVersion = null;

        public SiteEntry(String host, int port, String sourceid, String samlUrl, String postUrl, String version) {
            this.hostname = host;
            this.portnumber = port;
            this.sid = sourceid;
            this.saml = samlUrl;
            this.post = postUrl;
            this.prefVersion = version;
        }

        public String getSAMLUrl() {
            return this.saml;
        }

        public String getPOSTUrl() {
            return this.post;
        }

        public String getHostName() {
            return this.hostname;
        }

        public int getPort() {
            return this.portnumber;
        }

        public String getSourceID() {
            return this.sid;
        }

        public String getVersion() {
            return this.prefVersion;
        }
    }
}

