/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.impl.EncryptedElementImpl;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.xmlenc.EncManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedAssertionImpl
extends EncryptedElementImpl
implements EncryptedAssertion {
    public final String elementName = "EncryptedAssertion";

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("EncryptedAssertionImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("EncryptedAssertion")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("EncryptedAssertionImpl.parseElement: not EncryptedAssertion.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
    }

    public EncryptedAssertionImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        this.xmlString = XMLUtils.print((Node)element);
    }

    public EncryptedAssertionImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
        this.xmlString = xmlString;
    }

    public Assertion decrypt(Key recipientPrivateKey) throws SAML2Exception {
        Element el = EncManager.getEncInstance().decrypt(this.xmlString, recipientPrivateKey);
        return AssertionFactory.getInstance().createAssertion(el);
    }
}

