/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.profile.IDPSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IDPSessionCopy
implements Serializable {
    private String ssoTokenID = null;
    private List nameIDandSPpairs = null;
    private String pendingLogoutRequestID = null;
    private String originatingLogoutRequestID = null;
    private String originatingLogoutSPEntityID = null;
    private boolean doLogoutAll = false;

    public IDPSessionCopy(String ssoToken) {
        this.ssoTokenID = ssoToken;
        this.nameIDandSPpairs = new ArrayList();
    }

    public IDPSessionCopy(IDPSession idpSession) {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            SAML2Utils.debug.error("Error retrieving session provider.", (Throwable)((Object)se));
        }
        this.ssoTokenID = sessionProvider.getSessionID(idpSession.getSession());
        this.nameIDandSPpairs = new ArrayList();
        this.nameIDandSPpairs.addAll(idpSession.getNameIDandSPpairs());
        this.pendingLogoutRequestID = idpSession.getPendingLogoutRequestID();
        this.originatingLogoutRequestID = idpSession.getOriginatingLogoutRequestID();
        this.originatingLogoutSPEntityID = idpSession.getOriginatingLogoutSPEntityID();
        this.doLogoutAll = idpSession.getLogoutAll();
    }

    public String getSSOToken() {
        return this.ssoTokenID;
    }

    public List getNameIDandSPpairs() {
        return this.nameIDandSPpairs;
    }

    public void setPendingLogoutRequestID(String id) {
        this.pendingLogoutRequestID = id;
    }

    public String getPendingLogoutRequestID() {
        return this.pendingLogoutRequestID;
    }

    public void setOriginatingLogoutRequestID(String id) {
        this.originatingLogoutRequestID = id;
    }

    public String getOriginatingLogoutRequestID() {
        return this.originatingLogoutRequestID;
    }

    public void setOriginatingLogoutSPEntityID(String id) {
        this.originatingLogoutSPEntityID = id;
    }

    public String getOriginatingLogoutSPEntityID() {
        return this.originatingLogoutSPEntityID;
    }

    public void setLogoutAll(boolean enable) {
        this.doLogoutAll = enable;
    }

    public boolean getLogoutAll() {
        return this.doLogoutAll;
    }
}

