/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.StatusResponseImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogoutResponseImpl
extends StatusResponseImpl
implements LogoutResponse {
    public LogoutResponseImpl() {
        this.isMutable = true;
    }

    public LogoutResponseImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
    }

    public LogoutResponseImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        this.validateData();
        StringBuffer xmlString = new StringBuffer(1000);
        xmlString.append("<");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append("LogoutResponse").append(" ");
        xmlString.append(super.toXMLString(includeNSPrefix, declareNS));
        xmlString.append("\n").append("</samlp:").append("LogoutResponse").append(">");
        return xmlString.toString();
    }

    public void makeImmutable() {
        super.makeImmutable();
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        ProtocolFactory protoFactory = ProtocolFactory.getInstance();
        this.responseId = element.getAttribute("ID");
        this.validateID(this.responseId);
        this.version = element.getAttribute("Version");
        this.validateVersion(this.version);
        String issueInstantStr = element.getAttribute("IssueInstant");
        this.validateIssueInstant(issueInstantStr);
        this.destination = element.getAttribute("Destination");
        this.consent = element.getAttribute("Consent");
        this.inResponseTo = element.getAttribute("InResponseTo");
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("Issuer")) {
                    this.issuer = assertionFactory.createIssuer((Element)childNode);
                    continue;
                }
                if (cName.equals("Signature")) {
                    this.signatureString = XMLUtils.getElementString((Element)((Element)childNode));
                    this.isSigned = true;
                    continue;
                }
                if (cName.equals("Extensions")) {
                    this.extensions = protoFactory.createExtensions((Element)childNode);
                    continue;
                }
                if (!cName.equals("Status")) continue;
                this.status = protoFactory.createStatus((Element)childNode);
                this.validateStatus();
            }
        }
    }
}

