/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.wsfederation.common.WSFederationConstants;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.plugins.DefaultAccountMapper;
import com.sun.identity.wsfederation.plugins.IDPAccountMapper;

public class DefaultIDPAccountMapper
extends DefaultAccountMapper
implements IDPAccountMapper {
    public DefaultIDPAccountMapper() {
        debug.message("DefaultIDPAccountMapper.constructor");
        this.role = "IDPRole";
    }

    public NameIdentifier getNameID(Object session, String realm, String hostEntityID, String remoteEntityID) throws WSFederationException {
        String userID = null;
        try {
            SessionProvider sessionProv = SessionManager.getProvider();
            String[] values = sessionProv.getProperty(session, "UserId");
            if (values != null && values.length > 0) {
                userID = values[0];
            }
        }
        catch (SessionException se) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidSSOToken"));
        }
        NameIdentifier nameID = null;
        try {
            IDPSSOConfigElement idpConfig = WSFederationMetaManager.getIDPSSOConfig(realm, hostEntityID);
            String upn = userID + "@" + WSFederationMetaUtils.getAttribute(idpConfig, "upnDomain");
            nameID = new NameIdentifier(upn, null, WSFederationConstants.NAMED_CLAIM_TYPES[0]);
        }
        catch (SAMLException se) {
            throw new WSFederationException((Throwable)((Object)se));
        }
        return nameID;
    }
}

