/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.plugins.DefaultAttributeMapper;
import com.sun.identity.wsfederation.plugins.IDPAttributeMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultIDPAttributeMapper
extends DefaultAttributeMapper
implements IDPAttributeMapper {
    public DefaultIDPAttributeMapper() {
        debug.message("DefaultIDPAttributeMapper.Constructor");
        this.role = "IDP";
    }

    public List getAttributes(Object session, String hostEntityID, String remoteEntityID, String realm) throws WSFederationException {
        if (hostEntityID == null) {
            throw new WSFederationException(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new WSFederationException(bundle.getString("nullRealm"));
        }
        if (session == null) {
            throw new WSFederationException(bundle.getString("nullSSOToken"));
        }
        try {
            Map valueMap;
            ArrayList<Attribute> attributes;
            Map configMap;
            block19: {
                if (!SessionManager.getProvider().isValid(session)) {
                    if (debug.warningEnabled()) {
                        debug.warning("DefaultIDPAttributeMapper.getAttributes: Invalid session");
                    }
                    return null;
                }
                configMap = this.getConfigAttributeMap(realm, hostEntityID);
                if (configMap == null || configMap.isEmpty()) {
                    if (debug.messageEnabled()) {
                        debug.message("DefaultIDPAttributeMapper.getAttributes:Configuration map is not defined.");
                    }
                    return null;
                }
                attributes = new ArrayList<Attribute>();
                HashSet localAttributes = new HashSet();
                localAttributes.addAll(configMap.values());
                valueMap = null;
                try {
                    valueMap = dsProvider.getAttributes(SessionManager.getProvider().getPrincipalName(session), localAttributes);
                }
                catch (DataStoreProviderException dse) {
                    if (!debug.warningEnabled()) break block19;
                    debug.warning("DefaultIDPAttributeMapper.getAttributes: Datastore exception", (Throwable)((Object)dse));
                }
            }
            for (String samlAttribute : configMap.keySet()) {
                String localAttribute = (String)configMap.get(samlAttribute);
                String[] localAttributeValues = null;
                if (valueMap != null && !valueMap.isEmpty()) {
                    Set values = (Set)valueMap.get(localAttribute);
                    if (values == null || values.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("DefaultIDPAttributeMapper.getAttribute: user profile does not have value for " + localAttribute + " but is going to check ssotoken:");
                        }
                        if ((localAttributeValues = SessionManager.getProvider().getProperty(session, localAttribute)) != null && localAttributeValues.length == 0) {
                            localAttributeValues = null;
                        }
                    } else {
                        localAttributeValues = values.toArray(new String[values.size()]);
                    }
                }
                if (localAttributeValues == null) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DefaultIDPAttributeMapper.getAttribute: user does not have " + localAttribute);
                    continue;
                }
                attributes.add(this.getSAMLAttribute(samlAttribute, localAttributeValues));
            }
            return attributes;
        }
        catch (WSFederationException sme) {
            debug.error("DefaultIDPAttribute.getAttributes: SAML Exception", (Throwable)((Object)sme));
            throw new WSFederationException((Throwable)((Object)sme));
        }
        catch (SessionException se) {
            debug.error("DefaultIDPAttribute.getAttributes: SessionException", (Throwable)((Object)se));
            throw new WSFederationException((Throwable)((Object)se));
        }
    }

    protected Attribute getSAMLAttribute(String name, String[] values) throws WSFederationException {
        String namespace = "";
        if (name == null) {
            throw new WSFederationException(bundle.getString("nullInput"));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                list.add(XMLUtils.escapeSpecialCharacters((String)values[i]));
            }
        }
        Attribute attribute = null;
        try {
            attribute = new Attribute(name, namespace, list);
        }
        catch (SAMLException se) {
            throw new WSFederationException((Throwable)((Object)se));
        }
        return attribute;
    }
}

