/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.common;

import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Decision;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class XACMLSDKUtils
extends SAML2SDKUtils {
    public static Debug debug = Debug.getInstance((String)"libXACML");
    public static final String XACML_RESOURCE_BUNDLE_NAME = "libXACML";
    public static ResourceBundle xacmlResourceBundle = Locale.getInstallResourceBundle((String)"libXACML");
    private static Map classMapping = new HashMap();
    private static String[] interfaceNames = new String[]{XACMLConstants.REQUEST, XACMLConstants.SUBJECT, XACMLConstants.RESOURCE, XACMLConstants.ACTION, XACMLConstants.ATTRIBUTE, XACMLConstants.ATTRIBUTE_VALUE, XACMLConstants.RESOURCE_CONTENT, XACMLConstants.XACML_AUTHZ_DECISION_QUERY};

    protected XACMLSDKUtils() {
    }

    public static Attribute createAttribute(List values, URI attributeId, URI dataType, String issuer) throws XACMLException {
        ContextFactory factory = ContextFactory.getInstance();
        Attribute attr = null;
        attr = factory.getInstance().createAttribute();
        attr.setAttributeId(attributeId);
        attr.setDataType(dataType);
        attr.setAttributeValues(values);
        attr.setIssuer(issuer);
        return attr;
    }

    public static boolean isValidDecision(Decision decision) {
        boolean valid = false;
        if (decision != null) {
            String value = decision.getValue();
            valid = XACMLSDKUtils.isValidDecision(value);
        }
        return valid;
    }

    public static boolean isValidDecision(String value) {
        boolean valid = false;
        if (value != null && (value.equals("Permit") || value.equals("Deny") || value.equals("Indeterminate") || value.equals("NotApplicable"))) {
            valid = true;
        }
        return valid;
    }

    public static boolean isValidStatusMessage(String value) {
        boolean valid = true;
        return valid;
    }

    public static boolean isValidStatusCode(String value) {
        boolean valid = true;
        return valid;
    }

    public static boolean isValidMinorStatusCode(String value) {
        boolean valid = true;
        return valid;
    }

    public static String quote(String s) {
        String val = null;
        val = s == null ? "\"\"" : "\"" + s + "\"";
        return val;
    }

    static {
        int len = interfaceNames.length;
        for (int i = 0; i < len; ++i) {
            String iName = interfaceNames[i];
            try {
                String implClass = SystemPropertiesManager.get((String)(XACMLConstants.SDK_CLASS_MAPPING + iName));
                if (implClass == null || implClass.trim().length() == 0) continue;
                if (debug.messageEnabled()) {
                    debug.message("XACMLSDKUtils.init: mapper for " + iName + "=" + implClass);
                }
                classMapping.put(iName, Class.forName(implClass.trim()));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                debug.error("XACMLSDKUtils.init: " + iName, (Throwable)cnfe);
            }
        }
    }
}

