/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence.persistent;

import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rm.runtime.sequence.persistent.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSequenceData
implements SequenceData {
    private final String sequenceId;
    private final long expirationTime;
    private final Connection sqlConnection;
    private final ResultSet sequenceData;

    public PersistentSequenceData(Connection connection, String sequenceId, long expirationTime, long lastMessageId, Sequence.Status status, boolean ackRequestedFlag) throws PersistenceException {
        this.sequenceId = sequenceId;
        this.expirationTime = expirationTime;
        this.sqlConnection = connection;
        try {
            PreparedStatement insertPS = this.sqlConnection.prepareStatement("INSERT INTO RM_SEQUENCES VALUES (?, ?, ?, ?, ?)");
            insertPS.setString(1, sequenceId);
            insertPS.setLong(2, expirationTime);
            insertPS.setInt(3, status.ordinal());
            insertPS.setBoolean(4, ackRequestedFlag);
            insertPS.setLong(5, lastMessageId);
            if (insertPS.executeUpdate() != 1) {
                throw new PersistenceException("Sequence data not inserted into database.");
            }
            PreparedStatement queryPS = this.sqlConnection.prepareStatement("SELECT * FROM RM_SEQUENCES WHERE sequence_id = ?");
            queryPS.setString(1, sequenceId);
            this.sequenceData = queryPS.executeQuery();
            if (!this.sequenceData.first()) {
                throw new PersistenceException("Unable to get the sequence data");
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException("Error creating the new sequence data record.", ex);
        }
    }

    @Override
    public boolean isAckRequestedFlag() {
        try {
            return this.sequenceData.getBoolean("ack_requested_flag");
        }
        catch (SQLException ex) {
            return false;
        }
    }

    @Override
    public void setAckRequestedFlag(boolean ackRequestedFlag) {
        try {
            this.sequenceData.updateBoolean("ack_requested_flag", ackRequestedFlag);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Sequence.Status getStatus() {
        try {
            return Sequence.Status.ordinalToStatus(this.sequenceData.getInt("status"));
        }
        catch (SQLException ex) {
            return null;
        }
    }

    @Override
    public void setStatus(Sequence.Status status) {
        try {
            this.sequenceData.updateInt("status", status.ordinal());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public long getLastMessageId() {
        try {
            return this.sequenceData.getLong("last_message_id");
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    @Override
    public long updateLastMessageId(long newId) {
        try {
            long retVal = this.getLastMessageId();
            this.sequenceData.updateLong("last_message_id", newId);
            return retVal;
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    @Override
    public long incrementAndGetLastMessageId() {
        try {
            long retVal = this.getLastMessageId() + 1L;
            this.sequenceData.updateLong("last_message_id", retVal);
            return retVal;
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    @Override
    public Collection<Long> getAllUnackedIndexes() {
        return null;
    }

    @Override
    public boolean noUnackedMessageIds() {
        return false;
    }

    @Override
    public void addUnackedMessageId(long messageId) {
    }

    @Override
    public boolean removeUnackedMessageId(long messageId) {
        return false;
    }

    @Override
    public void acquireMessageIdDataReadOnlyLock() {
    }

    @Override
    public void releaseMessageIdDataReadOnlyLock() {
    }

    @Override
    public void acquireMessageIdDataReadWriteLock() {
    }

    @Override
    public void releaseMessageIdDataReadWriteLock() {
    }
}

