/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.util;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import com.sun.xml.wss.saml.util.WSSNamespacePrefixMapper;
import com.sun.xml.wss.util.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLUtil {
    private static Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security.saml", "com.sun.xml.wss.logging.saml.LogStrings");

    public static Element locateSamlAssertion(String assertionId, Document soapDocument) throws XWSSecurityException {
        int nodeListLength;
        NodeList nodeList = null;
        nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        if (nodeList.item(0) == null) {
            nodeList = soapDocument.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        }
        if ((nodeListLength = nodeList.getLength()) == 0) {
            logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
        }
        for (int i = 0; i < nodeListLength; ++i) {
            Element assertion = (Element)nodeList.item(i);
            String aId = assertion.getAttribute("AssertionID");
            String id = assertion.getAttribute("ID");
            if (!aId.equals(assertionId) && !id.equals(assertionId)) continue;
            return assertion;
        }
        logger.log(Level.SEVERE, "WSS001.SAML_ASSERTION_NOT_FOUND", new Object[]{assertionId});
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, "Referenced Security Token could not be retrieved", null);
    }

    public static Element toElement(Node doc, Object element) throws XWSSecurityException {
        Element el;
        DOMResult result = null;
        Document document = null;
        if (doc != null) {
            result = new DOMResult(doc);
        } else {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WSS002.failed.create.document", ex);
                throw new XWSSecurityException("Unable to create Document : " + ex.getMessage());
            }
            result = new DOMResult(document);
        }
        try {
            JAXBContext jc = null;
            jc = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? (element instanceof Assertion ? SAML20JAXBUtil.getJAXBContext() : SAMLJAXBUtil.getJAXBContext()) : SAMLJAXBUtil.getJAXBContext();
            Marshaller m = jc.createMarshaller();
            if (element == null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Element is Null in SAMLUtil.toElement()");
            }
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new WSSNamespacePrefixMapper());
            m.marshal(element, (Result)result);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WSS003.failedto.marshal", ex);
            throw new XWSSecurityException("Not able to Marshal " + element.getClass().getName() + ", got exception: " + ex.getMessage());
        }
        if (doc != null) {
            if (doc.getNodeType() == 1) {
                if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                    el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                    return el;
                }
                el = (Element)((Element)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
                return el;
            }
            if (doc.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
                return el;
            }
            el = (Element)((Document)doc).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
            return el;
        }
        if (document.getFirstChild().getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
            return el;
        }
        el = (Element)document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion").item(0);
        return el;
    }

    public static Element createSAMLAssertion(XMLStreamReader reader) throws XWSSecurityException, XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        StreamWriterBufferCreator bCreator = new StreamWriterBufferCreator(buffer);
        Document doc = null;
        try {
            XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
            StreamWriterBufferCreator writer_tmp = bCreator;
            while (8 != reader.getEventType()) {
                StreamUtil.writeCurrentEvent(reader, (XMLStreamWriter)writer_tmp);
                reader.next();
            }
            buffer.writeToXMLStreamWriter(writer);
            writer.close();
            try {
                baos.close();
            }
            catch (IOException ex) {
                throw new XWSSecurityException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", ex);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new ByteArrayInputStream(baos.toByteArray()));
            return doc.getDocumentElement();
        }
        catch (XMLStreamException xe) {
            throw new XMLStreamException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", xe);
        }
        catch (Exception xe) {
            throw new XWSSecurityException("Error occurred while trying to convert SAMLAssertion stream into DOM Element", xe);
        }
    }

    public static boolean validateTimeInConditionsStatement(Element samlAssertion) throws XWSSecurityException {
        Date _notBefore = null;
        Date _notOnOrAfter = null;
        NodeList nl = samlAssertion.getElementsByTagNameNS(samlAssertion.getNamespaceURI(), "Conditions");
        Node conditionsElement = null;
        if (nl == null || nl.getLength() <= 0) {
            logger.log(Level.INFO, "No Conditions Element found in SAML Assertion");
            return true;
        }
        conditionsElement = nl.item(0);
        Element elt = (Element)conditionsElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            throw new XWSSecurityException("Internal Error: LocalName of Conditions Element found Null");
        }
        if (!eltName.equals("Conditions")) {
            throw new XWSSecurityException("Internal Error: LocalName of Conditions Element found to be :" + eltName);
        }
        String dt = elt.getAttribute("NotBefore");
        if (dt != null && !dt.equals("")) {
            try {
                _notBefore = DateUtils.stringToDate(dt);
            }
            catch (ParseException pe) {
                throw new XWSSecurityException(pe);
            }
        }
        if ((dt = elt.getAttribute("NotOnOrAfter")) != null && !dt.equals("")) {
            try {
                _notOnOrAfter = DateUtils.stringToDate(elt.getAttribute("NotOnOrAfter"));
            }
            catch (ParseException pe) {
                throw new XWSSecurityException(pe);
            }
        }
        long someTime = System.currentTimeMillis();
        if (_notBefore == null) {
            if (_notOnOrAfter == null) {
                return true;
            }
            if (someTime < _notOnOrAfter.getTime()) {
                return true;
            }
        } else if (_notOnOrAfter == null ? someTime >= _notBefore.getTime() : someTime >= _notBefore.getTime() && someTime < _notOnOrAfter.getTime()) {
            return true;
        }
        return false;
    }
}

