/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.mechanism;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class PlainMechanismHandler
implements MechanismHandler {
    public static Debug debug = Debug.getInstance((String)"fmAuthnSvc");

    public SASLResponse processSASLRequest(SASLRequest saslReq, Message message, String respMessageID) {
        String refToMessageID;
        boolean isFirstRequest;
        if (debug.messageEnabled()) {
            debug.message("PlainMechanismHandler.processSASLRequest: ");
        }
        boolean bl = isFirstRequest = (refToMessageID = saslReq.getRefToMessageID()) == null || refToMessageID.length() == 0;
        if (debug.messageEnabled()) {
            debug.message("PlainMechanismHandler.processSASLRequest: refToMessageID = " + refToMessageID);
        }
        SASLResponse saslResp = null;
        byte[] data = saslReq.getData();
        if (data == null) {
            if (isFirstRequest) {
                saslResp = new SASLResponse("continue");
                saslResp.setServerMechanism("PLAIN");
            } else {
                saslResp = new SASLResponse("abort");
            }
        } else {
            String dataStr = null;
            try {
                dataStr = new String(data, "UTF-8");
            }
            catch (Exception ex) {
                debug.error("PlainMechanismHandler.processSASLRequest: ", (Throwable)ex);
            }
            saslResp = dataStr == null ? new SASLResponse("abort") : this.authenticate(dataStr, message);
            if (isFirstRequest) {
                saslResp.setServerMechanism("PLAIN");
            }
        }
        return saslResp;
    }

    private SASLResponse authenticate(String data, Message message) {
        Callback[] callbacks;
        int indexNul = data.indexOf(0);
        if (indexNul == -1) {
            return new SASLResponse("abort");
        }
        int indexNul2 = data.indexOf(0, indexNul + 1);
        if (indexNul2 == -1) {
            return new SASLResponse("abort");
        }
        String authzID = data.substring(0, indexNul);
        String authnID = data.substring(indexNul + 1, indexNul2);
        String password = data.substring(indexNul2 + 1);
        if (authnID == null) {
            return new SASLResponse("abort");
        }
        if (debug.messageEnabled()) {
            debug.message("PlainMechanismHandler.authenticate: authzID = " + authzID + ", authnID = " + authnID);
        }
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(SMSEntry.getRootSuffix());
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "DataStore");
        }
        catch (AuthLoginException le) {
            debug.error("PlainMechanismHandler.authenticate: ", (Throwable)le);
            return new SASLResponse("abort");
        }
        if (authContext.hasMoreRequirements() && (callbacks = authContext.getRequirements()) != null) {
            PlainMechanismHandler.fillInCallbacks(callbacks, authnID, password);
            authContext.submitRequirements(callbacks);
        }
        AuthContext.Status loginStatus = authContext.getStatus();
        if (debug.messageEnabled()) {
            debug.message("PlainMechanismHandler.authenticate: login status = " + loginStatus);
        }
        if (loginStatus != AuthContext.Status.SUCCESS) {
            return new SASLResponse("abort");
        }
        try {
            SASLResponse saslResp;
            String userDN;
            block14: {
                SSOToken token = authContext.getSSOToken();
                userDN = token.getPrincipal().getName();
                saslResp = new SASLResponse("OK");
                try {
                    SSOTokenManager.getInstance().destroyToken(token);
                }
                catch (SSOException ssoex) {
                    if (!AuthnSvcUtils.debug.warningEnabled()) break block14;
                    AuthnSvcUtils.debug.warning("PlainMechanismHandler.authenticate:", (Throwable)ssoex);
                }
            }
            if (!AuthnSvcUtils.setResourceOfferingAndCredentials((SASLResponse)saslResp, (Message)message, (String)userDN)) {
                return new SASLResponse("abort");
            }
            return saslResp;
        }
        catch (Exception ex) {
            debug.error("PlainMechanismHandler.authenticate: ", (Throwable)ex);
            return new SASLResponse("abort");
        }
    }

    private static void fillInCallbacks(Callback[] callbacks, String username, String password) {
        if (debug.messageEnabled()) {
            debug.message("PlainMechanismHandler.fillInCallbacks:");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(username);
                continue;
            }
            if (!(callback instanceof PasswordCallback)) continue;
            ((PasswordCallback)callback).setPassword(password.toCharArray());
        }
    }
}

