/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ClientConfiguratorFilter
implements Filter {
    private FilterConfig config;
    private ServletContext servletCtx;
    public static boolean isConfigured = false;
    private static final String SETUP_URI = "/Configurator.jsp";
    private static final String configFile = System.getProperty("user.home") + File.separator + "AMConfig.properties";
    private boolean passThrough = false;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            if (httpRequest.getRequestURI().endsWith(SETUP_URI)) {
                this.passThrough = true;
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else if (this.passThrough) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else if (!isConfigured) {
                String url = httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + httpRequest.getContextPath() + SETUP_URI;
                httpResponse.sendRedirect(url);
                this.passThrough = true;
            } else {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        catch (Exception ex) {
            throw new ServletException("ClientConfiguratorFilter.doFilter", (Throwable)ex);
        }
    }

    public void destroy() {
        this.config = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
        this.servletCtx = filterConfig.getServletContext();
        File file = new File(configFile);
        if (file.exists()) {
            this.setAMConfigProperties(configFile);
        }
    }

    public void setFilterConfig(FilterConfig fconfig) {
        this.config = fconfig;
    }

    private void setAMConfigProperties(String configFile) throws ServletException {
        block12: {
            FileInputStream fileStr = null;
            try {
                fileStr = new FileInputStream(configFile);
                if (fileStr != null) {
                    Properties props = new Properties();
                    props.load(fileStr);
                    SystemProperties.initializeProperties((Properties)props);
                    isConfigured = true;
                    break block12;
                }
                throw new ServletException("Unable to open: " + configFile);
            }
            catch (FileNotFoundException fexp) {
                fexp.printStackTrace();
                throw new ServletException(fexp.getMessage());
            }
            catch (IOException ioexp) {
                ioexp.printStackTrace();
                throw new ServletException(ioexp.getMessage());
            }
            finally {
                if (fileStr != null) {
                    try {
                        fileStr.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

