/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.WorkflowException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;

public class ExportSAML2MetaData {
    private ExportSAML2MetaData() {
    }

    public static String exportStandardMeta(String realm, String entityID) throws WorkflowException {
        String result = null;
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(realm, entityID);
            if (descriptor != null) {
                String xmlstr = SAML2MetaUtils.convertJAXBToString((Object)descriptor);
                xmlstr = ExportSAML2MetaData.workaroundAbstractRoleDescriptor(xmlstr);
                result = SAML2MetaSecurityUtils.formatBase64BinaryElement((String)xmlstr);
            }
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
        catch (JAXBException e) {
            throw new WorkflowException(e.getMessage());
        }
        return result;
    }

    public static String exportExtendedMeta(String realm, String entityID) throws WorkflowException {
        try {
            String result = null;
            SAML2MetaManager metaManager = new SAML2MetaManager();
            EntityConfigElement config = metaManager.getEntityConfig(realm, entityID);
            if (config != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                SAML2MetaUtils.convertJAXBToOutputStream((Object)config, (OutputStream)os);
                result = ((Object)os).toString();
            }
            return result;
        }
        catch (JAXBException e) {
            throw new WorkflowException(e.getMessage());
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
    }

    private static String workaroundAbstractRoleDescriptor(String xmlstr) {
        int index = xmlstr.indexOf(":AttributeQueryDescriptor");
        if (index == -1) {
            return xmlstr;
        }
        int index2 = xmlstr.lastIndexOf("<", index);
        if (index2 == -1) {
            return xmlstr;
        }
        String prefix = xmlstr.substring(index2 + 1, index);
        String type = prefix + ":" + "AttributeQueryDescriptorType";
        xmlstr = xmlstr.replaceAll("<" + prefix + ":" + "AttributeQueryDescriptor", "<RoleDescriptor xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"" + type + "\"");
        xmlstr = xmlstr.replaceAll("</" + prefix + ":" + "AttributeQueryDescriptor", "</RoleDescriptor");
        return xmlstr;
    }
}

