/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.SAML2TokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.WSSUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SAML2Token
implements SecurityToken {
    private String authType = "";
    private String authTime = "";
    private Assertion assertion;
    private String certAlias = "";
    private static final String KEY_INFO_TYPE = "com.sun.identity.liberty.ws.security.keyinfotype";
    private static String keyInfoType = SystemConfigurationUtil.getProperty((String)"com.sun.identity.liberty.ws.security.keyinfotype");
    private static AssertionFactory factory = AssertionFactory.getInstance();

    public SAML2Token(SAML2TokenSpec spec, SSOToken ssoToken) throws SecurityException {
        if (spec == null) {
            WSSUtils.debug.error("SAML2Token: constructor: SAML2 Token specification is null");
            throw new SecurityException(WSSUtils.bundle.getString("tokenSpecNotSpecified"));
        }
        this.validateSSOToken(ssoToken);
        this.createAssertion(spec);
    }

    public SAML2Token(Element element) throws SAML2Exception {
        this.assertion = factory.createAssertion(element);
    }

    private void validateSSOToken(SSOToken ssoToken) throws SecurityException {
        try {
            SSOTokenManager.getInstance().validateToken(ssoToken);
            this.authType = ssoToken.getAuthType();
            this.authTime = ssoToken.getProperty("authInstant");
        }
        catch (SSOException se) {
            WSSUtils.debug.error("AssertionToken.validateSSOToken: SSOException", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("invalidSSOToken"));
        }
    }

    public String getTokenType() {
        return "urn:sun:wss:saml2token";
    }

    private void createAssertion(SAML2TokenSpec spec) throws SecurityException {
        this.assertion = factory.createAssertion();
        SecurityMechanism securityMechanism = spec.getSecurityMechanism();
        NameID nameIdentifier = spec.getSenderIdentity();
        this.certAlias = spec.getSubjectCertAlias();
        if (nameIdentifier == null || securityMechanism == null || this.certAlias == null) {
            throw new SecurityException(WSSUtils.bundle.getString("invalidSAML2TokenSpec"));
        }
        String confirmationMethod = this.getConfirmationMethod(securityMechanism.getURI());
        try {
            this.assertion.setVersion("2.0");
            this.assertion.setID(SAML2SDKUtils.generateID());
            Issuer issuer = factory.createIssuer();
            issuer.setValue(SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host"));
            this.assertion.setIssuer(issuer);
            Date issueInstant = new Date();
            this.assertion.setIssueInstant(issueInstant);
            this.assertion.setSubject(this.createSubject(nameIdentifier, confirmationMethod));
            ArrayList<AuthnStatement> authnStatements = new ArrayList<AuthnStatement>();
            authnStatements.add(this.createAuthnStatement());
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SAML2Token.createAssertion: Assertion constructs:\nConfirmation method: " + confirmationMethod + "\n" + "Issuer: " + issuer + "\n");
            }
            this.assertion.setAuthnStatements(authnStatements);
        }
        catch (SAML2Exception se) {
            WSSUtils.debug.error("SAML2Token.createAssertion:", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("unableToGenerateAssertion"));
        }
    }

    private Subject createSubject(NameID nameIdentifier, String confirmationMethod) throws SecurityException {
        try {
            Subject subject = factory.createSubject();
            subject.setNameID(nameIdentifier);
            if (confirmationMethod == null) {
                throw new SecurityException(WSSUtils.bundle.getString("nullConfirmationMethod"));
            }
            SubjectConfirmation subConfirmation = factory.createSubjectConfirmation();
            SubjectConfirmationData confirmationData = factory.createSubjectConfirmationData();
            if (confirmationMethod.equals("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key")) {
                subConfirmation.setMethod(confirmationMethod);
                confirmationData.setContentType("saml:KeyInfoConfirmationDataType");
                confirmationData.getContent().add(this.createKeyInfo());
                subConfirmation.setSubjectConfirmationData(confirmationData);
            } else if (confirmationMethod.equals("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches")) {
                subConfirmation.setMethod(confirmationMethod);
            } else {
                throw new SecurityException(WSSUtils.bundle.getString("invalidConfirmationMethod"));
            }
            ArrayList<SubjectConfirmation> list = new ArrayList<SubjectConfirmation>();
            list.add(subConfirmation);
            subject.setSubjectConfirmation(list);
            return subject;
        }
        catch (SAML2Exception se) {
            WSSUtils.debug.error("AssertionToken.getAuthenticationStatement:Failed to generate the authentication statement.", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoGenerateAssertion"));
        }
    }

    private AuthnStatement createAuthnStatement() throws SecurityException {
        try {
            AuthnStatement authnStatement = factory.createAuthnStatement();
            authnStatement.setAuthnInstant(new Date());
            AuthnContext authnContext = factory.createAuthnContext();
            authnContext.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI");
            authnStatement.setAuthnContext(authnContext);
            return authnStatement;
        }
        catch (SAML2Exception se) {
            WSSUtils.debug.error("SAML2Token.createAuthnStatement: SAML2Exception ", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("unableToGenerateAssertion"));
        }
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    private String getConfirmationMethod(String securityURI) throws SecurityException {
        if (securityURI == null) {
            throw new SecurityException(WSSUtils.bundle.getString("nullSecurityMechanism"));
        }
        if (securityURI.equals("urn:sun:wss:security:null:SAML2Token-HK") || securityURI.equals("urn:sun:wss:security:TLS:SAML2Token-HK") || securityURI.equals("urn:sun:wss:security:ClientTLS:SAML2Token-HK")) {
            return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        }
        if (securityURI.equals("urn:sun:wss:security:null:SAML2Token-SV") || securityURI.equals("urn:sun:wss:security:TLS:SAML2Token-SV") || securityURI.equals("urn:sun:wss:security:ClientTLS:SAML2Token-SV")) {
            return "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        }
        throw new SecurityException(WSSUtils.bundle.getString("invalidConfirmationMethod"));
    }

    private Element createKeyInfo() throws SecurityException {
        X509Certificate cert = this.getX509Certificate();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        String keyNameTextString = null;
        String base64CertString = null;
        PublicKey pk = null;
        try {
            pk = cert.getPublicKey();
            keyNameTextString = cert.getSubjectDN().getName();
            base64CertString = Base64.encode((byte[])cert.getEncoded());
        }
        catch (Exception e) {
            WSSUtils.debug.error("SAML2Token.createKeyInfo: ", (Throwable)e);
            throw new SecurityException(e.getMessage());
        }
        Element keyInfo = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        keyInfo.setAttribute("xmlns", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoType != null && keyInfoType.equalsIgnoreCase("certificate")) {
            Element x509Data = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
            Element x509Certificate = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            Text certText = doc.createTextNode(base64CertString);
            x509Certificate.appendChild(certText);
            keyInfo.appendChild(x509Data).appendChild(x509Certificate);
        } else {
            Element keyName = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            Text keyNameText = doc.createTextNode(keyNameTextString);
            Element keyvalue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            if (pk.getAlgorithm().equals("DSA")) {
                DSAPublicKey dsakey = (DSAPublicKey)pk;
                DSAParams dsaParams = dsakey.getParams();
                BigInteger _p = dsaParams.getP();
                BigInteger _q = dsaParams.getQ();
                BigInteger _g = dsaParams.getG();
                BigInteger _y = dsakey.getY();
                Element DSAKeyValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
                Element p = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "P");
                Text value_p = doc.createTextNode(Base64.encode((byte[])_p.toByteArray()));
                p.appendChild(value_p);
                DSAKeyValue.appendChild(p);
                Element q = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Q");
                Text value_q = doc.createTextNode(Base64.encode((byte[])_q.toByteArray()));
                q.appendChild(value_q);
                DSAKeyValue.appendChild(q);
                Element g = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "G");
                Text value_g = doc.createTextNode(Base64.encode((byte[])_g.toByteArray()));
                g.appendChild(value_g);
                DSAKeyValue.appendChild(g);
                Element y = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Y");
                Text value_y = doc.createTextNode(Base64.encode((byte[])_y.toByteArray()));
                y.appendChild(value_y);
                DSAKeyValue.appendChild(y);
                keyvalue.appendChild(DSAKeyValue);
            } else {
                RSAPublicKey rsakey = (RSAPublicKey)pk;
                BigInteger exponent = rsakey.getPublicExponent();
                BigInteger modulus = rsakey.getModulus();
                Element RSAKeyValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue");
                Element modulusNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Modulus");
                Element exponentNode = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "Exponent");
                RSAKeyValue.appendChild(modulusNode);
                RSAKeyValue.appendChild(exponentNode);
                Text modulusValue = doc.createTextNode(Base64.encode((byte[])modulus.toByteArray()));
                modulusNode.appendChild(modulusValue);
                Text exponentValue = doc.createTextNode(Base64.encode((byte[])exponent.toByteArray()));
                exponentNode.appendChild(exponentValue);
                keyvalue.appendChild(RSAKeyValue);
            }
            keyInfo.appendChild(keyName).appendChild(keyNameText);
            keyInfo.appendChild(keyvalue);
        }
        return keyInfo;
    }

    public X509Certificate getX509Certificate() throws SecurityException {
        X509Certificate cert = AMTokenProvider.getKeyProvider().getX509Certificate(this.certAlias);
        if (cert == null) {
            WSSUtils.debug.error("SAML2Token.getX509Certificate: Could not get certificate for alias : " + this.certAlias);
            throw new SecurityException(WSSUtils.bundle.getString("noCertificate"));
        }
        return cert;
    }

    public Element toDocumentElement() throws SecurityException {
        Document document = null;
        try {
            document = XMLUtils.toDOMDocument((String)this.assertion.toXMLString(true, true), (Debug)WSSUtils.debug);
        }
        catch (SAML2Exception se) {
            WSSUtils.debug.error("SAML2Token.toDocumentElement: failed", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("cannotConvertToDocument"));
        }
        if (document == null) {
            throw new SecurityException(WSSUtils.bundle.getString("cannotConvertToDocument"));
        }
        return document.getDocumentElement();
    }

    public void sign(String alias) throws SecurityException {
        try {
            X509Certificate x509Cert = AMTokenProvider.getKeyProvider().getX509Certificate(this.certAlias);
            PrivateKey privateKey = AMTokenProvider.getKeyProvider().getPrivateKey(alias);
            this.assertion.sign(privateKey, x509Cert);
        }
        catch (SAML2Exception se) {
            WSSUtils.debug.error("AssertionToken.sign: exception", (Throwable)se);
            throw new SecurityException(WSSUtils.bundle.getString("unabletoSign"));
        }
    }

    public boolean isSenderVouches() {
        Subject subject = this.assertion.getSubject();
        List list = subject.getSubjectConfirmation();
        if (list == null || list.isEmpty()) {
            return false;
        }
        SubjectConfirmation subjConfirmation = (SubjectConfirmation)list.get(0);
        String confirmationMethod = subjConfirmation.getMethod();
        return "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(confirmationMethod);
    }
}

