/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.WSSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class STSUtils {
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String WSP_ENDPOINT = "WSPEndpoint";
    public static Debug debug = Debug.getInstance((String)"famSTS");

    public static Map getAgentAttributes(String endpoint, Set attrNames, String type) {
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add(type);
            kvPairMap.put(AGENT_TYPE_ATTR, set);
            set = new HashSet();
            set.add(endpoint);
            kvPairMap.put(WSP_ENDPOINT, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                Map attrs = results.getResultAttributes();
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                Map agentConfig = null;
                agentConfig = attrNames != null ? provider.getAttributes(attrNames) : provider.getAttributes();
                return agentConfig;
            }
            return new HashMap();
        }
        catch (Exception ex) {
            debug.error("STSUtils.getAgentAttributes: Exception", (Throwable)ex);
            return new HashMap();
        }
    }
}

