/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.spi;

import com.iplanet.security.x509.CertUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSClientUserToken;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.sts.config.FAMSTSConfiguration;
import com.sun.identity.wss.sts.spi.NameIdentifierMapper;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSAttributeProvider
implements STSAttributeProvider {
    private static final String FAM_TOKEN = "FAMToken";
    private static final String SAML_ATTRIBUTE_MAP = "SAMLAttributeMapping";
    private static final String NAMEID_MAPPER_CLASS = "NameIDMapper";
    private static final String ATTR_NAMESPACE = "AttributeNamespace";
    private static final String STS = "sts";
    private static final String MEMBERSHIPS = "Memberships";
    private static final String INCLUDE_MEMBERSHIPS = "includeMemberships";
    private static final String defaultNS = "http://example.com";
    private SSOToken ssoToken = null;

    public Map<QName, List<String>> getClaimedAttributes(Subject subject, String appliesTo, String tokenType, Claims claims) {
        Map<QName, List<String>> memberships;
        boolean includeMemberships;
        String subjectName = this.getSubjectNameFromCustomToken(subject);
        if (subjectName == null) {
            subjectName = this.getAuthenticatedSubject(subject);
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject is null from authenticated subject");
            }
        }
        if (subjectName == null) {
            Iterator<Object> iter;
            Object object;
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject is null from custom tokens");
            }
            if ((object = (iter = subject.getPublicCredentials().iterator()).next()) instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)object;
                subjectName = CertUtils.getSubjectName((X509Certificate)cert);
            }
        }
        if (subjectName == null) {
            Iterator<Principal> iterator;
            Set<Principal> principals;
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: subject from X509certificate is null Checking in subject principals");
            }
            if ((principals = subject.getPrincipals()) != null && (iterator = principals.iterator()).hasNext()) {
                String cnName = principals.iterator().next().getName();
                int pos = cnName.indexOf("=");
                subjectName = cnName.substring(pos + 1);
            }
        }
        if (subjectName == null) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getClaimed Subject could not found.");
            return null;
        }
        HashMap<QName, List<String>> attrs = new HashMap<QName, List<String>>();
        Map agentConfig = STSUtils.getAgentAttributes(appliesTo, null, "WSPAgent");
        if (agentConfig == null || agentConfig.isEmpty()) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getClaimed Agent configuration not defined for " + appliesTo);
            return attrs;
        }
        Set tmp = (Set)agentConfig.get(ATTR_NAMESPACE);
        String namespace = null;
        if (tmp != null && !tmp.isEmpty()) {
            namespace = (String)tmp.iterator().next();
        }
        if (namespace == null) {
            if (STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getClaimedAttributes: Namespace is not defined.");
            }
            namespace = defaultNS;
        }
        QName nameIdQName = new QName(namespace, "NameID");
        ArrayList<String> nameIdAttrs = new ArrayList<String>();
        nameIdAttrs.add(this.getUserPseduoName(subjectName, agentConfig));
        attrs.put(nameIdQName, nameIdAttrs);
        tmp = (Set)agentConfig.get(SAML_ATTRIBUTE_MAP);
        Map<QName, List<String>> samlAttributeMap = null;
        if (tmp != null && !tmp.isEmpty()) {
            samlAttributeMap = this.getSAMLAttributes(subjectName, tmp, namespace);
        }
        if (samlAttributeMap != null) {
            attrs.putAll(samlAttributeMap);
        }
        if ((includeMemberships = Boolean.valueOf(CollectionHelper.getMapAttr((Map)agentConfig, (String)INCLUDE_MEMBERSHIPS, (String)"false")).booleanValue()) && (memberships = this.getMemberships(subjectName, namespace)) != null && !memberships.isEmpty()) {
            attrs.putAll(memberships);
        }
        return attrs;
    }

    private String getUserPseduoName(String userName, Map agentConfig) {
        String nameIDImpl = CollectionHelper.getMapAttr((Map)agentConfig, (String)NAMEID_MAPPER_CLASS);
        if (nameIDImpl == null) {
            return userName;
        }
        try {
            Class<?> nameIDImplClass = Thread.currentThread().getContextClassLoader().loadClass(nameIDImpl);
            NameIdentifierMapper niMapper = (NameIdentifierMapper)nameIDImplClass.newInstance();
            return niMapper.getUserPsuedoName(userName);
        }
        catch (Exception ex) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getUserPseduoName:  Exception", (Throwable)ex);
            return userName;
        }
    }

    private Map<QName, List<String>> getSAMLAttributes(String subjectName, Set attributeMap, String namespace) {
        HashMap<QName, List<String>> map = new HashMap<QName, List<String>>();
        AMIdentity amId = null;
        try {
            amId = new AMIdentity(WSSUtils.getAdminToken(), subjectName);
            if (!amId.isExists() && STSUtils.debug.messageEnabled()) {
                STSUtils.debug.message("FAMSTSAttributeProvider.getSAMLAttributes: Subject " + subjectName + " does not exist");
            }
        }
        catch (Exception ex) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getSAMLAttributes: read subject error", (Throwable)ex);
            return null;
        }
        for (String attribute : attributeMap) {
            boolean attributeFoundInSSOToken;
            Set<String> values;
            String realAttribute;
            String samlAttribute;
            block12: {
                StringTokenizer st;
                if (attribute.indexOf("=") == -1 || (st = new StringTokenizer(attribute, "=")).countTokens() != 2) continue;
                samlAttribute = st.nextToken();
                realAttribute = st.nextToken();
                values = new HashSet();
                attributeFoundInSSOToken = false;
                if (this.ssoToken != null) {
                    try {
                        String attributeValue = this.ssoToken.getProperty(realAttribute);
                        if (attributeValue != null) {
                            values.add(attributeValue);
                            attributeFoundInSSOToken = true;
                        }
                    }
                    catch (SSOException se) {
                        if (!STSUtils.debug.messageEnabled()) break block12;
                        STSUtils.debug.message("FAMSTSAttributeProvider.getSAMLAttributes: SSOException", (Throwable)se);
                    }
                }
            }
            if (!attributeFoundInSSOToken) {
                try {
                    values = amId.getAttribute(realAttribute);
                }
                catch (Exception ex) {
                    STSUtils.debug.error("FAMSTSAttributeProvider.getSAMLAttributes: read attributes error", (Throwable)ex);
                }
            }
            if (values == null || values.isEmpty()) {
                if (!STSUtils.debug.messageEnabled()) continue;
                STSUtils.debug.message("FAMSTSAttributeProvider.getSAMLAttributes: attribute value not found for" + realAttribute);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(values);
            QName qName = new QName(namespace, samlAttribute);
            map.put(qName, list);
        }
        return map;
    }

    private String getSubjectNameFromCustomToken(Subject subject) {
        for (Object object : subject.getPublicCredentials()) {
            if (!(object instanceof Element)) continue;
            Element credential = (Element)object;
            if (credential.getLocalName().equals(FAM_TOKEN)) {
                try {
                    STSClientUserToken userToken = new STSClientUserToken(credential);
                    String tokenId = userToken.getTokenId();
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    SSOToken currentToken = manager.createSSOToken(tokenId);
                    if (manager.isValidToken(currentToken)) {
                        this.ssoToken = currentToken;
                    }
                    if (!userToken.getType().equals("FAMSSOToken")) continue;
                    return userToken.getPrincipalName();
                }
                catch (FAMSTSException fae) {
                    if (!STSUtils.debug.messageEnabled()) continue;
                    STSUtils.debug.message("FAMSTSAttributeProvider.getSubjectNameFromCustomToken: FAMException", (Throwable)fae);
                    continue;
                }
                catch (SSOException se) {
                    if (!STSUtils.debug.messageEnabled()) continue;
                    STSUtils.debug.message("FAMSTSAttributeProvider.getSubjectNameFromCustomToken: SSOException", (Throwable)se);
                    continue;
                }
            }
            FAMSTSConfiguration stsConfig = new FAMSTSConfiguration();
            String customToken = stsConfig.getClientUserTokenClass();
            if (customToken == null || customToken.length() == 0) continue;
            try {
                Class<?> customTokenClass = Thread.currentThread().getContextClassLoader().loadClass(customToken);
                ClientUserToken userToken = (ClientUserToken)customTokenClass.newInstance();
                return userToken.getPrincipalName();
            }
            catch (Exception ex) {
                STSUtils.debug.error("FAMSTSAttributeProvider.checkForCustomTokens: Exception", (Throwable)ex);
            }
        }
        return null;
    }

    private Map<QName, List<String>> getMemberships(String subjectName, String namespace) {
        HashMap<QName, List<String>> map = new HashMap<QName, List<String>>();
        List roles = WSSUtils.getMemberShips(subjectName);
        if (roles == null || roles.isEmpty()) {
            return map;
        }
        QName qName = new QName(namespace, MEMBERSHIPS);
        map.put(qName, roles);
        return map;
    }

    private String getAuthenticatedSubject(Subject subject) {
        final Subject sub = subject;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Set<Object> creds = sub.getPrivateCredentials();
                    if (creds != null && !creds.isEmpty()) {
                        for (Object cred : creds) {
                            if (!(cred instanceof SSOToken)) continue;
                            FAMSTSAttributeProvider.this.ssoToken = (SSOToken)cred;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getAuthenticatedSubject: Priveleged exception error", (Throwable)e);
            return null;
        }
        try {
            if (this.ssoToken != null) {
                return this.ssoToken.getPrincipal().getName();
            }
        }
        catch (SSOException se) {
            STSUtils.debug.error("FAMSTSAttributeProvider.getAuthenticatedSubject: SSOException", (Throwable)se);
        }
        return null;
    }
}

