/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.ApprovalCallback;
import com.iplanet.services.comm.https.JSSProxy;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLSocket;
import sun.misc.RegexpPool;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public final class HttpsClient
extends HttpClient
implements SSLClientCertificateSelectionCallback {
    private static Debug debug = Debug.getInstance("amJSS");
    private static String secureTunnelHost = null;
    private static int secureTunnelPort = 80;
    private static RegexpPool dontProxy = null;
    private static final int httpsPortNumber = 443;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSocket sslSocket = null;
    private String nickName = System.getProperty("com.sun.identity.security.keyStore.clientAlias", null);

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        String ourHost = HttpsClient.getProperty("https.proxyHost");
        if (debug.messageEnabled()) {
            debug.message("HttpsClient: proxyHost = " + ourHost);
        }
        if (ourHost == null || "".equals(ourHost)) {
            secureTunnelHost = null;
            secureTunnelPort = 80;
        } else {
            secureTunnelHost = ourHost;
            secureTunnelPort = Integer.getInteger("https.proxyPort", 80);
        }
        dontProxy = new RegexpPool();
        String rawList = HttpsClient.getProperty("http.nonProxyHosts");
        debug.message("HttpsClient: nonProxyHosts = " + rawList);
        if (rawList != null) {
            StringTokenizer st = new StringTokenizer(rawList, "|", false);
            try {
                while (st.hasMoreTokens()) {
                    dontProxy.add(st.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public HttpsClient(URL url) throws IOException {
        super(url, true);
        if (debug.messageEnabled()) {
            debug.message("HttpsClient: HttpsClient " + url);
        }
    }

    public static HttpClient New(URL url) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("HttpsClient: New " + url);
        }
        return new HttpsClient(url);
    }

    protected boolean isNonProxyHost() {
        if (dontProxy.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress addr = InetAddress.getByName(this.url.getHost());
            String host = addr.getHostAddress();
            if (dontProxy.match(host) != null) {
                return true;
            }
        }
        catch (UnknownHostException ignored) {
            debug.error("Host name is unknown but ignored.", ignored);
        }
        return false;
    }

    protected Socket doConnect(String host, int port) throws IOException {
        String hostname = null;
        try {
            hostname = InetAddress.getByName(host).getHostName();
        }
        catch (UnknownHostException e) {
            if (debug.messageEnabled()) {
                debug.message("Error : HttpsClient.doConnect ", e);
            }
            hostname = host;
        }
        if (secureTunnelHost == null || this.isNonProxyHost()) {
            if (debug.messageEnabled()) {
                debug.message("HttpsClient: doConnect(" + hostname + ", " + port + ")");
            }
            this.sslSocket = new SSLSocket(InetAddress.getByName(hostname), port, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(hostname), (SSLClientCertificateSelectionCallback)this);
        } else {
            if (debug.messageEnabled()) {
                debug.message("HttpsClient: doConnect through proxy " + secureTunnelHost + ":" + secureTunnelPort);
            }
            if (debug.messageEnabled()) {
                debug.message("HttpsClient: doConnect(" + hostname + ", " + port + ")");
            }
            this.sslSocket = new SSLSocket(InetAddress.getByName("localhost"), JSSProxy.serverPort, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(hostname), (SSLClientCertificateSelectionCallback)this);
            Integer localport = new Integer(this.sslSocket.getLocalPort());
            String info = secureTunnelHost + " " + secureTunnelPort + " " + host + " " + port;
            JSSProxy.connectHashMap.put(localport, info);
        }
        return this.sslSocket;
    }

    public String getCipherSuite() {
        try {
            return this.sslSocket.getStatus().getCipher();
        }
        catch (Exception e) {
            debug.error("HttpsClient: Can't get cipher suite on the connection.");
            return null;
        }
    }

    public X509Certificate[] getServerCertificateChain() {
        return null;
    }

    private static String getProperty(String prop) {
        SecurityException ex = null;
        try {
            return System.getProperty(prop);
        }
        catch (SecurityException e) {
            ex = e;
            try {
                return AccessController.doPrivileged(new GetPropertyAction("prop"));
            }
            catch (LinkageError e2) {
                debug.error("getProperty caught : ", e2);
                throw ex;
            }
        }
    }

    public void setClientCertificate(String name) {
        this.nickName = name;
    }

    public String select(Vector nicknames) {
        if (nicknames == null || nicknames.isEmpty()) {
            debug.message("nicknames vector is null");
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("all certs=" + nicknames.toString());
        }
        if (this.nickName == null) {
            debug.message("no nickname is set");
            return (String)nicknames.get(0);
        }
        if (nicknames.contains(this.nickName)) {
            debug.message("found nickname in vector");
            return this.nickName;
        }
        debug.message("no matching nickname found");
        return null;
    }

    static void configureFIPSSSLoptions() {
        try {
            if (CryptoManager.getInstance().FIPSEnabled()) {
                SSLSocket.enableSSL2Default((boolean)false);
                SSLSocket.enableSSL3Default((boolean)false);
                SSLSocket.enableTLSDefault((boolean)true);
                debug.message("NSS database is confirued in FIPS mode.");
                debug.message("Enable FIPS ciphersuites only.");
                int[] ciphers = SSLSocket.getImplementedCipherSuites();
                for (int i = 0; i < ciphers.length; ++i) {
                    if (SSLSocket.isFipsCipherSuite((int)ciphers[i])) {
                        SSLSocket.setCipherPreferenceDefault((int)ciphers[i], (boolean)true);
                        continue;
                    }
                    if (!SSLSocket.getCipherPreferenceDefault((int)ciphers[i])) continue;
                    SSLSocket.setCipherPreferenceDefault((int)ciphers[i], (boolean)false);
                }
            }
        }
        catch (SocketException ex) {
            debug.error("Error configuring FIPS SSL options.", ex);
        }
        catch (CryptoManager.NotInitializedException ex) {
            debug.error("Error configuring FIPS SSL options.", ex);
        }
    }

    static {
        HttpsClient.configureFIPSSSLoptions();
        HttpsClient.resetSecureProperties();
    }
}

