/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSAMLRequest
extends Request {
    protected FSSAMLRequest() {
    }

    public FSSAMLRequest(Element root) throws SAMLException {
        String tag = null;
        if (root == null) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): null input.");
            throw new SAMLRequesterException("libIDFF", "nullInput", null);
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("Request")) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): wrong input");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            this.valid = this.minorVersion == 0 ? manager.verifyXMLSignature(root) : manager.verifyXMLSignature(root, "RequestID", null);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException("libIDFF", "moreElement", null);
        }
        this.requestID = root.getAttribute("RequestID");
        if (this.requestID == null || this.requestID.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): Request does not have a RequestID.");
            }
            Object[] args = new String[]{"RequestID"};
            throw new SAMLRequesterException("libIDFF", "missingAttribute", args);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            SAMLUtils.debug.message("FSSAMLRequest(Element):  missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new SAMLRequesterException("libIDFF", "missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): could not parse IssueInstant", e);
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                String respondWith = XMLUtils.getElementValue((Element)child);
                if (respondWith.length() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("FSSAMLRequest(Element): wrong RespondWith value.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(respondWith);
                continue;
            }
            if (nodeName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (nodeName.equals("AssertionArtifact")) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("FSSAMLRequest(Element): contained mixed contents.");
                    }
                    throw new SAMLRequesterException("libIDFF", "wrongInput", null);
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                try {
                    FSAssertionArtifact newArt = new FSAssertionArtifact(XMLUtils.getElementValue((Element)child));
                    this.artifacts.add(newArt);
                }
                catch (Exception e) {
                    SAMLUtils.debug.error("FSSAMLRequest(Element): ", e);
                }
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element):invalid node" + nodeName);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.contentType == -1) {
            SAMLUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
    }

    private void parseMajorVersion(String majorVer) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): invalid MajorVersion", e);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("FSSAMLRequest(Element): MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException("libIDFF", "requestVersionTooHigh", null);
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException("libIDFF", "requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MinorVersion", e);
            }
            throw new SAMLRequesterException("libIDFF", "wrongInput", null);
        }
        if (this.minorVersion > 1) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too high.");
            throw new SAMLRequestVersionTooHighException("libIDFF", "requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too low.");
            throw new SAMLRequestVersionTooLowException("libIDFF", "requestVersionTooLow", null);
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }
}

