/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.ConsentHeader;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.ProcessingContextHeader;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.liberty.ws.soapbinding.UsageDirectiveHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFaultDetail {
    public static final QName BOGUS_ACTOR = new QName("urn:liberty:sb:2003-08", "BogusActor");
    public static final QName BOGUS_MUST_UNSTND = new QName("urn:liberty:sb:2003-08", "BogusMustUnstnd");
    public static final QName STALE_MSG = new QName("urn:liberty:sb:2003-08", "StaleMsg");
    public static final QName DUPLICATE_MSG = new QName("urn:liberty:sb:2003-08", "DuplicateMsg");
    public static final QName INVALID_REF_TO_MSG_ID = new QName("urn:liberty:sb:2003-08", "invalidRefToMsgID");
    public static final QName PROVIDER_ID_NOT_VALID = new QName("urn:liberty:sb:2003-08", "ProviderIDNotValid");
    public static final QName AFFILIATION_ID_NOT_VALID = new QName("urn:liberty:sb:2003-08", "AffiliationIDNotValid");
    public static final QName ID_STAR_MSG_NOT_UNSTD = new QName("urn:liberty:sb:2003-08", "IDStarMsgNotUnstd");
    public static final QName PROC_CTX_URI_NOT_UNSTD = new QName("urn:liberty:sb:2003-08", "ProcCtxURINotUnstd");
    public static final QName PROC_CTX_UNWILLING = new QName("urn:liberty:sb:2003-08", "ProcCtxUnwilling");
    public static final QName CAN_NOT_HONOUR_USAGE_DIRECTIVE = new QName("urn:liberty:sb:2003-08", "CannotHonourUsageDirective");
    public static final QName ENDPOINT_MOVED = new QName("urn:liberty:sb:2004-04", "EndpointMoved");
    public static final QName INAPPROPRIATE_CREDENTIALS = new QName("urn:liberty:sb:2004-04", "InappropriateCredentials");
    private QName statusCode = null;
    private String statusRef = null;
    private String statusComment = null;
    private CorrelationHeader correlationHeader = null;
    private ConsentHeader consentHeader = null;
    private List usageDirectiveHeaders = null;
    private ProviderHeader providerHeader = null;
    private ProcessingContextHeader processingContextHeader = null;
    private ServiceInstanceUpdateHeader serviceInstanceUpdateHeader = null;
    private List otherChildren = null;

    public SOAPFaultDetail(QName statusCode, String statusRef, String statusComment) {
        this.statusCode = statusCode;
        this.statusRef = statusRef;
        this.statusComment = statusComment;
    }

    public SOAPFaultDetail(List otherChildren) {
        this.otherChildren = otherChildren;
    }

    SOAPFaultDetail(Element detailElement) throws SOAPBindingException {
        NodeList nl = detailElement.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            return;
        }
        this.otherChildren = new ArrayList();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            String localName = element.getLocalName();
            String ns = element.getNamespaceURI();
            if ("urn:liberty:sb:2003-08".equals(ns)) {
                if ("Status".equals(localName)) {
                    String value = XMLUtils.getNodeAttributeValue(element, "code");
                    if (value == null || value.length() == 0) {
                        String msg = Utils.bundle.getString("missingFaultStatusCode");
                        Utils.debug.error("SOAPFaultException: " + msg);
                        throw new SOAPBindingException(msg);
                    }
                    this.statusCode = Utils.convertStringToQName(value, element);
                    this.statusRef = XMLUtils.getNodeAttributeValue(element, "ref");
                    this.statusComment = XMLUtils.getNodeAttributeValue(element, "comment");
                    continue;
                }
                if ("Correlation".equals(localName)) {
                    this.correlationHeader = new CorrelationHeader(element);
                    continue;
                }
                if ("Consent".equals(localName)) {
                    this.consentHeader = new ConsentHeader(element);
                    continue;
                }
                if ("UsageDirective".equals(localName)) {
                    if (this.usageDirectiveHeaders == null) {
                        this.usageDirectiveHeaders = new ArrayList();
                    }
                    this.usageDirectiveHeaders.add(new UsageDirectiveHeader(element));
                    continue;
                }
                if ("Provider".equals(localName)) {
                    this.providerHeader = new ProviderHeader(element);
                    continue;
                }
                if ("ProcessingContext".equals(localName)) {
                    this.processingContextHeader = new ProcessingContextHeader(element);
                    continue;
                }
                this.otherChildren.add(element);
                continue;
            }
            if ("urn:liberty:sb:2004-04".equals(ns) && "ServiceInstanceUpdate".equals(localName)) {
                this.serviceInstanceUpdateHeader = new ServiceInstanceUpdateHeader(element);
                continue;
            }
            this.otherChildren.add(element);
        }
        if (this.otherChildren.isEmpty()) {
            this.otherChildren = null;
        }
    }

    public CorrelationHeader getCorrelationHeader() {
        return this.correlationHeader;
    }

    public ConsentHeader getConsentHeader() {
        return this.consentHeader;
    }

    public List getUsageDirectiveHeaders() {
        return this.usageDirectiveHeaders;
    }

    public ProviderHeader getProviderHeader() {
        return this.providerHeader;
    }

    public ProcessingContextHeader getProcessingContextHeader() {
        return this.processingContextHeader;
    }

    public ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() {
        return this.serviceInstanceUpdateHeader;
    }

    public List getOtherChildren() {
        return this.otherChildren;
    }

    public QName getStatusCode() {
        return this.statusCode;
    }

    public String getStatusRef() {
        return this.statusRef;
    }

    public String getStatusComment() {
        return this.statusComment;
    }

    public void setCorrelationHeader(CorrelationHeader correlationHeader) {
        if (correlationHeader != null) {
            this.correlationHeader = correlationHeader;
        }
    }

    public void setConsentHeader(ConsentHeader consentHeader) {
        this.consentHeader = consentHeader;
    }

    public void setUsageDirectiveHeaders(List usageDirectiveHeaders) {
        this.usageDirectiveHeaders = usageDirectiveHeaders;
    }

    public void setProviderHeader(ProviderHeader providerHeader) {
        if (providerHeader != null) {
            this.providerHeader = providerHeader;
        }
    }

    public void setProcessingContextHeader(ProcessingContextHeader processingContextHeader) {
        this.processingContextHeader = processingContextHeader;
    }

    public void setServiceInstanceUpdateHeader(ServiceInstanceUpdateHeader serviceInstanceUpdateHeader) {
        this.serviceInstanceUpdateHeader = serviceInstanceUpdateHeader;
    }

    public void setOtherChildren(List otherChildren) {
        this.otherChildren = otherChildren;
    }

    public void setOtherChild(Element child) {
        this.otherChildren = new ArrayList(1);
        this.otherChildren.add(child);
    }

    public void setStatusCode(QName statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusRef(String statusRef) {
        this.statusRef = statusRef;
    }

    public void setStatusComment(String statusComment) {
        this.statusComment = statusComment;
    }

    void addToParent(Element faultE) {
        Iterator iter;
        Document doc = faultE.getOwnerDocument();
        Element detailE = doc.createElement("detail");
        faultE.appendChild(detailE);
        if (this.statusCode != null) {
            Element statusE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:Status");
            String localPart = this.statusCode.getLocalPart();
            String ns = this.statusCode.getNamespaceURI();
            if (ns != null && ns.length() > 0) {
                String prefix;
                if (ns.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    prefix = "S";
                } else if (ns.equals("urn:liberty:sb:2003-08")) {
                    prefix = "sb";
                } else if (ns.equals("urn:liberty:sb:2004-04")) {
                    prefix = "sb-ext";
                } else {
                    prefix = "fc";
                    statusE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
                }
                statusE.setAttributeNS(null, "code", prefix + ":" + localPart);
            } else {
                statusE.setAttributeNS(null, "code", localPart);
            }
            if (this.statusRef != null) {
                statusE.setAttributeNS(null, "ref", this.statusRef);
            }
            if (this.statusComment != null) {
                statusE.setAttributeNS(null, "comment", this.statusComment);
            }
            detailE.appendChild(statusE);
        }
        if (this.correlationHeader != null) {
            this.correlationHeader.addToParent(detailE);
        }
        if (this.consentHeader != null) {
            this.consentHeader.addToParent(detailE);
        }
        if (this.usageDirectiveHeaders != null && !this.usageDirectiveHeaders.isEmpty()) {
            iter = this.usageDirectiveHeaders.iterator();
            while (iter.hasNext()) {
                ((UsageDirectiveHeader)iter.next()).addToParent(detailE);
            }
        }
        if (this.providerHeader != null) {
            this.providerHeader.addToParent(detailE);
        }
        if (this.processingContextHeader != null) {
            this.processingContextHeader.addToParent(detailE);
        }
        if (this.serviceInstanceUpdateHeader != null) {
            this.serviceInstanceUpdateHeader.addToParent(detailE);
        }
        if (this.otherChildren != null && !this.otherChildren.isEmpty()) {
            iter = this.otherChildren.iterator();
            while (iter.hasNext()) {
                Element childE = (Element)iter.next();
                detailE.appendChild(doc.importNode(childE, true));
            }
        }
    }
}

