/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.identity.monitoring.Monitoring;
import com.sun.identity.monitoring.MonitoringUtils;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_RemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.CMM_SessionPoolInstrum;
import com.sun.mfwk.instrum.me.CMM_ThreadPoolInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_SessionPoolSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_ThreadPoolSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_RemoteServiceAccessPointStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceAccessURIStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_SessionPoolStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ThreadPoolStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.MfTransactionInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;

public class MonitoringSession {
    private static CMM_ServiceInstrum amSvcSess;
    private static CMM_ServiceInstrum amSvcSessPlugin;
    private static CMM_ServiceInstrum amSessPluginJmq;
    private static CMM_RemoteServiceAccessPointInstrum amSessRsapDbDest;
    private static CMM_ServiceStatsInstrum amSessSvcStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amSessRsapDbStats;
    private static CMM_ServiceAccessURIStatsInstrum amSessSvcUriStats;
    private static CMM_ServiceAccessURIStatsInstrum amSessJaxrpcUriStats;
    private static CMM_SessionPoolInstrum amSessSessionPoolElement;
    private static CMM_SessionPoolStatsInstrum amSessSessionPoolStats;
    private static CMM_SessionPoolSettingInstrum amSessSessionPoolSetting;
    private static CMM_ThreadPoolInstrum amSessThreadPoolElement;
    private static CMM_ThreadPoolStatsInstrum amSessThreadPoolStats;
    private static CMM_ThreadPoolSettingInstrum amSessThreadPoolSetting;
    private static CMM_ServiceAccessURIInstrum amSessSvcUri;
    private static CMM_ServiceAccessURIInstrum amSessJaxrpcUri;

    private MonitoringSession() {
    }

    protected static int createSession(MfManagedElementServer mfMEServer, CMM_ApplicationSystemInstrum amAppli) {
        Monitoring.debug.message("MonitoringSession:createSession");
        try {
            MfManagedElementInfo meInfo = mfMEServer.makeManagedElementInfo();
            MfRelationInfo relInfo = mfMEServer.makeRelationInfo();
            MfRelationInstrum mRI = null;
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("session");
            relInfo.setType(MfRelationType.CMM_HOSTED_SERVICE);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSvcSess = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("session plugins");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSess, relInfo, meInfo);
            amSvcSessPlugin = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("JMQ");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSessPlugin, relInfo, meInfo);
            amSessPluginJmq = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("Berkeley DB");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSessRsapDbDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSessRsapDbDest, relInfo, (CIM_ManagedElementInstrum)amSessPluginJmq);
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("session service URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSessSvcUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amSessSvcUri.setLabeledURI("%protocol://%host:%port/amserver/sessionservice");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSess, relInfo, (CIM_ManagedElementInstrum)amSessSvcUri);
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSess, relInfo, (CIM_ManagedElementInstrum)Monitoring.getAMJAXRPCURI());
            amSessJaxrpcUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_STATS);
            meInfo.setName("session rqt");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSess, relInfo, meInfo);
            amSessSvcStats = (CMM_ServiceStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("session DB rqt");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessRsapDbDest, relInfo, meInfo);
            amSessRsapDbStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("session URI stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessSvcUri, relInfo, meInfo);
            amSessSvcUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("session JAXRPC URI stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessJaxrpcUri, relInfo, meInfo);
            amSessJaxrpcUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SESSION_POOL);
            meInfo.setName("session session pool");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSessSessionPoolElement = (CMM_SessionPoolInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSess, relInfo, (CIM_ManagedElementInstrum)amSessSessionPoolElement);
            meInfo.setType(MfManagedElementType.CMM_SESSION_POOL_STATS);
            meInfo.setName("session session pool stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessSessionPoolElement, relInfo, meInfo);
            amSessSessionPoolStats = (CMM_SessionPoolStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SESSION_POOL_SETTING);
            meInfo.setName("session session pool setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessSessionPoolElement, relInfo, meInfo);
            amSessSessionPoolSetting = (CMM_SessionPoolSettingInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_THREAD_POOL);
            meInfo.setName("session thread pool");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSessThreadPoolElement = (CMM_ThreadPoolInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSess, relInfo, (CIM_ManagedElementInstrum)amSessThreadPoolElement);
            meInfo.setType(MfManagedElementType.CMM_THREAD_POOL_STATS);
            meInfo.setName("session thread pool stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessThreadPoolElement, relInfo, meInfo);
            amSessThreadPoolStats = (CMM_ThreadPoolStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_THREAD_POOL_SETTING);
            meInfo.setName("session thread pool setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSessThreadPoolElement, relInfo, meInfo);
            amSessThreadPoolSetting = (CMM_ThreadPoolSettingInstrum)mRI.getDestination();
            Monitoring.debug.message("MonitoringSession:createSess:stats");
            MonitoringSession.initStats();
        }
        catch (MfManagedElementServerException mmese) {
            Monitoring.debug.error("createSession: " + mmese.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            Monitoring.debug.error("createSession: " + mrie.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("createSession:from initStats(): " + mmeie.getMessage());
        }
        return 0;
    }

    public static void initAttributes() {
    }

    private static void initStats() throws MfManagedElementInstrumException {
        if (amSessSessionPoolStats != null) {
            amSessSessionPoolStats.setActiveSessions(0L);
        }
        MonitoringUtils.initSvcStats(amSessSvcStats, "session");
        if (amSessSvcStats != null) {
            amSessSvcStats.setInRequestsInBytes(0L);
            amSessSvcStats.setAbortedRequests(0L);
            amSessSvcStats.setFailedRequests(0L);
            amSessSvcStats.setOutRequests(0L);
            MfTransactionInstrum trans = amSessSvcStats.getTransaction();
            if (trans.start() == -1 && Monitoring.debug.warningEnabled()) {
                Monitoring.debug.warning("MonitoringSession:initStat:trans:code = " + trans.getErrorCode() + ", errmsg = " + trans.getErrorMessage(trans.getErrorCode()));
            }
            Monitoring.debug.message("MonitoringSession:initStat:trans started");
            if (trans.stop(0) == -1 && Monitoring.debug.warningEnabled()) {
                Monitoring.debug.warning("MonitoringSession:initStat:trans stop:code = " + trans.getErrorCode() + ", errmsg = " + trans.getErrorMessage(trans.getErrorCode()));
            }
            Monitoring.debug.message("MonitoringSession:initStat:trans ended");
        }
        MonitoringUtils.initSessionPoolStats(amSessSessionPoolStats, "session");
        MonitoringUtils.initSessionPoolSetting(amSessSessionPoolSetting, "session");
        MonitoringUtils.initThreadPoolStats(amSessThreadPoolStats, "session");
        MonitoringUtils.initThreadPoolSetting(amSessThreadPoolSetting, "session");
        MonitoringUtils.initRsapStats(amSessRsapDbStats, "session DB server");
        MonitoringUtils.initSvcUriStats(amSessSvcUriStats, "session");
    }

    public static void setStatus(OperationalStatus status) {
        HashSet<OperationalStatus> sessStatus = new HashSet<OperationalStatus>();
        sessStatus.add(status);
        if (amSvcSess == null || amSvcSessPlugin == null) {
            return;
        }
        try {
            amSvcSess.setOperationalStatus(sessStatus);
            amSvcSessPlugin.setOperationalStatus(sessStatus);
            if (amSessPluginJmq != null) {
                amSessPluginJmq.setOperationalStatus(sessStatus);
            }
            if (amSessThreadPoolElement != null) {
                amSessThreadPoolElement.setOperationalStatus(sessStatus);
            }
            if (amSessSessionPoolElement != null) {
                amSessSessionPoolElement.setOperationalStatus(sessStatus);
            }
            if (amSessSvcUri != null) {
                amSessSvcUri.setOperationalStatus(sessStatus);
            }
            if (amSessRsapDbDest != null) {
                amSessRsapDbDest.setOperationalStatus(sessStatus);
            }
            if (amSessJaxrpcUri != null) {
                amSessJaxrpcUri.setOperationalStatus(sessStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringSession:setStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringSession:setStatus:error = " + mmeie.getMessage());
        }
    }

    public static CMM_ServiceStatsInstrum getSessSvcStats() {
        return amSessSvcStats;
    }

    public static CMM_SessionPoolStatsInstrum getSessSessionPoolStats() {
        return amSessSessionPoolStats;
    }

    public static void incrementSessions() {
        if (amSessSessionPoolStats == null) {
            return;
        }
        try {
            amSessSessionPoolStats.addActiveSessions(1L);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringSession:incrementSessions:error = " + mmeie.getMessage());
        }
    }

    public static void decrementSessions() {
        if (amSessSessionPoolStats == null) {
            return;
        }
        try {
            amSessSessionPoolStats.substractActiveSessions(1L);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringSession:decrementSessions:error = " + mmeie.getMessage());
        }
    }

    protected static CMM_ServiceInstrum getSvcSess() {
        return amSvcSess;
    }
}

