/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.plugins.PrefixResourceName;
import com.sun.identity.shared.debug.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;

public class URLResourceName
extends PrefixResourceName
implements Comparator {
    private Debug debug = Debug.getInstance("amPolicy");
    private static Comparator comparator = new URLResourceName();
    private static final String QUERY_PARAMETER_DELIMITER = "&";
    private static final String QUERY_PARAMETER_VALUE_DELIMITER = "=";
    private static final String DEFAULT_WEB_PROTOCOL = "http";
    private static final String SECURE_WEB_PROTOCOL = "https";
    private static final String DEFAULT_PORT = "80";
    private static final String SECURE_PORT = "443";

    public String canonicalize(String urlStr) throws PolicyException {
        String resource;
        if (!urlStr.startsWith("http://") && !urlStr.startsWith("https://")) {
            return super.canonicalize(urlStr);
        }
        int index = urlStr.indexOf("://");
        String proto = urlStr.substring(0, index);
        String hostAndPort = resource = urlStr.substring(index + 3);
        String urlPath = "";
        if (resource.startsWith(this.delimiter)) {
            int j;
            int len = resource.length();
            char[] oldchars = resource.toCharArray();
            char[] newchars = new char[len];
            for (j = 0; j < len && oldchars[j] == this.delimiter.charAt(0); ++j) {
            }
            int i = 0;
            while (j < len) {
                newchars[i++] = oldchars[j++];
            }
            resource = String.valueOf(newchars, 0, i);
        }
        String hostName = "";
        String port = "";
        if (resource != null && resource.length() != 0) {
            index = resource.indexOf(47);
            if (index != -1) {
                hostAndPort = resource.substring(0, index);
                urlPath = resource.substring(index);
            }
            hostName = hostAndPort;
            index = hostAndPort.indexOf(58);
            if (index != -1) {
                hostName = hostAndPort.substring(0, index);
                port = hostAndPort.substring(index + 1);
                this.validatePort(port);
            }
            if (port.length() == 0) {
                port = proto.equals(DEFAULT_WEB_PROTOCOL) ? DEFAULT_PORT : SECURE_PORT;
            }
        }
        String newUrl = proto + "://" + hostName + urlPath;
        URL url = null;
        try {
            url = new URL(newUrl);
        }
        catch (MalformedURLException me) {
            throw new PolicyException(me);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(proto);
        sb.append("://");
        sb.append(hostName);
        if (hostName.length() != 0) {
            sb.append(":");
            sb.append(port);
        }
        String query = url.getQuery();
        if (this.debug.messageEnabled()) {
            this.debug.message("URLResourceName: url query=" + query);
        }
        if (query != null) {
            int indexQuery = urlPath.indexOf(query);
            String prefix = super.canonicalize(urlPath.substring(0, indexQuery));
            int indexAmp = query.indexOf(QUERY_PARAMETER_DELIMITER);
            if (indexAmp != -1) {
                String suffix = urlPath.substring(indexQuery + query.length());
                sb.append(prefix);
                ArrayList<String> al = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(query, QUERY_PARAMETER_DELIMITER);
                while (st.hasMoreTokens()) {
                    al.add(st.nextToken());
                }
                Collections.sort(al, comparator);
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    if (i < size - 1) {
                        sb.append((String)al.get(i) + QUERY_PARAMETER_DELIMITER);
                        continue;
                    }
                    sb.append((String)al.get(i));
                }
                sb.append(suffix);
            } else {
                sb.append(prefix);
                sb.append(query);
            }
        } else {
            sb.append(super.canonicalize(urlPath));
        }
        return sb.toString();
    }

    public int compare(Object o1, Object o2) {
        int result;
        String s1 = (String)o1;
        String s2 = (String)o2;
        if (s1 == null) {
            if (s2 != null) {
                return -1;
            }
            return 0;
        }
        if (s2 == null) {
            return 1;
        }
        String var1 = s1;
        String value1 = null;
        String var2 = s2;
        String value2 = null;
        int index1 = s1.indexOf(QUERY_PARAMETER_VALUE_DELIMITER);
        int index2 = s2.indexOf(QUERY_PARAMETER_VALUE_DELIMITER);
        if (index1 != -1) {
            var1 = s1.substring(0, index1);
            value1 = s1.substring(index1);
        }
        if (index2 != -1) {
            var2 = s2.substring(0, index2);
            value2 = s2.substring(index2);
        }
        if ((result = var1.compareTo(var2)) == 0) {
            result = value1 == null ? (value2 != null ? -1 : 0) : (value2 == null ? 1 : value1.compareTo(value2));
        }
        return result;
    }

    private void validatePort(String port) throws PolicyException {
        String portString = port;
        int idx = port.indexOf(this.wildcard);
        if (idx != -1) {
            int begin = 0;
            int wildcardLen = this.wildcard.length();
            StringBuffer sb = new StringBuffer(100);
            while (idx != -1) {
                sb.append(port.substring(begin, idx));
                begin = idx + wildcardLen;
                idx = port.indexOf(this.wildcard, begin);
            }
            sb.append(port.substring(begin));
            portString = sb.toString();
        }
        if (portString != null && portString.length() != 0) {
            try {
                Integer.parseInt(portString);
            }
            catch (Exception e) {
                Object[] objs = new String[]{port};
                throw new PolicyException("amPolicy", "invalid_port_number", objs, null);
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("URLResourceName: portString = " + portString);
        }
    }
}

