/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Node;

public class PolicyNotification {
    static final String POLICY_CHANGE = "PolicyChangeNotification";
    static final String NOTIFICATION_ID = "notificationId";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    public static final int POLICY_CHANGE_TYPE = 1;
    private int notificationType = 0;
    private String notificationId = "0";
    private PolicyChangeNotification policyChangeNotification = null;

    PolicyNotification() {
    }

    public int getNotificationType() {
        return this.notificationType;
    }

    void setNotificationType(int nt) {
        this.notificationType = nt;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    void setNotificationId(String nId) {
        this.notificationId = nId;
    }

    public PolicyChangeNotification getPolicyChangeNotification() {
        return this.policyChangeNotification;
    }

    void setPolicyChangeNotification(PolicyChangeNotification pcn) {
        this.policyChangeNotification = pcn;
    }

    public static PolicyNotification parseXML(Node pNode) throws PolicyEvaluationException {
        PolicyNotification policyNotification = new PolicyNotification();
        String attr = XMLUtils.getNodeAttributeValue(pNode, NOTIFICATION_ID);
        if (attr == null) {
            debug.error("PolicyResponse.parseXML: missing attribute notificationId");
            Object[] objs = new String[]{NOTIFICATION_ID};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        policyNotification.setNotificationId(attr);
        Node node = XMLUtils.getChildNode(pNode, POLICY_CHANGE);
        if (node != null) {
            PolicyChangeNotification pcn = PolicyChangeNotification.parseXML(node);
            policyNotification.setPolicyChangeNotification(pcn);
            policyNotification.setNotificationType(1);
            return policyNotification;
        }
        debug.error("PolicyNotification: missing either PolicyChangeNotification element in the xml");
        Object[] objs = new String[]{POLICY_CHANGE};
        throw new PolicyEvaluationException("amPolicy", "missing_element", objs, null);
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(1000);
        xmlsb.append("<").append("PolicyNotification").append(" ").append(NOTIFICATION_ID).append("=\"").append(this.notificationId).append("\">").append(CRLF);
        if (this.notificationType == 1) {
            xmlsb.append(this.policyChangeNotification.toXMLString());
        } else {
            debug.error("PolicyNotification.toXMLString(): unknown notification type");
        }
        xmlsb.append("</").append("PolicyNotification").append(">").append(CRLF);
        return xmlsb.toString();
    }
}

