/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.security.x509.IssuingDistributionPointExtension;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.security.cert.AMCertStore;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

public class AMCRLStore
extends AMCertStore {
    private static Hashtable cachedcrls = new Hashtable();
    private String mCrlAttrName = null;

    public AMCRLStore(AMLDAPCertStoreParameters param) {
        super(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL getCRL(X509Certificate certificate) throws IOException {
        LDAPEntry crlEntry = null;
        X509CRL crl = this.getCRLFromCache(certificate);
        LDAPConnection ldc = this.getConnection();
        try {
            if (crl == null) {
                if (debug.messageEnabled()) {
                    debug.message("AMCRLStore.getCRL: crl is null");
                }
                crlEntry = this.getLdapEntry(ldc);
                crl = this.getCRLFromEntry(crlEntry);
            }
        }
        catch (Exception e) {
            debug.error("AMCRLStore.getCRL: Error in getting CRL from Configured Directory : ", e);
        }
        finally {
            if (ldc != null && ldc.isConnected()) {
                try {
                    ldc.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
        try {
            if (this.needCRLUpdate(crl)) {
                if (debug.messageEnabled()) {
                    debug.message("AMCRLStore.getCRL: need CRL update");
                }
                X509CRL tmpcrl = null;
                IssuingDistributionPointExtension crlIDPExt = null;
                try {
                    if (crl != null) {
                        crlIDPExt = this.getCRLIDPExt(crl);
                    }
                }
                catch (Exception e) {
                    debug.message("AMCRLStore.getCRL: crlIDPExt is null");
                }
                CRLDistributionPointsExtension crlDPExt = null;
                try {
                    crlDPExt = this.getCRLDPExt(certificate);
                }
                catch (Exception e) {
                    debug.message("AMCRLStore.getCRL: crlDPExt is null");
                }
                if (tmpcrl == null && crlIDPExt != null) {
                    tmpcrl = this.getUpdateCRLFromCrlIDP(crlIDPExt);
                }
                if (tmpcrl == null && crlDPExt != null) {
                    tmpcrl = this.getUpdateCRLFromCrlDP(crlDPExt);
                }
                if (tmpcrl != null) {
                    if (crlEntry == null) {
                        crlEntry = this.getLdapEntry(ldc);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMCRLStore.getCRL: new crl = " + tmpcrl);
                    }
                    if (crlEntry != null) {
                        this.updateCRL(ldc, crlEntry.getDN().toString(), tmpcrl.getEncoded());
                    }
                }
                crl = tmpcrl;
            }
            this.updateCRLCache(certificate, crl);
        }
        catch (Exception e) {
            debug.error("AMCRLStore.getCRL: Error in getting CRL : ", e);
        }
        return crl;
    }

    public X509CRL getCRLFromCache(X509Certificate certificate) throws IOException {
        X500Name issuerDN = AMCRLStore.getIssuerDN(certificate);
        X509CRL crl = null;
        crl = (X509CRL)cachedcrls.get(issuerDN.toString());
        return crl;
    }

    public void updateCRLCache(X509Certificate certificate, X509CRL crl) throws IOException {
        X500Name issuerDN = AMCRLStore.getIssuerDN(certificate);
        if (crl == null) {
            cachedcrls.remove(issuerDN.toString());
        } else {
            cachedcrls.put(issuerDN.toString(), crl);
        }
    }

    private X509CRL getCRLFromEntry(LDAPEntry crlEntry) throws Exception {
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getCRLFromEntry:");
        }
        if (crlEntry == null) {
            return null;
        }
        LDAPAttributeSet attributeSet = crlEntry.getAttributeSet();
        LDAPAttribute crlAttribute = null;
        X509CRL crl = null;
        try {
            if (this.mCrlAttrName == null) {
                crlAttribute = attributeSet.getAttribute("certificaterevocationlist");
                if (crlAttribute == null && (crlAttribute = attributeSet.getAttribute("certificaterevocationlist;binary")) == null) {
                    debug.error("No CRL Cache is configured");
                    return null;
                }
                this.mCrlAttrName = crlAttribute.getName();
            } else {
                crlAttribute = attributeSet.getAttribute(this.mCrlAttrName);
            }
            if (crlAttribute.size() > 1) {
                debug.error("More than one CRL entries are configured");
                return null;
            }
        }
        catch (Exception e) {
            debug.error("Error in getting Cached CRL");
            return null;
        }
        try {
            Enumeration Crls = crlAttribute.getByteValues();
            byte[] bytes = (byte[])Crls.nextElement();
            if (debug.messageEnabled()) {
                debug.message("AMCRLStore.getCRLFromEntry: crl size = " + bytes.length);
            }
            cf = CertificateFactory.getInstance("X.509");
            crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            debug.error("Certificate: CertRevoked = ", e);
        }
        return crl;
    }

    private CRLDistributionPointsExtension getCRLDPExt(X509Certificate certificate) {
        CRLDistributionPointsExtension dpExt = null;
        Object exts = null;
        try {
            X509CertImpl certImpl = new X509CertImpl(certificate.getEncoded());
            dpExt = certImpl.getCRLDistributionPointsExtension();
        }
        catch (Exception e) {
            debug.error("Error finding CRL distribution Point configured: ", e);
        }
        return dpExt;
    }

    private IssuingDistributionPointExtension getCRLIDPExt(X509CRL crl) {
        IssuingDistributionPointExtension idpExt = null;
        if (crl == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getCRLIDPExt: crl = " + crl);
        }
        try {
            byte[] ext = crl.getExtensionValue(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (ext != null) {
                idpExt = new IssuingDistributionPointExtension(ext);
            }
        }
        catch (Exception e) {
            debug.error("Error finding CRL distribution Point configured: ", e);
        }
        return idpExt;
    }

    private synchronized X509CRL getUpdateCRLFromCrlDP(CRLDistributionPointsExtension dpExt) {
        List dps;
        block8: {
            if (dpExt == null) {
                return null;
            }
            dps = null;
            try {
                dps = (List)dpExt.get("points");
            }
            catch (IOException ioex) {
                if (!debug.warningEnabled()) break block8;
                debug.warning("AMCRLStore.getUpdateCRLFromCrlDP: ", ioex);
            }
        }
        if (dps == null || dps.isEmpty()) {
            return null;
        }
        Iterator iter = dps.iterator();
        while (iter.hasNext()) {
            byte[] Crls;
            DistributionPoint dp = (DistributionPoint)iter.next();
            GeneralNames gName = dp.getFullName();
            if (debug.messageEnabled()) {
                debug.message("AMCRLStore.getUpdateCRLFromCrlDP: DP = " + gName);
            }
            if ((Crls = this.getCRLsFromGeneralNames(gName)) == null || Crls.length <= 0) continue;
            try {
                return (X509CRL)cf.generateCRL(new ByteArrayInputStream(Crls));
            }
            catch (Exception ex) {
                if (!debug.warningEnabled()) continue;
                debug.warning("AMCRLStore.getUpdateCRLFromCrlDP: Error in generating X509CRL", ex);
            }
        }
        return null;
    }

    private synchronized X509CRL getUpdateCRLFromCrlIDP(IssuingDistributionPointExtension idpExt) {
        GeneralNames gName = idpExt.getFullName();
        if (gName == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getUpdateCRLFromCrlIDP: gName = " + gName);
        }
        byte[] Crls = this.getCRLsFromGeneralNames(gName);
        X509CRL crl = null;
        if (Crls != null) {
            try {
                crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(Crls));
            }
            catch (Exception e) {
                debug.error("Error in generating X509CRL" + e.toString());
            }
        }
        return crl;
    }

    private byte[] getCRLsFromGeneralNames(GeneralNames gName) {
        byte[] Crls = null;
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getCRLsFromGeneralNames: gNames.size = " + gName.size());
        }
        int idx = 0;
        do {
            String uri;
            String protocol;
            int proto_pos;
            if ((proto_pos = (protocol = (uri = gName.get(idx++).toString().trim()).toLowerCase()).indexOf("http")) == -1 && (proto_pos = protocol.indexOf("https")) == -1 && (proto_pos = protocol.indexOf("ldap")) == -1 && (proto_pos = protocol.indexOf("ldaps")) == -1) continue;
            uri = uri.substring(proto_pos, uri.length());
            if (debug.messageEnabled()) {
                debug.message("DP Name : " + uri);
            }
            Crls = this.getCRLByURI(uri);
        } while (Crls != null && idx < gName.size());
        return Crls;
    }

    private boolean updateCRL(LDAPConnection ldc, String dn, byte[] crls) {
        LDAPAttribute crlAttribute = new LDAPAttribute(this.mCrlAttrName, crls);
        LDAPModification mod = new LDAPModification(2, crlAttribute);
        try {
            ldc.modify(dn, mod);
        }
        catch (LDAPException e) {
            debug.error("Error updating CRL Cache : ", e);
            return false;
        }
        return true;
    }

    private byte[] getCRLByURI(String uri) {
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getCRLByURI : uri = " + uri);
        }
        if (uri == null) {
            return null;
        }
        String protocol = uri.trim().toLowerCase();
        if (protocol.startsWith("http") || protocol.startsWith("https")) {
            return this.getCRLByHttpURI(uri);
        }
        if (protocol.startsWith("ldap") || protocol.startsWith("ldaps")) {
            return this.getCRLByLdapURI(uri);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getCRLByLdapURI(String uri) {
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.getCRLByLdapURI: uri = " + uri);
        }
        LDAPUrl url = null;
        LDAPConnection ldc = null;
        byte[] crl = null;
        try {
            url = new LDAPUrl(uri);
            if (debug.messageEnabled()) {
                debug.message("AMCRLStore.getCRLByLdapURI: url.dn = " + url.getDN());
            }
            ldc = url.isSecure() ? new LDAPConnection(this.storeParam.getSecureSocketFactory()) : new LDAPConnection();
            ldc.connect(url.getHost(), url.getPort(), "", "");
            LDAPSearchResults results = ldc.search(url.getDN().toString(), 0, null, null, false);
            if (results == null || !results.hasMoreElements()) {
                debug.error("verifyCertificate - No CRL distribution Point configured");
                byte[] byArray = null;
                return byArray;
            }
            LDAPEntry entry = results.next();
            LDAPAttributeSet attributeSet = entry.getAttributeSet();
            LDAPAttribute crlAttribute = attributeSet.getAttribute("certificaterevocationlist");
            if (crlAttribute == null && (crlAttribute = attributeSet.getAttribute("certificaterevocationlist;binary")) == null) {
                debug.error("verifyCertificate - No CRL distribution Point configured");
                byte[] byArray = null;
                return byArray;
            }
            crl = (byte[])crlAttribute.getByteValues().nextElement();
            return crl;
        }
        catch (Exception e) {
            debug.error("getCRLByLdapURI : Error in getting CRL", e);
            return crl;
        }
        finally {
            if (ldc != null && ldc.isConnected()) {
                try {
                    ldc.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
    }

    private byte[] getCRLByHttpURI(String url) {
        String argString = "";
        StringBuffer params = null;
        HttpURLConnection con = null;
        byte[] crl = null;
        String uriParamsCRL = this.storeParam.getURIParams();
        try {
            int len;
            byte[] paramsBytes;
            if (uriParamsCRL != null) {
                params = new StringBuffer();
                StringTokenizer st1 = new StringTokenizer(uriParamsCRL, ",");
                while (st1.hasMoreTokens()) {
                    String token = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(token, "=");
                    if (st2.countTokens() != 2) continue;
                    String param = st2.nextToken();
                    String value = st2.nextToken();
                    params.append(AMURLEncDec.encode(param) + "=" + AMURLEncDec.encode(value));
                    if (!st1.hasMoreTokens()) continue;
                    params.append("&");
                }
            }
            URL uri = new URL(url);
            con = HttpURLConnectionManager.getConnection(uri);
            con.setDoInput(true);
            con.setUseCaches(false);
            if (params != null && (paramsBytes = params.toString().trim().getBytes("UTF-8")).length > 0) {
                con.setDoOutput(true);
                con.setRequestProperty("Content-Length", Integer.toString(paramsBytes.length));
                BufferedOutputStream out = new BufferedOutputStream(con.getOutputStream());
                out.write(paramsBytes, 0, paramsBytes.length);
                out.flush();
                out.close();
            }
            InputStream in = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, len);
            }
            crl = bos.toByteArray();
            if (debug.messageEnabled()) {
                debug.message("AMCRLStore.getCRLByHttpURI: crl.length = " + crl.length);
            }
        }
        catch (Exception e) {
            debug.error("getCRLByHttpURI : Error in getting CRL", e);
        }
        return crl;
    }

    private boolean needCRLUpdate(X509CRL crl) {
        Date nextCRLUpdate = null;
        if (crl == null) {
            return true;
        }
        nextCRLUpdate = crl.getNextUpdate();
        if (debug.messageEnabled()) {
            debug.message("AMCRLStore.needCRLUpdate: nextCrlUpdate = " + nextCRLUpdate);
        }
        return nextCRLUpdate != null && nextCRLUpdate.before(new Date());
    }

    public static X509CRL getCRL(AMLDAPCertStoreParameters ldapParam, X509Certificate cert, String attrName) {
        X509CRL crl = null;
        try {
            String attrValue = null;
            try {
                X500Name dn = AMCRLStore.getIssuerDN(cert);
                if (dn != null) {
                    attrValue = dn.getAttributeValue(attrName);
                }
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("AMCRLStore:getCRL Certificate - cn substring: " + ex);
                }
                return null;
            }
            if (attrValue == null) {
                return null;
            }
            if (debug.messageEnabled()) {
                debug.message("Certificate - cn substring: " + attrValue);
            }
            String searchFilter = AMCRLStore.setSearchFilter(attrName, attrValue);
            ldapParam.setSearchFilter(searchFilter);
            AMCRLStore store = new AMCRLStore(ldapParam);
            crl = store.getCRL(cert);
        }
        catch (Exception e) {
            debug.error("AMCRLStore:getCRL " + e.toString());
        }
        return crl;
    }
}

