/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.ums.validation.BooleanValidator;
import com.iplanet.ums.validation.DNValidator;
import com.iplanet.ums.validation.FloatValidator;
import com.iplanet.ums.validation.MailAddressValidator;
import com.iplanet.ums.validation.NumberValidator;
import com.iplanet.ums.validation.URLValidator;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AttributeValidator {
    static final MailAddressValidator mailValidator = new MailAddressValidator();
    static final BooleanValidator boolValidator = new BooleanValidator();
    static final NumberValidator numberValidator = new NumberValidator();
    static final URLValidator urlValidator = new URLValidator();
    static final FloatValidator floatValidator = new FloatValidator();
    static final DNValidator dnValidator = new DNValidator();
    static Debug debug = SMSEntry.debug;
    private AttributeSchemaImpl as;

    AttributeValidator(AttributeSchemaImpl as) {
        this.as = as;
    }

    private boolean validateSyntax(Set values, boolean encodePassword) throws SMSException {
        AttributeSchema.Syntax syntax = this.as.getSyntax();
        if (syntax == null) {
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.STRING) || syntax.equals(AttributeSchema.Syntax.PARAGRAPH) || syntax.equals(AttributeSchema.Syntax.URL) || syntax.equals(AttributeSchema.Syntax.XML) || syntax.equals(AttributeSchema.Syntax.BOOLEAN) || syntax.equals(AttributeSchema.Syntax.DATE)) {
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.EMAIL)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (mailValidator.validate((String)it.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.PASSWORD) || syntax.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            if (encodePassword) {
                HashSet<Object> encValues = new HashSet<Object>();
                HashSet<String> remValues = new HashSet<String>();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    try {
                        encValues.add(AccessController.doPrivileged(new EncodeAction(value)));
                    }
                    catch (Throwable e) {
                        debug.error("AttributeValidator: Unable to encode", e);
                        encValues.add(value);
                    }
                    remValues.add(value);
                }
                values.removeAll(remValues);
                values.addAll(encValues);
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMERIC) || syntax.equals(AttributeSchema.Syntax.NUMBER)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (numberValidator.validate((String)it.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.PERCENT) || syntax.equals(AttributeSchema.Syntax.DECIMAL_NUMBER)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (floatValidator.validate((String)it.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMBER_RANGE)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                int end;
                int start;
                int i;
                String s = (String)it.next();
                try {
                    i = Integer.parseInt(s);
                    String startRange = this.as.getStartRange();
                    String endRange = this.as.getEndRange();
                    if (startRange == null && endRange == null) {
                        return true;
                    }
                    start = Integer.parseInt(startRange);
                    end = Integer.parseInt(endRange);
                }
                catch (Exception e) {
                    return false;
                }
                if (i >= start && i <= end) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.DECIMAL_RANGE)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                float end;
                float start;
                float f;
                String s = (String)it.next();
                try {
                    f = Float.parseFloat(s);
                    String startRange = this.as.getStartRange();
                    String endRange = this.as.getEndRange();
                    if (startRange == null && endRange == null) {
                        return true;
                    }
                    start = Float.parseFloat(startRange);
                    end = Float.parseFloat(endRange);
                }
                catch (Exception e) {
                    return false;
                }
                if (!(f < start) && !(f > end)) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.DN)) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (dnValidator.validate((String)it.next())) continue;
                return false;
            }
            return true;
        }
        Object[] args = new String[]{this.as.getName()};
        throw new SMSException("amSDK", "sms-invalid_attribute_syntax", args);
    }

    private boolean validateType(Set values, Map env) throws SMSException {
        AttributeSchema.Type type = this.as.getType();
        if (type == null) {
            return true;
        }
        if (type.equals(AttributeSchema.Type.SINGLE)) {
            return values.size() <= 1;
        }
        if (type.equals(AttributeSchema.Type.LIST)) {
            int size = values.size();
            int minValue = this.as.getMinValue();
            int maxValue = this.as.getMaxValue();
            return minValue == -1 || maxValue == -1 || size >= minValue && size <= maxValue;
        }
        if (type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            String val;
            if (values.size() > 1) {
                return false;
            }
            String[] array = this.as.getChoiceValues(env);
            Iterator it = values.iterator();
            String string = val = it.hasNext() ? (String)it.next() : null;
            if (val == null) {
                return true;
            }
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }
        if (type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) {
            String[] array = this.as.getChoiceValues(env);
            int size = values.size();
            int minValue = this.as.getMinValue();
            int maxValue = this.as.getMaxValue();
            if (minValue != -1 && maxValue != -1 && (size < minValue || size > maxValue)) {
                return false;
            }
            if (size == 0) {
                return true;
            }
            if (array == null || array.length == 0) {
                return false;
            }
            Iterator it = values.iterator();
            int arraySize = array.length;
            while (it.hasNext()) {
                boolean match = false;
                String value = (String)it.next();
                for (int i = 0; i < arraySize; ++i) {
                    if (!array[i].equalsIgnoreCase(value)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
        if (type.equals(AttributeSchema.Type.VALIDATOR)) {
            return true;
        }
        if (type.equals(AttributeSchema.Type.SIGNATURE)) {
            return true;
        }
        Object[] args = new String[]{this.as.getName()};
        throw new SMSException("amSDK", "sms-invalid_attribute_type", args);
    }

    boolean validate(Set attrVals, String i18nFileName, boolean encodePassword) throws SMSException {
        return this.validate(attrVals, i18nFileName, encodePassword, Collections.EMPTY_MAP);
    }

    boolean validate(Set attrVals, String i18nFileName, boolean encodePassword, Map envParam) throws SMSException {
        if (!this.validateType(attrVals, envParam) || !this.validateSyntax(attrVals, encodePassword)) {
            if (debug.messageEnabled()) {
                debug.message("Validation Failed for attribute: " + this.as.getName() + " value:" + attrVals + " Env Map: " + envParam);
            }
            if (i18nFileName != null) {
                Object[] args = new String[]{this.as.getName(), i18nFileName, this.as.getI18NKey()};
                throw new InvalidAttributeValueException("amSDK", "sms-attribute-values-does-not-match-schema", args);
            }
            Object[] args = new String[]{this.as.getName()};
            throw new InvalidAttributeValueException("amSDK", "sms-attribute-values-does-not-match-schema", args);
        }
        return true;
    }

    Map inheritDefaults(Map attrs) {
        Set values = (Set)attrs.get(this.as.getName());
        if (values == null) {
            attrs.put(this.as.getName(), this.as.getDefaultValues());
        } else if (this.as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) || this.as.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            HashSet<Object> vals = new HashSet<Object>();
            Iterator items = values.iterator();
            while (items.hasNext()) {
                String tString = (String)items.next();
                try {
                    vals.add(AccessController.doPrivileged(new DecodeAction(tString)));
                }
                catch (Throwable e) {
                    debug.error("AttributeValidator: Unable to decode", e);
                    vals.add(tString);
                }
            }
            attrs.put(this.as.getName(), vals);
        }
        return attrs;
    }

    Map decodeEncodedAttrs(Map attrs) {
        Set values = (Set)attrs.get(this.as.getName());
        if (values == null) {
            return attrs;
        }
        if (this.as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) || this.as.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            HashSet<Object> vals = new HashSet<Object>();
            Iterator items = values.iterator();
            while (items.hasNext()) {
                String tString = (String)items.next();
                try {
                    vals.add(AccessController.doPrivileged(new DecodeAction(tString)));
                }
                catch (Throwable e) {
                    debug.error("AttributeValidator: Unable to decode", e);
                    vals.add(tString);
                }
            }
            attrs.put(this.as.getName(), vals);
        }
        return attrs;
    }
}

