/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class CachedSMSEntry {
    private static final String cachedSMSEntriesMutex = "CachedSMSEntriesMutex";
    protected static final String UPDATE_NOTIFY_METHOD = "updateAndNotifyListeners";
    protected static final String UPDATE_METHOD = "update";
    protected static Map smsEntries = new CaseInsensitiveHashMap(1000);
    protected HashSet serviceObjects;
    protected Set principals;
    protected SSOToken token;
    protected String dn2Str;
    protected String dnRFCStr;
    protected SMSEntry smsEntry;
    protected String notificationID = null;
    private boolean valid = false;

    private CachedSMSEntry(SMSEntry e) {
        this.smsEntry = e;
        DN dn = new DN(e.getDN());
        this.dn2Str = dn.toString();
        this.dnRFCStr = dn.toRFCString();
        this.serviceObjects = new HashSet();
        this.token = e.getSSOToken();
        this.principals = new HashSet();
        this.addPrincipal(this.token);
        this.valid = true;
        this.smsEntry.setReadOnly();
        try {
            Class<?> c = this.getClass();
            this.notificationID = SMSEventListenerManager.notifyChangesToNode(this.token, this.smsEntry.getDN(), c.getDeclaredMethod(UPDATE_METHOD, null), this, null);
        }
        catch (Exception ce) {
            SMSEntry.debug.error("CachedSMSEntry: unable to add listener for " + e.getDN(), ce);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: create new instance: " + dn);
        }
    }

    boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void update() {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: update method called: " + this.dn2Str);
        }
        try {
            SSOToken t = this.getValidSSOToken();
            if (t != null) {
                this.smsEntry.read(t);
                this.updateServiceListeners(UPDATE_NOTIFY_METHOD);
                return;
            }
            String string = cachedSMSEntriesMutex;
            // MONITORENTER : "CachedSMSEntriesMutex"
            smsEntries.remove(this.dnRFCStr);
            // MONITOREXIT : string
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
            this.valid = false;
            return;
        }
        catch (SMSException e) {
            SMSEntry.debug.error("Error in reading entry attributes: " + this.dn2Str, e);
            String string = cachedSMSEntriesMutex;
            // MONITORENTER : "CachedSMSEntriesMutex"
            smsEntries.remove(this.dnRFCStr);
            // MONITOREXIT : string
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
            this.valid = false;
            return;
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("SSOToken problem in reading entry attributes: " + this.dn2Str, ssoe);
            String string = cachedSMSEntriesMutex;
            // MONITORENTER : "CachedSMSEntriesMutex"
            smsEntries.remove(this.dnRFCStr);
            // MONITOREXIT : string
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
            this.valid = false;
        }
    }

    SSOToken getValidSSOToken() {
        if (!SMSEntry.tm.isValidToken(this.token)) {
            HashSet<String> removeSSOTokens = new HashSet<String>();
            Iterator items = this.principals.iterator();
            while (items.hasNext()) {
                String tokenID = (String)items.next();
                try {
                    this.token = SMSEntry.tm.createSSOToken(tokenID);
                    if (!SMSEntry.tm.isValidToken(this.token)) continue;
                    break;
                }
                catch (SSOException ssoe) {
                    removeSSOTokens.add(tokenID);
                }
            }
            if (!removeSSOTokens.isEmpty()) {
                HashSet sudoPrincipals = new HashSet(this.principals);
                Iterator items2 = removeSSOTokens.iterator();
                while (items2.hasNext()) {
                    sudoPrincipals.remove(items2.next());
                }
                this.principals = sudoPrincipals;
            }
        }
        if (this.principals.isEmpty()) {
            return null;
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateServiceListeners(String method) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::updateServiceListeners method called: " + this.dn2Str);
        }
        HashSet origServiceObjects = (HashSet)this.serviceObjects.clone();
        Iterator objs = origServiceObjects.iterator();
        while (objs.hasNext()) {
            Iterator iterator = objs;
            synchronized (iterator) {
                Object obj = objs.next();
                try {
                    Method m = obj.getClass().getDeclaredMethod(method, null);
                    m.invoke(obj, (Object[])null);
                }
                catch (Exception e) {
                    SMSEntry.debug.error("CachedSMSEntry::unable to deliver notification(" + this.dn2Str + ")", e);
                }
            }
        }
    }

    void addServiceListener(Object o) {
        if (this.notificationID == null) {
            try {
                Class<?> c = Class.forName("com.sun.identity.sm.CachedSMSEntry");
                SSOToken token = this.getValidSSOToken();
                if (token == null) {
                    return;
                }
                this.notificationID = SMSEventListenerManager.notifyChangesToNode(token, this.smsEntry.getDN(), c.getDeclaredMethod(UPDATE_METHOD, null), this, null);
            }
            catch (Exception ce) {
                SMSEntry.debug.error("CachedSMSEntry::unable to register service objects for notifications: ", ce);
            }
        }
        this.serviceObjects.add(o);
    }

    protected void removeServiceListener(Object o) {
        this.serviceObjects.remove(o);
        if (this.serviceObjects.isEmpty()) {
            SMSEventListenerManager.removeNotification(this.notificationID);
            this.notificationID = null;
        }
    }

    synchronized void addPrincipal(SSOToken t) {
        HashSet<String> sudoPrincipals = new HashSet<String>(this.principals);
        sudoPrincipals.add(((Object)t.getTokenID()).toString());
        this.principals = sudoPrincipals;
    }

    boolean checkPrincipal(SSOToken t) {
        return this.principals.contains(((Object)t.getTokenID()).toString());
    }

    public SMSEntry getSMSEntry() {
        return this.smsEntry;
    }

    public SMSEntry getClonedSMSEntry() {
        try {
            return (SMSEntry)this.smsEntry.clone();
        }
        catch (CloneNotSupportedException c) {
            SMSEntry.debug.error("Unable to clone SMSEntry: " + this.smsEntry, c);
            return null;
        }
    }

    boolean isNewEntry() {
        return this.smsEntry.isNewEntry();
    }

    String getDN() {
        return this.dn2Str;
    }

    void refresh(SMSEntry e) throws SMSException {
        this.smsEntry.refresh(e);
        this.updateServiceListeners(UPDATE_METHOD);
    }

    static CachedSMSEntry getInstance(SSOToken t, ServiceSchemaManagerImpl ssm, String serviceName, String version) throws SMSException {
        String dn = ServiceManager.getServiceNameDN(serviceName, version);
        try {
            return CachedSMSEntry.getInstance(t, dn, ssm);
        }
        catch (SSOException ssoe) {
            SMSEntry.debug.error("SMS: Invalid SSOToken: ", ssoe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CachedSMSEntry getInstance(SSOToken t, String dn, Object obj) throws SMSException, SSOException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance: " + dn);
        }
        String cacheEntry = new DN(dn).toRFCString().toLowerCase();
        CachedSMSEntry answer = null;
        String string = cachedSMSEntriesMutex;
        // MONITORENTER : "CachedSMSEntriesMutex"
        answer = (CachedSMSEntry)smsEntries.get(cacheEntry);
        // MONITOREXIT : string
        if (answer == null) {
            answer = new CachedSMSEntry(new SMSEntry(t, dn));
            String string2 = cachedSMSEntriesMutex;
            // MONITORENTER : "CachedSMSEntriesMutex"
            CachedSMSEntry tmp = (CachedSMSEntry)smsEntries.get(cacheEntry);
            if (tmp == null) {
                smsEntries.put(cacheEntry, answer);
            } else {
                answer = tmp;
            }
            // MONITOREXIT : string2
        }
        if (!answer.checkPrincipal(t)) {
            new SMSEntry(t, dn);
            answer.addPrincipal(t);
        }
        if (obj != null) {
            answer.addServiceListener(obj);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance success: " + dn);
        }
        if (!answer.isNewEntry()) return answer;
        SMSEntry sEntry = answer.getSMSEntry();
        sEntry.dn = dn;
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map sudoSMSEntries = smsEntries;
        String string = cachedSMSEntriesMutex;
        synchronized (cachedSMSEntriesMutex) {
            smsEntries = new CaseInsensitiveHashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Iterator it = sudoSMSEntries.keySet().iterator();
            while (it.hasNext()) {
                CachedSMSEntry curr = (CachedSMSEntry)sudoSMSEntries.get(it.next());
                curr.valid = false;
            }
            return;
        }
    }

    String getXMLSchema() {
        String[] schema = this.smsEntry.getAttributeValues("sunServiceSchema");
        if (schema == null) {
            return null;
        }
        return schema[0];
    }

    void writeXMLSchema(SSOToken token, InputStream xmlServiceSchema) throws SSOException, SMSException, IOException {
        int lengthOfStream = xmlServiceSchema.available();
        byte[] byteArray = new byte[lengthOfStream];
        xmlServiceSchema.read(byteArray, 0, lengthOfStream);
        this.writeXMLSchema(token, new String(byteArray));
    }

    void writeXMLSchema(SSOToken token, String xmlSchema) throws SSOException, SMSException {
        SMSEntry.validateToken(token);
        String[] attrValues = new String[]{xmlSchema};
        SMSEntry e = this.getClonedSMSEntry();
        e.setAttribute("sunServiceSchema", attrValues);
        e.save(token);
        this.refresh(e);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::writeXMLSchema: successfully wrote the XML schema for dn: " + e.getDN());
        }
    }
}

