/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMCallBack;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.common.CallBackHelperBase;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOToken;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CallBackHelper
extends CallBackHelperBase {
    private Hashtable callBackObjects = new Hashtable();
    public static final int CREATE = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 3;

    private AMCallBack instantiateClass(String className) {
        try {
            return (AMCallBack)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException c) {
            debug.error("CallBackHelper.instantiateClass(): Unable to locate class " + className, (Throwable)c);
        }
        catch (Exception e) {
            debug.error("CallBackHelper.instantiateClass(): Unable to instantiate class " + className, (Throwable)e);
        }
        return null;
    }

    private AMCallBack getCallBackObject(String className) {
        AMCallBack callBack = (AMCallBack)this.callBackObjects.get(className);
        if (callBack == null && (callBack = this.instantiateClass(className)) != null) {
            this.callBackObjects.put(className, callBack);
        }
        return callBack;
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, String orgDN) {
        if (!this.isExternalGetAttributesEnabled(orgDN)) {
            return null;
        }
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Map attributes = new HashMap();
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                Map implAttrs;
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null || (implAttrs = impl.getAttributes(token, entryDN, attrNames)) == null || implAttrs.isEmpty()) continue;
                attributes = CommonUtils.mergeMaps(implAttrs, attributes);
            }
            return attributes;
        }
        return null;
    }

    public Map preProcess(SSOToken token, String entryDN, String orgDN, Map oldAttrMap, Map newAttrMap, int operation, int objectType, boolean softDelete) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            Map map = impl.preProcessCreate(token, entryDN, newAttrMap, objectType);
                            newAttrMap = map == null ? newAttrMap : map;
                            break;
                        }
                        case 3: {
                            Map map = impl.preProcessModify(token, entryDN, oldAttrMap, newAttrMap, objectType);
                            newAttrMap = map == null ? newAttrMap : map;
                            break;
                        }
                        case 2: {
                            impl.preProcessDelete(token, entryDN, oldAttrMap, softDelete, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.preProcess(): Preprocessingimpl " + className + " exception thrown by impl:", (Throwable)ae);
                    throw ae;
                }
            }
            return newAttrMap;
        }
        return newAttrMap != null ? newAttrMap : oldAttrMap;
    }

    public AttrSet preProcess(SSOToken token, String entryDN, String orgDN, AttrSet oldAttrSet, AttrSet newAttrSet, int operation, int objectType, boolean softDelete) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Iterator itr = implSet.iterator();
            Map newAttrMap = CommonUtils.attrSetToMap(newAttrSet);
            Map oldAttrMap = CommonUtils.attrSetToMap(oldAttrSet);
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            Map map = impl.preProcessCreate(token, entryDN, newAttrMap, objectType);
                            newAttrMap = map == null ? newAttrMap : map;
                            break;
                        }
                        case 3: {
                            Map map = impl.preProcessModify(token, entryDN, oldAttrMap, newAttrMap, objectType);
                            newAttrMap = map == null ? newAttrMap : map;
                            break;
                        }
                        case 2: {
                            impl.preProcessDelete(token, entryDN, oldAttrMap, softDelete, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.preProcess(): Preprocessingimpl " + className + " exception thrown by impl:", (Throwable)ae);
                    throw ae;
                }
            }
            return CommonUtils.mapToAttrSet(newAttrMap);
        }
        return newAttrSet != null ? newAttrSet : oldAttrSet;
    }

    public void postProcess(SSOToken token, String entryDN, String orgDN, AttrSet oldAttrSet, AttrSet newAttrSet, int operation, int objectType, boolean softDelete) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Map newAttrMap = CommonUtils.attrSetToMap(newAttrSet);
            Map oldAttrMap = CommonUtils.attrSetToMap(oldAttrSet);
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            impl.postProcessCreate(token, entryDN, newAttrMap, objectType);
                            break;
                        }
                        case 3: {
                            impl.postProcessModify(token, entryDN, oldAttrMap, newAttrMap, objectType);
                            break;
                        }
                        case 2: {
                            impl.postProcessDelete(token, entryDN, oldAttrMap, softDelete, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.postProcess(): Preprocessingimpl " + impl.getClass().getName() + " exception thrown: ", (Throwable)ae);
                }
            }
        }
    }

    public void postProcess(SSOToken token, String entryDN, String orgDN, Map oldAttrMap, Map newAttrMap, int operation, int objectType, boolean softDelete) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            impl.postProcessCreate(token, entryDN, newAttrMap, objectType);
                            break;
                        }
                        case 3: {
                            impl.postProcessModify(token, entryDN, oldAttrMap, newAttrMap, objectType);
                            break;
                        }
                        case 2: {
                            impl.postProcessDelete(token, entryDN, oldAttrMap, softDelete, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.postProcess(): Preprocessingimpl " + impl.getClass().getName() + " exception thrown: ", (Throwable)ae);
                }
            }
        }
    }

    public Set preProcessModifyMemberShip(SSOToken token, String entryDN, String orgDN, Set members, int operation, int objectType) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            members = impl.preProcessAddUser(token, entryDN, members, objectType);
                            break;
                        }
                        case 2: {
                            members = impl.preProcessRemoveUser(token, entryDN, members, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.preProcessModifyMemberShip(): Preprocessing impl " + className + " exception " + "thrown by impl:", (Throwable)ae);
                    throw ae;
                }
            }
        }
        return members;
    }

    public void postProcessModifyMemberShip(SSOToken token, String entryDN, String orgDN, Set members, int operation, int objectType) throws AMException {
        Set implSet = this.getPrePostImpls(orgDN);
        if (implSet != null && !implSet.isEmpty()) {
            Iterator itr = implSet.iterator();
            while (itr.hasNext()) {
                String className = (String)itr.next();
                AMCallBack impl = this.getCallBackObject(className);
                if (impl == null) continue;
                try {
                    switch (operation) {
                        case 1: {
                            impl.postProcessAddUser(token, entryDN, members, objectType);
                            break;
                        }
                        case 2: {
                            impl.postProcessRemoveUser(token, entryDN, members, objectType);
                        }
                    }
                }
                catch (AMException ae) {
                    debug.error("CallBackHelper.postProcessModifyMemberShip(): Preprocessing impl " + impl.getClass().getName() + " exception thrown: ", (Throwable)ae);
                }
            }
        }
    }
}

