/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.CookieUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SessionID
implements Serializable {
    private String encryptedString = "";
    private boolean isParsed = false;
    private String sessionServerProtocol = "";
    private String sessionServer = "";
    private String sessionServerPort = "";
    private String sessionServerURI = "";
    protected String sessionDomain = "";
    private String sessionServerID = "";
    private String tail = null;
    private String extensionPart = null;
    private Map extensions = new HashMap();
    private static String cookieName = null;
    private static boolean hexEncodeCookie = false;
    private static Debug debug;
    private Boolean cookieMode = null;
    public static final String PRIMARY_ID = "S1";
    public static final String STORAGE_KEY = "SK";
    public static final String SITE_ID = "SI";

    public SessionID(HttpServletRequest request) {
        String cookieValue = null;
        if (cookieName != null) {
            cookieValue = CookieUtils.getCookieValueFromReq((HttpServletRequest)request, (String)cookieName);
            if (cookieValue == null) {
                String realReqSid = SessionEncodeURL.getSidFromURL(request);
                if (realReqSid != null) {
                    this.encryptedString = realReqSid;
                }
                this.cookieMode = Boolean.FALSE;
            } else {
                this.cookieMode = Boolean.TRUE;
                this.encryptedString = cookieValue;
            }
        }
    }

    public SessionID(String sid) {
        this.encryptedString = sid;
    }

    public boolean isNull() {
        return SessionID.isNull(this.encryptedString);
    }

    private static boolean isNull(String s) {
        return s == null || s.length() == 0;
    }

    public String getSessionServerURI() {
        if (SessionID.isNull(this.sessionServerURI)) {
            this.parseSessionString();
        }
        return this.sessionServerURI;
    }

    public String getSessionServerProtocol() {
        if (SessionID.isNull(this.sessionServerProtocol)) {
            this.parseSessionString();
        }
        return this.sessionServerProtocol;
    }

    public String getSessionServerPort() {
        if (SessionID.isNull(this.sessionServerPort)) {
            this.parseSessionString();
        }
        return this.sessionServerPort;
    }

    public String getSessionServer() {
        if (SessionID.isNull(this.sessionServer)) {
            this.parseSessionString();
        }
        return this.sessionServer;
    }

    public String getSessionDomain() {
        return this.sessionDomain;
    }

    public String getSessionServerID() {
        if (SessionID.isNull(this.sessionServerID)) {
            this.parseSessionString();
        }
        return this.sessionServerID;
    }

    public String toString() {
        return this.encryptedString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SessionID)) {
            return false;
        }
        SessionID another = (SessionID)object;
        return this.encryptedString.equals(another.encryptedString);
    }

    public int hashCode() {
        return this.encryptedString.hashCode();
    }

    private void parseSessionString() {
        if (this.isParsed) {
            return;
        }
        if (this.isNull()) {
            throw new IllegalArgumentException("sid value is null or empty");
        }
        try {
            String serverID;
            int outerIndex;
            String plainString = this.encryptedString;
            if (hexEncodeCookie) {
                plainString = SessionID.hexToString(this.encryptedString);
            }
            if ((outerIndex = plainString.lastIndexOf("@")) == -1) {
                this.isParsed = true;
                return;
            }
            String outer = plainString.substring(outerIndex + 1);
            int tailIndex = outer.indexOf("#");
            this.tail = outer.substring(tailIndex + 1);
            if (tailIndex != -1) {
                this.extensionPart = outer.substring(0, tailIndex);
                DataInputStream extensionStr = new DataInputStream(new ByteArrayInputStream(Base64.decode((String)this.extensionPart)));
                HashMap<String, String> extMap = new HashMap<String, String>();
                while (true) {
                    String extName;
                    try {
                        extName = extensionStr.readUTF();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    String extValue = extensionStr.readUTF();
                    extMap.put(extName, extValue);
                }
                this.extensions = extMap;
            }
            if ((serverID = (String)this.extensions.get(SITE_ID)) != null) {
                this.setServerID(serverID);
            }
        }
        catch (Exception e) {
            debug.error("Invalid sessionid format", (Throwable)e);
            throw new IllegalArgumentException("Invalid sessionid format" + e);
        }
        this.isParsed = true;
    }

    protected void setServerID(String id) {
        try {
            URL url = new URL(WebtopNaming.getServerFromID(id));
            this.sessionServerID = id;
            this.sessionServerProtocol = url.getProtocol();
            this.sessionServer = url.getHost();
            this.sessionServerPort = String.valueOf(url.getPort());
            this.sessionServerURI = url.getPath();
            int idx = this.sessionServerURI.lastIndexOf(47);
            while (idx > 0) {
                this.sessionServerURI = this.sessionServerURI.substring(0, idx);
                idx = this.sessionServerURI.lastIndexOf(47);
            }
        }
        catch (Exception e) {
            debug.error("Could not get server info from sessionid", (Throwable)e);
            throw new IllegalArgumentException("Invalid server id in session id " + e);
        }
    }

    public String getTail() {
        this.parseSessionString();
        return this.tail;
    }

    public Boolean getCookieMode() {
        return this.cookieMode;
    }

    public String getExtension(String name) {
        this.parseSessionString();
        return (String)this.extensions.get(name);
    }

    public static String makeSessionID(String encryptedID, Map extensions, String tail) throws SessionException {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(encryptedID);
            if (extensions != null || tail != null) {
                buf.append("@");
            }
            if (extensions != null) {
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(baOut);
                Iterator iter = extensions.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    dataOut.writeUTF((String)entry.getKey());
                    dataOut.writeUTF((String)entry.getValue());
                }
                dataOut.close();
                buf.append(Base64.encode((byte[])baOut.toByteArray()));
                buf.append("#");
            }
            if (tail != null) {
                buf.append(tail);
            }
            String returnValue = buf.toString();
            if (hexEncodeCookie) {
                returnValue = SessionID.stringToHex(returnValue);
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public static String makeRelatedSessionID(String encryptedID, SessionID prototype) throws SessionException {
        prototype.parseSessionString();
        return SessionID.makeSessionID(encryptedID, prototype.extensions, prototype.tail);
    }

    private static String hexToString(String hexString) {
        String plainString = hexString;
        StringBuffer sb = new StringBuffer();
        if (hexString != null && hexString.length() != 0) {
            int l = hexString.length();
            for (int i = 0; i < l; i += 2) {
                int c1 = hexString.charAt(i);
                int c2 = hexString.charAt(i + 1);
                c1 = c1 >= 97 ? c1 - 97 + 10 : (c1 -= 48);
                c2 = c2 >= 97 ? c2 - 97 + 10 : (c2 -= 48);
                sb.append((char)(16 * c1 + c2));
            }
            plainString = sb.toString();
        }
        return plainString;
    }

    private static String stringToHex(String plainString) {
        String hexString = plainString;
        StringBuffer sb = new StringBuffer();
        if (plainString != null && plainString.length() != 0) {
            int l = plainString.length();
            for (int i = 0; i < l; ++i) {
                sb.append(Integer.toHexString(plainString.charAt(i)));
            }
            hexString = sb.toString();
        }
        return hexString;
    }

    static {
        cookieName = System.getProperty("com.iplanet.am.cookie.name");
        if (cookieName == null) {
            cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        hexEncodeCookie = Boolean.valueOf(SystemProperties.get("com.iplanet.am.cookie.hexEncode", "false"));
        debug = Debug.getInstance((String)"amSession");
        if (debug.messageEnabled()) {
            debug.message("SessionID.static block():cookie.name=" + cookieName + "," + "hexEncodeCookie=" + hexEncodeCookie);
        }
    }
}

