/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.dpro.session.jdbc.JDBCConnectionImpl;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.shared.debug.Debug;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class JDBCConnectionPool
implements DataSource,
ConnectionEventListener {
    private int maxPoolSize;
    private int steadyPoolSize;
    private int maxWaitTime;
    private boolean requireConnectionValidation = false;
    private boolean failAllConnections = false;
    private int isolationLevel;
    private static boolean isIsolationSet = false;
    private PrintWriter logWriter;
    private int loginTimeout;
    private boolean poolInitialized = false;
    private Map connectionStates;
    private Map free;
    private ConnectionPoolDataSource poolDS;
    private JDBCConnectionImpl jdbcProvider;
    Debug debug = SessionService.sessionDebug;

    public JDBCConnectionPool() throws Exception {
        this.setMaxPoolSize(SessionService.getMaxPoolSize());
        this.setSteadyPoolSize(SessionService.getMinPoolSize());
        this.setMaxWaitTime(SessionService.getConnectionMaxWaitTime());
        String jdbcDriverImpl = SessionService.getJdbcDriverClass();
        this.jdbcProvider = (JDBCConnectionImpl)Class.forName(jdbcDriverImpl).newInstance();
        this.jdbcProvider.init(SessionService.getJdbcURL(), SessionService.getSessionStoreUserName(), SessionService.getSessionStorePassword());
        this.poolDS = this.jdbcProvider.getConnectionPoolDataSource();
    }

    private synchronized void initPool() throws SQLException {
        if (this.poolInitialized) {
            return;
        }
        this.connectionStates = new HashMap(this.getSteadyPoolSize());
        this.free = new HashMap(this.getSteadyPoolSize());
        this.createSteadyConnections();
        this.poolInitialized = true;
    }

    private static boolean isValid(Connection c) {
        try {
            c.setAutoCommit(false);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection result = null;
        long startTime = 0L;
        long elapsedWaitTime = 0L;
        long remainingWaitTime = 0L;
        if (this.getMaxWaitTime() > 0) {
            startTime = System.currentTimeMillis();
        }
        while ((result = this.internalGetConnection()) == null) {
            if (this.getMaxWaitTime() > 0) {
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                if (elapsedWaitTime < (long)this.getMaxWaitTime()) {
                    remainingWaitTime = (long)this.getMaxWaitTime() - elapsedWaitTime;
                } else {
                    throw new SQLException("No available connection. Wait-time expired.");
                }
            }
            JDBCConnectionPool jDBCConnectionPool = this;
            synchronized (jDBCConnectionPool) {
                block10: {
                    try {
                        if (this.free.size() != 0) break block10;
                        this.wait(remainingWaitTime);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        return result;
    }

    private synchronized Connection internalGetConnection() throws SQLException {
        this.initPool();
        Connection result = null;
        PooledConnection c = null;
        ConnectionState state = null;
        Iterator iter = this.free.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry entry = iter.next();
            c = (PooledConnection)entry.getKey();
            state = (ConnectionState)entry.getValue();
            state.setBusy(true);
            this.free.remove(c);
        }
        if (c != null) {
            result = c.getConnection();
            if (this.isRequireConnectionValidation()) {
                boolean valid = false;
                try {
                    valid = JDBCConnectionPool.isValid(result);
                }
                catch (Exception ex) {
                    valid = false;
                }
                if (!valid) {
                    if (this.failAllConnections) {
                        result = this.failAllConnections();
                    } else {
                        this.connectionStates.remove(c);
                        this.destroyConnection(c);
                        result = null;
                    }
                }
            }
        }
        if (result == null && this.connectionStates.size() < this.getMaxPoolSize()) {
            c = this.createConnection(true);
            result = c.getConnection();
        }
        if (result != null) {
            if (!isIsolationSet) {
                DatabaseMetaData dbMetaData = result.getMetaData();
                if (dbMetaData.supportsTransactionIsolationLevel(4)) {
                    this.setIsolationLevel(4);
                    SessionService.sessionDebug.message("JDBCConnectionPool IsolationLevel set to TRANSACTION_REPEATABLE_READ");
                } else {
                    this.setIsolationLevel(2);
                    SessionService.sessionDebug.message("JDBCConnectionPool IsolationLevel set to TRANSACTION_READ_COMMITTED");
                }
                isIsolationSet = true;
            }
            result.setAutoCommit(false);
            result.setTransactionIsolation(this.isolationLevel);
        }
        return result;
    }

    private PooledConnection createConnection(boolean busy) throws SQLException {
        PooledConnection c = this.poolDS.getPooledConnection();
        ConnectionState state = new ConnectionState();
        state.setBusy(busy);
        c.addConnectionEventListener(this);
        this.connectionStates.put(c, state);
        if (!busy) {
            this.free.put(c, state);
            this.notifyAll();
        }
        return c;
    }

    private Connection failAllConnections() throws SQLException {
        Connection result = null;
        this.emptyPool();
        this.createSteadyConnections();
        if (this.free.size() > 0) {
            Map.Entry entry = (Map.Entry)this.free.keySet().iterator().next();
            PooledConnection c = (PooledConnection)entry.getKey();
            ConnectionState state = (ConnectionState)entry.getValue();
            state.setBusy(true);
            this.free.remove(c);
            result = c.getConnection();
        }
        return result;
    }

    void reinitializePoolDataSource() throws SQLException {
        this.jdbcProvider.init(SessionService.getJdbcURL(), SessionService.getSessionStoreUserName(), SessionService.getSessionStorePassword());
        this.poolDS = this.jdbcProvider.getConnectionPoolDataSource();
        this.emptyPool();
        this.createSteadyConnections();
    }

    private synchronized void createSteadyConnections() throws SQLException {
        for (int i = 0; i < this.getSteadyPoolSize(); ++i) {
            this.createConnection(false);
        }
    }

    private void destroyConnection(PooledConnection c) {
        try {
            c.removeConnectionEventListener(this);
            c.close();
        }
        catch (SQLException ex) {
            this.debug.message("JDBCConnectionPool:destroyConnection", (Throwable)ex);
        }
    }

    public synchronized void connectionClosed(ConnectionEvent evt) {
        PooledConnection con = (PooledConnection)evt.getSource();
        ConnectionState state = this.getConnectionState(con);
        if (state == null || !state.isBusy()) {
            throw new IllegalStateException();
        }
        state.setBusy(false);
        state.touchTimestamp();
        this.free.put(con, state);
        this.notifyAll();
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        PooledConnection con = (PooledConnection)evt.getSource();
        ConnectionState state = this.getConnectionState(con);
        if (state == null || !state.isBusy()) {
            throw new IllegalStateException();
        }
        this.connectionStates.remove(con);
        this.destroyConnection(con);
    }

    private ConnectionState getConnectionState(PooledConnection c) {
        return (ConnectionState)this.connectionStates.get(c);
    }

    public synchronized void emptyPool() {
        Iterator i = this.connectionStates.keySet().iterator();
        while (i.hasNext()) {
            this.destroyConnection((PooledConnection)i.next());
        }
        this.free.clear();
        this.connectionStates.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pool [");
        sb.append("] PoolSize=");
        sb.append(this.connectionStates.size());
        sb.append("  FreeConnections=");
        sb.append(this.free.size());
        return sb.toString();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setSteadyPoolSize(int steadyPoolSize) {
        this.steadyPoolSize = Math.min(steadyPoolSize, this.maxPoolSize);
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setRequireConnectionValidation(boolean requireConnectionValidation) {
        this.requireConnectionValidation = requireConnectionValidation;
    }

    public boolean isRequireConnectionValidation() {
        return this.requireConnectionValidation;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public static class ConnectionState {
        private boolean busy;
        private long timestamp;

        public boolean isFree() {
            return !this.busy;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public void setBusy(boolean busy) {
            this.busy = busy;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public ConnectionState() {
            this.touchTimestamp();
        }
    }
}

