/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.shared.debug.Debug;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionCount {
    private static Map uuidSessionMap = Collections.synchronizedMap(new HashMap());
    static final int SINGLE_SERVER_MODE = 1;
    static final int MULTI_SERVER_MODE = 2;
    static final int SFO_MODE = 3;
    private static int deploymentMode = 0;
    private static Debug debug = SessionService.sessionDebug;
    private static SSOToken adminToken = null;

    static int getDeploymentMode() {
        return deploymentMode;
    }

    static SessionService getSS() {
        SessionService ss = SessionService.getSessionService();
        if (ss == null) {
            debug.error("SessionConstraint:  Failed to get the session service instance");
        }
        return ss;
    }

    public static Map getAllSessionsByUUID(String uuid) throws Exception {
        Map sessions = null;
        switch (deploymentMode) {
            case 1: {
                sessions = SessionCount.getSessionsFromLocalServer(uuid);
                break;
            }
            case 2: {
                sessions = SessionCount.getSessionsFromPeerServers(uuid);
                break;
            }
            case 3: {
                sessions = SessionCount.getSessionsFromRepository(uuid);
                break;
            }
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getSessionsFromLocalServer(String uuid) {
        Set sessions = (Set)uuidSessionMap.get(uuid);
        HashMap<String, Long> retSessions = new HashMap<String, Long>();
        if (sessions != null) {
            Set set = sessions;
            synchronized (set) {
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    SessionID sid = (SessionID)i.next();
                    InternalSession is = SessionCount.getSS().getInternalSession(sid);
                    retSessions.put(sid.toString(), new Long(is.getExpirationTime()));
                }
            }
        }
        return retSessions;
    }

    private static Map getSessionsFromPeerServers(String uuid) {
        Map sessions = SessionCount.getSessionsFromLocalServer(uuid);
        String localServerID = SessionCount.getSS().getLocalServerID();
        Set serverIDs = null;
        try {
            serverIDs = WebtopNaming.getSiteNodes(localServerID);
        }
        catch (Exception e) {
            debug.error("Failed to get the serverIDs from WebtopNaming.", (Throwable)e);
            return sessions;
        }
        Iterator m = serverIDs.iterator();
        while (m.hasNext()) {
            String serverID = (String)m.next();
            if (serverID.equals(localServerID)) continue;
            try {
                URL svcurl = Session.getSessionServiceURL(serverID);
                SessionRequest sreq = new SessionRequest(7, ((Object)SessionCount.getAdminToken().getTokenID()).toString(), false);
                sreq.setUUID(uuid);
                SessionResponse sres = SessionCount.getSessionResponse(svcurl, sreq);
                sessions.putAll(sres.getSessionsForGivenUUID());
            }
            catch (SessionException se) {
                if (!debug.messageEnabled()) continue;
                debug.message("SessionConstraint: peer AM server is down...");
            }
        }
        return sessions;
    }

    private static Map getSessionsFromRepository(String uuid) throws Exception {
        AMSessionRepository repo = SessionService.getSessionService().getRepository();
        Map sessions = null;
        try {
            sessions = repo.getSessionsByUUID(uuid);
        }
        catch (Exception e) {
            debug.error("SessionCount.getSessionsFromRepository: Session repository is not available", (Throwable)e);
            throw e;
        }
        return sessions;
    }

    static void incrementSessionCount(InternalSession is) {
        if (deploymentMode == 1) {
            Set<SessionID> sessions = (Set<SessionID>)uuidSessionMap.get(is.getUUID());
            if (sessions != null) {
                sessions.add(is.getID());
            } else {
                sessions = Collections.synchronizedSet(new HashSet());
                sessions.add(is.getID());
                uuidSessionMap.put(is.getUUID(), sessions);
            }
        }
    }

    static void decrementSessionCount(InternalSession is) {
        Set sessions;
        String uuid = is.getUUID();
        SessionID sid = is.getID();
        if (deploymentMode == 1 && (sessions = (Set)uuidSessionMap.get(uuid)) != null) {
            sessions.remove(sid);
            if (sessions.isEmpty()) {
                uuidSessionMap.remove(uuid);
            }
        }
    }

    private static SessionResponse getSessionResponse(URL svcurl, SessionRequest sreq) throws SessionException {
        try {
            SessionResponse sres;
            Object context = RestrictedTokenContext.getCurrent();
            if (context != null) {
                sreq.setRequester(RestrictedTokenContext.marshal(context));
            }
            if ((sres = Session.sendPLLRequest(svcurl, sreq)).getException() != null) {
                throw new SessionException(sres.getException());
            }
            return sres;
        }
        catch (SessionException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    static SSOToken getAdminToken() {
        if (adminToken == null) {
            try {
                adminToken = SessionCount.getSS().getSessionServiceToken();
            }
            catch (Exception e) {
                debug.error("Failed to get the admin token for Session constraint checking.", (Throwable)e);
            }
        }
        return adminToken;
    }

    static {
        try {
            SSOTokenManager.getInstance();
        }
        catch (Exception ssoe) {
            debug.error("SessionConstraint: Failied to get the SSOTokenManager instance.");
        }
        deploymentMode = SessionCount.getSS().isSiteEnabled() ? (SessionCount.getSS().isSessionFailoverEnabled() ? 3 : 2) : 1;
    }
}

