/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.ums.AccessRightObject;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import netscape.ldap.util.DN;

public class Resource
extends PersistentObject {
    private static Debug debug = Debug.getInstance((String)"amSDK");
    static final String NEW_INSTANCE_FAILED = "newinstancefailed";
    private static final Class _class = Resource.class;

    protected Resource() throws UMSException {
    }

    Resource(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    Resource(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public Resource(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public AttrSet getAttributes(SearchTemplate template) throws UMSException {
        AttrSet attrSet = new AttrSet();
        String[] attrNames = template.getAttributeNames();
        for (int i = 0; i < attrNames.length; ++i) {
            attrSet.add(this.getAttribute(attrNames[i]));
        }
        return attrSet;
    }

    public AccessRightObject getAccessRight(Guid guid) throws UMSException, ACIParseException {
        AccessRightObject aro = new AccessRightObject();
        Collection roles = this.getRoles();
        Iterator it = roles.iterator();
        if (it != null) {
            if (debug.messageEnabled()) {
                debug.message("Resource.getAccessRight : Get rights for : " + guid.getDn());
            }
            DN guidDn = new DN(guid.getDn());
            while (it.hasNext()) {
                Guid roleGuid = new Guid((String)it.next());
                DN roleGuidDn = new DN(roleGuid.getDn());
                if (debug.messageEnabled()) {
                    debug.message("Resource.getAccessRight : Role Dn : " + roleGuid.getDn());
                }
                if (roleGuidDn.getParent().isDescendantOf(guidDn)) continue;
                BaseRole role = (BaseRole)UMSObject.getObject(this.getPrincipal(), roleGuid);
                if (debug.messageEnabled()) {
                    debug.message("Resource.getAccessRight : Role " + role.getGuid());
                }
                AccessRightObject right = role.getAccessRight();
                aro.grantReadPermission(right.getReadableAttributeNames());
                aro.grantWritePermission(right.getWritableAttributeNames());
                debug.message("Resource.getAccessRight : Done grant");
            }
        }
        return aro;
    }
}

