/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.distUI;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.UI.AuthViewBeanBase;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.distUI.LoginViewBean;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthExceptionViewBean
extends AuthViewBeanBase {
    public static final String PAGE_NAME = "AuthException";
    static Debug exDebug = Debug.getInstance((String)"amAuthExceptionViewBean");
    HttpServletRequest request;
    HttpServletResponse response;
    HttpSession session;
    ServletContext servletContext;
    AuthContext ac = null;
    public String ResultVal = "";
    private static String LOGINURL = "";
    public ResourceBundle rb = null;
    private Locale locale = null;
    String orgName = "";
    String indexName = "";
    AuthContext.IndexType indexType;
    public static final String URL_LOGIN = "urlLogin";
    public static final String TXT_EXCEPTION = "StaticTextException";
    public static final String TXT_GOTO_LOGIN_AFTER_FAIL = "txtGotoLoginAfterFail";
    public static final String HTML_TITLE_AUTH_EXCEPTION = "htmlTitle_AuthException";

    public AuthExceptionViewBean() {
        super(PAGE_NAME);
        exDebug.message("AuthExceptionViewBean() constructor called");
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(URL_LOGIN, StaticTextField.class);
        this.registerChild(TXT_EXCEPTION, StaticTextField.class);
        this.registerChild(TXT_GOTO_LOGIN_AFTER_FAIL, StaticTextField.class);
    }

    public void forwardTo(RequestContext requestContext) {
        exDebug.message("In forwardTo()");
        if (requestContext != null) {
            this.request = requestContext.getRequest();
            this.response = requestContext.getResponse();
            this.servletContext = requestContext.getServletContext();
            this.session = this.request.getSession();
        }
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Expires", "0");
        try {
            if (this.session.isNew()) {
                exDebug.message("New Request");
                ISLocaleContext localeContext = new ISLocaleContext();
                localeContext.setLocale(this.request);
                this.locale = localeContext.getLocale();
            } else {
                exDebug.message("Existing request");
                this.locale = (Locale)this.session.getAttribute("Locale");
                this.ac = (AuthContext)this.session.getAttribute("AuthContext");
                this.orgName = (String)this.session.getAttribute("OrgName");
                this.indexType = AuthClientUtils.getIndexType((String)this.session.getAttribute("IndexType"));
                this.indexName = (String)this.session.getAttribute("IndexName");
            }
            if (exDebug.messageEnabled()) {
                exDebug.message("JSPLocale = " + this.locale);
                exDebug.message("AuthContext : " + this.ac);
            }
            this.session.invalidate();
        }
        catch (Exception e) {
            this.ResultVal = e instanceof L10NMessage ? ((L10NMessage)e).getL10NMessage(this.locale) : e.getMessage();
        }
        if (this.ac == null) {
            try {
                if (exDebug.messageEnabled()) {
                    exDebug.message("Goto Login URL : " + LOGINURL);
                }
                this.response.sendRedirect(LOGINURL);
            }
            catch (Exception exception) {}
        } else {
            super.forwardTo(requestContext);
        }
    }

    public String getDisplayURL() {
        exDebug.message("In getDisplayURL()");
        this.rb = rbCache.getResBundle("amAuthUI", this.locale);
        if (this.rb == null) {
            return AuthClientUtils.getFileName("Exception.jsp", this.locale.toString(), this.orgName, this.request, this.servletContext, this.indexType, this.indexName);
        }
        return AuthClientUtils.getFileName("authException.jsp", this.locale.toString(), this.orgName, this.request, this.servletContext, this.indexType, this.indexName);
    }

    protected View createChild(String name) {
        if (exDebug.messageEnabled()) {
            exDebug.message("In createChild() : child name = " + name);
        }
        if (name.equals(TXT_EXCEPTION)) {
            return new StaticTextField((ContainerView)this, name, (Object)this.ResultVal);
        }
        if (name.equals(TXT_GOTO_LOGIN_AFTER_FAIL)) {
            return new StaticTextField((ContainerView)this, name, (Object)"");
        }
        if (name.equals(URL_LOGIN)) {
            String loginURL = AuthClientUtils.encodeURL(LOGINURL, this.request, this.ac);
            return new StaticTextField((ContainerView)this, name, (Object)loginURL);
        }
        if (name.equals(HTML_TITLE_AUTH_EXCEPTION)) {
            String exceptionTitle = this.rb.getString(HTML_TITLE_AUTH_EXCEPTION);
            return new StaticTextField((ContainerView)this, name, (Object)exceptionTitle);
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        SessionID sessionID = AuthClientUtils.getSessionIDFromRequest(this.request);
        try {
            String cookieDomain = null;
            Set cookieDomainSet = AuthClientUtils.getCookieDomains();
            this.setPageEncoding(this.request, this.response);
            if (cookieDomainSet.isEmpty()) {
                Cookie cookie = AuthClientUtils.getLogoutCookie(sessionID, null);
                this.response.addCookie(cookie);
            } else {
                Iterator iter = cookieDomainSet.iterator();
                while (iter.hasNext()) {
                    cookieDomain = (String)iter.next();
                    Cookie cookie = AuthClientUtils.getLogoutCookie(sessionID, cookieDomain);
                    this.response.addCookie(cookie);
                }
            }
            AuthClientUtils.clearlbCookie(this.response);
            this.ResultVal = this.rb.getString("uncaught_exception");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exDebug.messageEnabled()) {
                exDebug.message("error in getting Exception : " + e.getMessage());
            }
            this.ResultVal = this.rb.getString("uncaught_exception") + " : " + e.getMessage();
        }
    }

    public void handleHrefExceptionRequest(RequestInvocationEvent event) throws ServletException, IOException {
        ViewBean targetView = this.getViewBean(LoginViewBean.class);
        targetView.forwardTo(this.getRequestContext());
    }

    public boolean beginHrefExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    public boolean beginContentHrefExceptionDisplay(ChildDisplayEvent event) {
        this.setDisplayFieldValue(TXT_GOTO_LOGIN_AFTER_FAIL, this.rb.getString("gotoLoginAfterFail"));
        return true;
    }

    public boolean beginStaticTextExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    public String getTileIndex() {
        return "";
    }

    public boolean beginContentStaticTextExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    static {
        LOGINURL = serviceUri + "/UI/Login";
    }
}

